/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.api.metadata.ds.v11;

import java.util.HashMap;
import java.util.Map;
import org.jboss.jca.common.api.metadata.ds.v11.DsXaPool;

public interface XaDataSource
extends org.jboss.jca.common.api.metadata.ds.XaDataSource {
    @Override
    public DsXaPool getXaPool();

    public static enum Attribute {
        JNDI_NAME("jndi-name"),
        POOL_NAME("pool-name"),
        ENABLED("enabled"),
        USE_JAVA_CONTEXT("use-java-context"),
        SPY("spy"),
        USE_CCM("use-ccm");

        private final String name;

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Tag {
        UNKNOWN(null),
        XA_DATASOURCE_PROPERTY("xa-datasource-property"),
        XA_DATASOURCE_CLASS("xa-datasource-class"),
        DRIVER("driver"),
        TRANSACTION_ISOLATION("transaction-isolation"),
        TIMEOUT("timeout"),
        SECURITY("security"),
        STATEMENT("statement"),
        VALIDATION("validation"),
        URL_DELIMITER("url-delimiter"),
        URL_SELECTOR_STRATEGY_CLASS_NAME("url-selector-strategy-class-name"),
        NEW_CONNECTION_SQL("new-connection-sql"),
        XA_POOL("xa-pool"),
        RECOVERY("recovery");

        private final String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

