/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.annotations;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.resource.spi.Activation;
import javax.resource.spi.AdministeredObject;
import javax.resource.spi.ConnectionDefinitions;
import javax.resource.spi.Connector;
import javax.resource.spi.TransactionSupport;
import org.jboss.jca.common.annotations.SecurityActions;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.ra.AdminObject;
import org.jboss.jca.common.api.metadata.ra.AuthenticationMechanism;
import org.jboss.jca.common.api.metadata.ra.ConfigProperty;
import org.jboss.jca.common.api.metadata.ra.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.ra.CredentialInterfaceEnum;
import org.jboss.jca.common.api.metadata.ra.Icon;
import org.jboss.jca.common.api.metadata.ra.InboundResourceAdapter;
import org.jboss.jca.common.api.metadata.ra.LicenseType;
import org.jboss.jca.common.api.metadata.ra.LocalizedXsdString;
import org.jboss.jca.common.api.metadata.ra.MergeableMetadata;
import org.jboss.jca.common.api.metadata.ra.MessageListener;
import org.jboss.jca.common.api.metadata.ra.Path;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter1516;
import org.jboss.jca.common.api.metadata.ra.SecurityPermission;
import org.jboss.jca.common.api.metadata.ra.XsdString;
import org.jboss.jca.common.api.metadata.ra.ra16.ConfigProperty16;
import org.jboss.jca.common.api.metadata.ra.ra16.Connector16;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.ra.common.AdminObjectImpl;
import org.jboss.jca.common.metadata.ra.common.AuthenticationMechanismImpl;
import org.jboss.jca.common.metadata.ra.common.ConnectionDefinitionImpl;
import org.jboss.jca.common.metadata.ra.common.InboundResourceAdapterImpl;
import org.jboss.jca.common.metadata.ra.common.MessageAdapterImpl;
import org.jboss.jca.common.metadata.ra.common.MessageListenerImpl;
import org.jboss.jca.common.metadata.ra.common.OutboundResourceAdapterImpl;
import org.jboss.jca.common.metadata.ra.common.ResourceAdapter1516Impl;
import org.jboss.jca.common.metadata.ra.common.SecurityPermissionImpl;
import org.jboss.jca.common.metadata.ra.ra16.Activationspec16Impl;
import org.jboss.jca.common.metadata.ra.ra16.ConfigProperty16Impl;
import org.jboss.jca.common.metadata.ra.ra16.Connector16Impl;
import org.jboss.jca.common.spi.annotations.repository.Annotation;
import org.jboss.jca.common.spi.annotations.repository.AnnotationRepository;
import org.jboss.logging.Logger;

public class Annotations {
    private static Logger log = Logger.getLogger(Annotations.class);
    private static boolean trace = log.isTraceEnabled();

    public org.jboss.jca.common.api.metadata.ra.Connector merge(org.jboss.jca.common.api.metadata.ra.Connector connector, AnnotationRepository annotationRepository) throws Exception {
        if (connector == null || connector.getVersion() == Connector.Version.V_16) {
            boolean isMetadataComplete = false;
            if (connector != null && connector instanceof Connector16) {
                isMetadataComplete = ((Connector16)connector).isMetadataComplete();
            }
            if (connector == null || !isMetadataComplete) {
                if (connector == null) {
                    org.jboss.jca.common.api.metadata.ra.Connector annotationsConnector;
                    connector = annotationsConnector = this.process(annotationRepository, null);
                } else {
                    org.jboss.jca.common.api.metadata.ra.Connector annotationsConnector = this.process(annotationRepository, ((ResourceAdapter1516)connector.getResourceadapter()).getResourceadapterClass());
                    connector = (org.jboss.jca.common.api.metadata.ra.Connector)connector.merge((MergeableMetadata)annotationsConnector);
                }
            }
        }
        return connector;
    }

    public org.jboss.jca.common.api.metadata.ra.Connector process(AnnotationRepository annotationRepository, String xmlResourceAdapterClass) throws Exception {
        ArrayList<ConnectionDefinition> definitions;
        if (annotationRepository == null) {
            throw new ValidateException("AnnotationRepository reference is null");
        }
        Map<Metadatas, ArrayList<ConfigProperty16>> configPropertiesMap = this.processConfigProperty(annotationRepository);
        ArrayList<Object> connectionDefinitions = this.processConnectionDefinitions(annotationRepository, configPropertiesMap == null ? null : configPropertiesMap.get((Object)Metadatas.MANAGED_CONN_FACTORY));
        if (connectionDefinitions == null) {
            connectionDefinitions = new ArrayList(1);
        }
        if ((definitions = this.processConnectionDefinition(annotationRepository, configPropertiesMap == null ? null : configPropertiesMap.get((Object)Metadatas.MANAGED_CONN_FACTORY))) != null) {
            connectionDefinitions.addAll(definitions);
        }
        connectionDefinitions.trimToSize();
        InboundResourceAdapter inboundRA = this.processActivation(annotationRepository, configPropertiesMap == null ? null : configPropertiesMap.get((Object)Metadatas.ACTIVATION_SPEC));
        ArrayList<AdminObject> adminObjs = this.processAdministeredObject(annotationRepository);
        org.jboss.jca.common.api.metadata.ra.Connector conn = this.processConnector(annotationRepository, xmlResourceAdapterClass, connectionDefinitions, configPropertiesMap == null ? null : configPropertiesMap.get((Object)Metadatas.RA), inboundRA, adminObjs);
        return conn;
    }

    private org.jboss.jca.common.api.metadata.ra.Connector processConnector(AnnotationRepository annotationRepository, String xmlResourceAdapterClass, ArrayList<ConnectionDefinition> connectionDefinitions, ArrayList<ConfigProperty16> configProperties, InboundResourceAdapter inboundResourceadapter, ArrayList<AdminObject> adminObjs) throws Exception {
        org.jboss.jca.common.api.metadata.ra.Connector connector = null;
        Collection values = annotationRepository.getAnnotation(Connector.class);
        if (values != null) {
            if (values.size() == 1) {
                Annotation annotation = (Annotation)values.iterator().next();
                String raClass = annotation.getClassName();
                Connector connectorAnnotation = (Connector)annotation.getAnnotation();
                if (trace) {
                    log.trace((Object)("Processing: " + connectorAnnotation + " for " + raClass));
                }
                connector = this.attachConnector(raClass, connectorAnnotation, connectionDefinitions, configProperties, inboundResourceadapter, adminObjs);
            } else if (values.size() == 0) {
                if (xmlResourceAdapterClass == null || xmlResourceAdapterClass.equals("")) {
                    log.fatal((Object)"No @Connector was found and no definition in the ra.xml metadata either");
                    throw new ValidateException("No @Connector defined");
                }
            } else if (xmlResourceAdapterClass == null || xmlResourceAdapterClass.equals("")) {
                log.fatal((Object)"More than one @Connector was found but the correct one wasn't defined in the ra.xml metadata");
                throw new ValidateException("More than one @Connector defined");
            }
        }
        return connector;
    }

    private org.jboss.jca.common.api.metadata.ra.Connector attachConnector(String raClass, Connector conAnnotation, ArrayList<ConnectionDefinition> connectionDefinitions, ArrayList<ConfigProperty16> configProperties, InboundResourceAdapter inboundResourceadapter, ArrayList<AdminObject> adminObjs) throws Exception {
        XsdString vendorName = new XsdString(conAnnotation.vendorName(), null);
        ArrayList<LocalizedXsdString> descriptions = null;
        if (conAnnotation.description() != null && conAnnotation.description().length != 0) {
            descriptions = new ArrayList<LocalizedXsdString>(conAnnotation.description().length);
            for (String descriptionAnnoptation : conAnnotation.description()) {
                descriptions.add(new LocalizedXsdString(descriptionAnnoptation, null));
            }
        }
        ArrayList<LocalizedXsdString> displayNames = null;
        if (conAnnotation.description() != null && conAnnotation.displayName().length != 0) {
            displayNames = new ArrayList<LocalizedXsdString>(conAnnotation.displayName().length);
            for (String displayNameAnnotation : conAnnotation.displayName()) {
                displayNames.add(new LocalizedXsdString(displayNameAnnotation, null));
            }
        }
        XsdString eisType = new XsdString(conAnnotation.eisType(), null);
        ArrayList<LocalizedXsdString> licenseDescriptions = null;
        if (conAnnotation.licenseDescription() != null && conAnnotation.licenseDescription().length != 0) {
            licenseDescriptions = new ArrayList<LocalizedXsdString>(conAnnotation.licenseDescription().length);
            for (String licenseDescriptionAnnotation : conAnnotation.licenseDescription()) {
                licenseDescriptions.add(new LocalizedXsdString(licenseDescriptionAnnotation, null));
            }
        }
        LicenseType license = new LicenseType(licenseDescriptions, conAnnotation.licenseRequired(), null);
        ArrayList<String> requiredWorkContexts = null;
        Class[] requiredWorkContextAnnotations = conAnnotation.requiredWorkContexts();
        if (requiredWorkContextAnnotations != null) {
            requiredWorkContexts = new ArrayList<String>(requiredWorkContextAnnotations.length);
            for (Class requiredWorkContext : requiredWorkContextAnnotations) {
                if (requiredWorkContexts.contains(requiredWorkContext.getName())) continue;
                if (trace) {
                    log.trace((Object)("RequiredWorkContext=" + requiredWorkContext.getName()));
                }
                requiredWorkContexts.add(requiredWorkContext.getName());
            }
        }
        ArrayList<Icon> icons = null;
        if (conAnnotation.smallIcon() != null && conAnnotation.smallIcon().length != 0 || conAnnotation.largeIcon() != null && conAnnotation.largeIcon().length != 0) {
            icons = new ArrayList<Icon>((conAnnotation.smallIcon() == null ? 0 : conAnnotation.smallIcon().length) + (conAnnotation.largeIcon() == null ? 0 : conAnnotation.largeIcon().length));
            for (String smallIconAnnotation : conAnnotation.smallIcon()) {
                icons.add(new Icon(Path.valueOf((String)smallIconAnnotation), null, null));
            }
            for (String largeIconAnnotation : conAnnotation.largeIcon()) {
                icons.add(new Icon(Path.valueOf((String)largeIconAnnotation), null, null));
            }
        }
        TransactionSupport.TransactionSupportLevel transactionSupportAnnotation = conAnnotation.transactionSupport();
        TransactionSupportEnum transactionSupport = TransactionSupportEnum.valueOf((String)transactionSupportAnnotation.name());
        boolean reauthenticationSupport = conAnnotation.reauthenticationSupport();
        ArrayList<AuthenticationMechanism> authenticationMechanisms = this.processAuthenticationMechanism(conAnnotation.authMechanisms());
        OutboundResourceAdapterImpl outboundResourceadapter = new OutboundResourceAdapterImpl(connectionDefinitions, transactionSupport, authenticationMechanisms, reauthenticationSupport, null);
        ArrayList<SecurityPermission> securityPermissions = this.processSecurityPermissions(conAnnotation.securityPermissions());
        ResourceAdapter1516Impl resourceAdapter = new ResourceAdapter1516Impl(raClass, configProperties, outboundResourceadapter, inboundResourceadapter, adminObjs, securityPermissions, null);
        XsdString resourceadapterVersion = new XsdString("1.6", null);
        return new Connector16Impl("", vendorName, eisType, resourceadapterVersion, license, resourceAdapter, requiredWorkContexts, false, descriptions, displayNames, icons, null);
    }

    private ArrayList<SecurityPermission> processSecurityPermissions(javax.resource.spi.SecurityPermission[] securityPermissionAnotations) {
        ArrayList<SecurityPermissionImpl> securityPermissions = null;
        if (securityPermissionAnotations != null && securityPermissionAnotations.length != 0) {
            securityPermissions = new ArrayList<SecurityPermissionImpl>(securityPermissionAnotations.length);
            for (javax.resource.spi.SecurityPermission securityPermission : securityPermissionAnotations) {
                SecurityPermissionImpl spmd = new SecurityPermissionImpl(null, new XsdString(securityPermission.permissionSpec(), null), null);
                securityPermissions.add(spmd);
            }
            securityPermissions.trimToSize();
        }
        return securityPermissions;
    }

    private ArrayList<AuthenticationMechanism> processAuthenticationMechanism(javax.resource.spi.AuthenticationMechanism[] authMechanismAnnotations) {
        ArrayList<AuthenticationMechanismImpl> authenticationMechanisms = null;
        if (authMechanismAnnotations != null) {
            authenticationMechanisms = new ArrayList<AuthenticationMechanismImpl>(authMechanismAnnotations.length);
            for (javax.resource.spi.AuthenticationMechanism authMechanismAnnotation : authMechanismAnnotations) {
                ArrayList<LocalizedXsdString> descriptions = null;
                if (authMechanismAnnotation.description() != null && authMechanismAnnotation.description().length != 0) {
                    descriptions = new ArrayList<LocalizedXsdString>(authMechanismAnnotation.description().length);
                    for (String descriptionAnnoptation : authMechanismAnnotation.description()) {
                        descriptions.add(new LocalizedXsdString(descriptionAnnoptation, null));
                    }
                }
                XsdString authenticationMechanismType = new XsdString(authMechanismAnnotation.authMechanism(), null);
                authenticationMechanisms.add(new AuthenticationMechanismImpl(descriptions, authenticationMechanismType, CredentialInterfaceEnum.valueOf((String)authMechanismAnnotation.credentialInterface().name()), null));
            }
        }
        return authenticationMechanisms;
    }

    private ArrayList<ConnectionDefinition> processConnectionDefinitions(AnnotationRepository annotationRepository, ArrayList<? extends ConfigProperty> configProperties) throws Exception {
        Collection values = annotationRepository.getAnnotation(ConnectionDefinitions.class);
        if (values != null) {
            if (values.size() == 1) {
                Annotation annotation = (Annotation)values.iterator().next();
                ConnectionDefinitions connectionDefinitionsAnnotation = (ConnectionDefinitions)annotation.getAnnotation();
                if (trace) {
                    log.trace((Object)("Processing: " + connectionDefinitionsAnnotation));
                }
                return this.attachConnectionDefinitions(connectionDefinitionsAnnotation, annotation.getClassName(), configProperties);
            }
            throw new ValidateException("More than one @ConnectionDefinitions defined");
        }
        return null;
    }

    private ArrayList<ConnectionDefinition> attachConnectionDefinitions(ConnectionDefinitions cds, String mcf, ArrayList<? extends ConfigProperty> configProperty) throws Exception {
        ArrayList<ConnectionDefinition> connectionDefinitions = null;
        if (cds.value() != null) {
            connectionDefinitions = new ArrayList<ConnectionDefinition>(cds.value().length);
            for (javax.resource.spi.ConnectionDefinition cd : cds.value()) {
                connectionDefinitions.add(this.attachConnectionDefinition(mcf, cd, configProperty));
            }
        }
        return connectionDefinitions;
    }

    private ArrayList<ConnectionDefinition> processConnectionDefinition(AnnotationRepository annotationRepository, ArrayList<? extends ConfigProperty> configProperty) throws Exception {
        ArrayList<ConnectionDefinition> connectionDefinitions = null;
        Collection values = annotationRepository.getAnnotation(javax.resource.spi.ConnectionDefinition.class);
        if (values != null) {
            connectionDefinitions = new ArrayList<ConnectionDefinition>(values.size());
            for (Annotation annotation : values) {
                connectionDefinitions.add(this.attachConnectionDefinition(annotation, configProperty));
            }
        }
        return connectionDefinitions;
    }

    private ConnectionDefinition attachConnectionDefinition(Annotation annotation, ArrayList<? extends ConfigProperty> configProperty) throws Exception {
        javax.resource.spi.ConnectionDefinition cd = (javax.resource.spi.ConnectionDefinition)annotation.getAnnotation();
        if (trace) {
            log.trace((Object)("Processing: " + annotation));
        }
        return this.attachConnectionDefinition(annotation.getClassName(), cd, configProperty);
    }

    private ConnectionDefinition attachConnectionDefinition(String mcf, javax.resource.spi.ConnectionDefinition cd, ArrayList<? extends ConfigProperty> configProperties) throws Exception {
        ArrayList<ConfigProperty> validProperties = new ArrayList<ConfigProperty>();
        if (configProperties != null) {
            for (ConfigProperty configProperty : configProperties) {
                if (!mcf.equals(((ConfigProperty16Impl)configProperty).getAttachedClassName())) continue;
                validProperties.add(configProperty);
            }
        }
        validProperties.trimToSize();
        if (trace) {
            log.trace((Object)("Processing: " + cd));
        }
        XsdString connectionfactoryInterface = new XsdString(cd.connectionFactory().getName(), null);
        XsdString xsdString = new XsdString(mcf, null);
        XsdString connectionImplClass = new XsdString(cd.connectionImpl().getName(), null);
        XsdString connectionfactoryImplClass = new XsdString(cd.connectionFactoryImpl().getName(), null);
        XsdString connectionInterface = new XsdString(cd.connection().getName(), null);
        return new ConnectionDefinitionImpl(xsdString, configProperties, connectionfactoryInterface, connectionfactoryImplClass, connectionInterface, connectionImplClass, null);
    }

    private Map<Metadatas, ArrayList<ConfigProperty16>> processConfigProperty(AnnotationRepository annotationRepository) throws Exception {
        HashMap<Metadatas, ArrayList<ConfigProperty16>> valueMap = null;
        Collection values = annotationRepository.getAnnotation(javax.resource.spi.ConfigProperty.class);
        if (values != null) {
            valueMap = new HashMap<Metadatas, ArrayList<ConfigProperty16>>();
            for (Annotation annotation : values) {
                ConfigProperty16Impl cfgMeta;
                ClassLoader cl;
                javax.resource.spi.ConfigProperty configPropertyAnnotation = (javax.resource.spi.ConfigProperty)annotation.getAnnotation();
                if (trace) {
                    log.trace((Object)("Processing: " + configPropertyAnnotation));
                }
                XsdString configPropertyValue = XsdString.NULL_XSDSTRING;
                XsdString configPropertyName = new XsdString(this.getConfigPropertyName(annotation), null);
                if (configPropertyAnnotation.defaultValue() != null && !configPropertyAnnotation.defaultValue().equals("")) {
                    configPropertyValue = new XsdString(configPropertyAnnotation.defaultValue(), null);
                }
                XsdString configPropertyType = !Object.class.equals((Object)configPropertyAnnotation.type()) ? new XsdString(configPropertyAnnotation.type().getName(), null) : new XsdString(this.getConfigPropertyType(annotation), null);
                Boolean configPropertySupportsDynamicUpdates = false;
                Boolean configPropertyConfidential = false;
                ArrayList<LocalizedXsdString> descriptions = null;
                if (configPropertyAnnotation.description() != null && configPropertyAnnotation.description().length != 0) {
                    descriptions = new ArrayList<LocalizedXsdString>(configPropertyAnnotation.description().length);
                    for (String descriptionAnnoptation : configPropertyAnnotation.description()) {
                        descriptions.add(new LocalizedXsdString(descriptionAnnoptation, null));
                    }
                }
                Boolean configPropertyIgnore = configPropertyAnnotation.ignore();
                String attachedClassName = annotation.getClassName();
                Class<?> attachedClass = Class.forName(attachedClassName, true, cl = SecurityActions.getThreadContextClassLoader());
                if (this.hasInterface(attachedClass, "javax.resource.spi.ResourceAdapter")) {
                    cfgMeta = new ConfigProperty16Impl(descriptions, configPropertyName, configPropertyType, configPropertyValue, configPropertyIgnore, configPropertySupportsDynamicUpdates, configPropertyConfidential, null);
                    if (valueMap.get((Object)Metadatas.RA) == null) {
                        valueMap.put(Metadatas.RA, new ArrayList());
                    }
                    ((ArrayList)valueMap.get((Object)Metadatas.RA)).add(cfgMeta);
                    continue;
                }
                cfgMeta = new ConfigProperty16Impl(descriptions, configPropertyName, configPropertyType, configPropertyValue, configPropertyIgnore, configPropertySupportsDynamicUpdates, configPropertyConfidential, null, attachedClassName);
                if (this.hasInterface(attachedClass, "javax.resource.spi.ManagedConnectionFactory")) {
                    if (valueMap.get((Object)Metadatas.MANAGED_CONN_FACTORY) == null) {
                        valueMap.put(Metadatas.MANAGED_CONN_FACTORY, new ArrayList());
                    }
                    ((ArrayList)valueMap.get((Object)Metadatas.MANAGED_CONN_FACTORY)).add(cfgMeta);
                    continue;
                }
                if (!this.hasInterface(attachedClass, "javax.resource.spi.ActivationSpec")) continue;
                if (valueMap.get((Object)Metadatas.ACTIVATION_SPEC) == null) {
                    valueMap.put(Metadatas.ACTIVATION_SPEC, new ArrayList());
                }
                ((ArrayList)valueMap.get((Object)Metadatas.ACTIVATION_SPEC)).add(cfgMeta);
            }
            if (valueMap.get((Object)Metadatas.RA) != null) {
                ((ArrayList)valueMap.get((Object)Metadatas.RA)).trimToSize();
            }
            if (valueMap.get((Object)Metadatas.MANAGED_CONN_FACTORY) != null) {
                ((ArrayList)valueMap.get((Object)Metadatas.MANAGED_CONN_FACTORY)).trimToSize();
            }
            if (valueMap.get((Object)Metadatas.ACTIVATION_SPEC) != null) {
                ((ArrayList)valueMap.get((Object)Metadatas.ACTIVATION_SPEC)).trimToSize();
            }
            return valueMap;
        }
        return valueMap;
    }

    private boolean hasInterface(Class c, String targetClassName) {
        for (Class<?> face : c.getInterfaces()) {
            if (face.getName().equals(targetClassName)) {
                return true;
            }
            for (Class<?> face2 : face.getInterfaces()) {
                if (face2.getName().equals(targetClassName)) {
                    return true;
                }
                if (!this.hasInterface(face2, targetClassName)) continue;
                return true;
            }
        }
        if (null != c.getSuperclass()) {
            return this.hasInterface(c.getSuperclass(), targetClassName);
        }
        return false;
    }

    private ArrayList<AdminObject> processAdministeredObject(AnnotationRepository annotationRepository) throws Exception {
        ArrayList<AdminObjectImpl> adminObjs = null;
        Collection values = annotationRepository.getAnnotation(AdministeredObject.class);
        if (values != null) {
            adminObjs = new ArrayList<AdminObjectImpl>(values.size());
            for (Annotation annotation : values) {
                AdministeredObject a = (AdministeredObject)annotation.getAnnotation();
                if (trace) {
                    log.trace((Object)("Processing: " + a));
                }
                String aoName = null;
                if (a.adminObjectInterfaces().length > 0) {
                    aoName = ((Class)Array.get(a.adminObjectInterfaces(), 0)).getName();
                }
                XsdString adminobjectInterface = new XsdString(aoName, null);
                adminObjs.add(new AdminObjectImpl(adminobjectInterface, null, null, null));
            }
        }
        return adminObjs;
    }

    private InboundResourceAdapter processActivation(AnnotationRepository annotationRepository, ArrayList<ConfigProperty16> configProperties) throws Exception {
        ArrayList<MessageListener> listeners = new ArrayList<MessageListener>();
        Collection values = annotationRepository.getAnnotation(Activation.class);
        if (values != null) {
            for (Annotation annotation : values) {
                listeners.addAll(this.attachActivation(annotation, configProperties));
            }
            listeners.trimToSize();
        }
        return new InboundResourceAdapterImpl(new MessageAdapterImpl(listeners, null), null);
    }

    private ArrayList<MessageListener> attachActivation(Annotation annotation, ArrayList<ConfigProperty16> configProperties) throws Exception {
        ArrayList<ConfigProperty16> validProperties = new ArrayList<ConfigProperty16>();
        if (configProperties != null) {
            for (ConfigProperty16 configProperty16 : configProperties) {
                if (!annotation.getClassName().equals(((ConfigProperty16Impl)configProperty16).getAttachedClassName())) continue;
                validProperties.add(configProperty16);
            }
        }
        validProperties.trimToSize();
        Activation activation = (Activation)annotation.getAnnotation();
        ArrayList<MessageListenerImpl> messageListeners = null;
        if (trace) {
            log.trace((Object)("Processing: " + activation));
        }
        if (activation.messageListeners() != null) {
            messageListeners = new ArrayList<MessageListenerImpl>(activation.messageListeners().length);
            for (Class asClass : activation.messageListeners()) {
                Activationspec16Impl asMeta = new Activationspec16Impl(new XsdString(annotation.getClassName(), null), null, validProperties, null);
                MessageListenerImpl mlMeta = new MessageListenerImpl(new XsdString(asClass.getName(), null), asMeta, null);
                messageListeners.add(mlMeta);
            }
        }
        return messageListeners;
    }

    private String getConfigPropertyName(Annotation annotation) throws ClassNotFoundException, NoSuchFieldException, NoSuchMethodException {
        if (annotation.isOnField()) {
            return annotation.getMemberName();
        }
        if (annotation.isOnMethod()) {
            String name = annotation.getMemberName();
            if (name.startsWith("set")) {
                name = name.substring(3);
            } else if (name.startsWith("get")) {
                name = name.substring(3);
            } else if (name.startsWith("is")) {
                name = name.substring(2);
            }
            if (name.length() > 1) {
                return Character.toLowerCase(name.charAt(0)) + name.substring(1);
            }
            return Character.toString(Character.toLowerCase(name.charAt(0)));
        }
        throw new IllegalArgumentException("Unknown annotation: " + annotation);
    }

    private String getConfigPropertyType(Annotation annotation) throws ClassNotFoundException {
        block10: {
            block9: {
                if (!annotation.isOnField()) break block9;
                ClassLoader cl = SecurityActions.getThreadContextClassLoader();
                Class<?> clz = Class.forName(annotation.getClassName(), true, cl);
                while (!Object.class.equals(clz)) {
                    try {
                        Field field = clz.getDeclaredField(annotation.getMemberName());
                        return field.getType().getName();
                    }
                    catch (NoSuchFieldException nsfe) {
                        clz = clz.getSuperclass();
                    }
                }
                break block10;
            }
            if (!annotation.isOnMethod()) break block10;
            ClassLoader cl = SecurityActions.getThreadContextClassLoader();
            Class<?> clz = Class.forName(annotation.getClassName(), true, cl);
            Class[] parameters = null;
            if (annotation.getParameterTypes() != null) {
                parameters = new Class[annotation.getParameterTypes().size()];
                for (int i = 0; i < annotation.getParameterTypes().size(); ++i) {
                    String parameter = (String)annotation.getParameterTypes().get(i);
                    parameters[i] = Class.forName(parameter, true, cl);
                }
            }
            while (!Object.class.equals(clz)) {
                try {
                    Method method = clz.getDeclaredMethod(annotation.getMemberName(), parameters);
                    if (Void.TYPE.equals(method.getReturnType())) {
                        if (parameters == null || parameters.length <= 0) continue;
                        return parameters[0].getName();
                    }
                    return method.getReturnType().getName();
                }
                catch (NoSuchMethodException nsme) {
                    clz = clz.getSuperclass();
                }
            }
        }
        throw new IllegalArgumentException("Unknown annotation: " + annotation);
    }

    private static enum Metadatas {
        RA,
        ACTIVATION_SPEC,
        MANAGED_CONN_FACTORY;

    }
}

