/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonSecurity;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.metadata.ParserException;
import org.jboss.jca.common.metadata.common.CommonPoolImpl;
import org.jboss.jca.common.metadata.common.CommonSecurityImpl;
import org.jboss.jca.common.metadata.common.CommonXaPoolImpl;

public abstract class AbstractParser {
    protected boolean elementAsBoolean(XMLStreamReader reader) throws XMLStreamException {
        String elementtext = reader.getElementText();
        return elementtext == null || elementtext.length() == 0 ? true : Boolean.valueOf(elementtext.trim());
    }

    protected boolean attributeAsBoolean(XMLStreamReader reader, String attributeName, boolean defaultValue) throws XMLStreamException {
        return reader.getAttributeValue("", attributeName) == null || reader.getAttributeValue("", attributeName).length() == 0 ? defaultValue : Boolean.valueOf(reader.getAttributeValue("", attributeName).trim());
    }

    protected String elementAsString(XMLStreamReader reader) throws XMLStreamException {
        String elementtext = reader.getElementText();
        return elementtext == null ? null : elementtext.trim();
    }

    protected String attributeAsString(XMLStreamReader reader, String attributeName) throws XMLStreamException {
        return reader.getAttributeValue("", attributeName) == null ? null : reader.getAttributeValue("", attributeName).trim();
    }

    protected Integer elementAsInteger(XMLStreamReader reader) throws XMLStreamException, ParserException {
        Integer integerValue = null;
        try {
            integerValue = Integer.valueOf(this.elementAsString(reader));
        }
        catch (NumberFormatException nfe) {
            throw new ParserException(reader.getLocalName() + "isn't a valid number");
        }
        return integerValue;
    }

    protected Long elementAsLong(XMLStreamReader reader) throws XMLStreamException, ParserException {
        Long longValue = null;
        try {
            longValue = Long.valueOf(this.elementAsString(reader));
        }
        catch (NumberFormatException nfe) {
            throw new ParserException(reader.getLocalName() + "isn't a valid number");
        }
        return longValue;
    }

    protected CommonPool parsePool(XMLStreamReader reader) throws XMLStreamException, ParserException {
        Integer minPoolSize = null;
        Integer maxPoolSize = null;
        boolean prefill = false;
        boolean useStrictMin = false;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.POOL) {
                        return new CommonPoolImpl(minPoolSize, maxPoolSize, prefill, useStrictMin);
                    }
                    if (CommonPool.Tag.forName((String)reader.getLocalName()) != CommonPool.Tag.UNKNOWN) break;
                    throw new ParserException("unexpected end tag" + reader.getLocalName());
                }
                case 1: {
                    switch (CommonPool.Tag.forName((String)reader.getLocalName())) {
                        case MAXPOOLSIZE: {
                            maxPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case MIN_POOL_SIZE: {
                            minPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case PREFILL: {
                            prefill = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case USE_STRICT_MIN: {
                            useStrictMin = this.elementAsBoolean(reader);
                            break block0;
                        }
                    }
                    throw new ParserException("Unexpected element:" + reader.getLocalName());
                }
            }
        }
        throw new ParserException("Reached end of xml document unexpectedly");
    }

    protected CommonSecurity parseSecuritySettings(XMLStreamReader reader) throws XMLStreamException, ParserException {
        String userName = null;
        String password = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.SECURITY) {
                        return new CommonSecurityImpl(userName, password);
                    }
                    if (CommonSecurity.Tag.forName((String)reader.getLocalName()) != CommonSecurity.Tag.UNKNOWN) break;
                    throw new ParserException("unexpected end tag" + reader.getLocalName());
                }
                case 1: {
                    switch (CommonSecurity.Tag.forName((String)reader.getLocalName())) {
                        case PASSWORD: {
                            password = this.elementAsString(reader);
                            break block0;
                        }
                        case USERNAME: {
                            userName = this.elementAsString(reader);
                            break block0;
                        }
                    }
                    throw new ParserException("Unexpected element:" + reader.getLocalName());
                }
            }
        }
        throw new ParserException("Reached end of xml document unexpectedly");
    }

    protected CommonXaPool parseXaPool(XMLStreamReader reader) throws XMLStreamException, ParserException {
        Integer minPoolSize = null;
        Integer maxPoolSize = null;
        boolean prefill = false;
        boolean interleaving = false;
        boolean isSameRmOverrideValue = false;
        boolean padXid = false;
        boolean noTxSeparatePool = false;
        boolean wrapXaDataSource = false;
        boolean useStrictMin = false;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) == XaDataSource.Tag.XA_POOL) {
                        return new CommonXaPoolImpl(minPoolSize, maxPoolSize, prefill, useStrictMin, isSameRmOverrideValue, interleaving, padXid, wrapXaDataSource, noTxSeparatePool);
                    }
                    if (CommonXaPool.Tag.forName((String)reader.getLocalName()) != CommonXaPool.Tag.UNKNOWN) break;
                    throw new ParserException("unexpected end tag" + reader.getLocalName());
                }
                case 1: {
                    switch (CommonXaPool.Tag.forName((String)reader.getLocalName())) {
                        case MAXPOOLSIZE: {
                            maxPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case MIN_POOL_SIZE: {
                            minPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case INTERLEAVING: {
                            interleaving = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case ISSAMERMOVERRIDEVALUE: {
                            isSameRmOverrideValue = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case NO_TX_SEPARATE_POOLS: {
                            noTxSeparatePool = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case PAD_XID: {
                            padXid = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case WRAP_XA_RESOURCE: {
                            wrapXaDataSource = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case PREFILL: {
                            prefill = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case USE_STRICT_MIN: {
                            useStrictMin = this.elementAsBoolean(reader);
                            break block0;
                        }
                    }
                    throw new ParserException("Unexpected element:" + reader.getLocalName());
                }
            }
        }
        throw new ParserException("Reached end of xml document unexpectedly");
    }
}

