/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonSecurity;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.TransactionIsolation;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.metadata.ds.DataSourceAbstractImpl;

public class DataSourceImpl
extends DataSourceAbstractImpl
implements DataSource {
    private static final long serialVersionUID = -5214100851560229431L;
    private final String connectionUrl;
    private final String driverClass;
    private final HashMap<String, String> connectionProperties;
    private final String newConnectionSql;
    private final CommonPool pool;

    public DataSourceImpl(String connectionUrl, String driverClass, TransactionIsolation transactionIsolation, Map<String, String> connectionProperties, TimeOut timeOut, CommonSecurity security, Statement statement, Validation validation, String urlDelimiter, String urlSelectorStrategyClassName, String newConnectionSql, boolean useJavaContext, String poolName, boolean enabled, String jndiName, CommonPool pool) {
        super(transactionIsolation, timeOut, security, statement, validation, urlDelimiter, urlSelectorStrategyClassName, useJavaContext, poolName, enabled, jndiName);
        this.connectionUrl = connectionUrl;
        this.driverClass = driverClass;
        if (connectionProperties != null) {
            this.connectionProperties = new HashMap(connectionProperties.size());
            this.connectionProperties.putAll(connectionProperties);
        } else {
            this.connectionProperties = new HashMap(0);
        }
        this.newConnectionSql = newConnectionSql;
        this.pool = pool;
    }

    public final String getConnectionUrl() {
        return this.connectionUrl;
    }

    public final String getDriverClass() {
        return this.driverClass;
    }

    public final Map<String, String> getConnectionProperties() {
        return Collections.unmodifiableMap(this.connectionProperties);
    }

    public final Statement getStatement() {
        return this.statement;
    }

    public final String getUrlDelimiter() {
        return this.urlDelimiter;
    }

    public final String getUrlSelectorStrategyClassName() {
        return this.urlSelectorStrategyClassName;
    }

    public final String getNewConnectionSql() {
        return this.newConnectionSql;
    }

    public final CommonPool getPool() {
        return this.pool;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.connectionProperties == null ? 0 : this.connectionProperties.hashCode());
        result = 31 * result + (this.connectionUrl == null ? 0 : this.connectionUrl.hashCode());
        result = 31 * result + (this.driverClass == null ? 0 : this.driverClass.hashCode());
        result = 31 * result + (this.newConnectionSql == null ? 0 : this.newConnectionSql.hashCode());
        result = 31 * result + (this.pool == null ? 0 : this.pool.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceImpl)) {
            return false;
        }
        DataSourceImpl other = (DataSourceImpl)obj;
        if (this.connectionProperties == null ? other.connectionProperties != null : !this.connectionProperties.equals(other.connectionProperties)) {
            return false;
        }
        if (this.connectionUrl == null ? other.connectionUrl != null : !this.connectionUrl.equals(other.connectionUrl)) {
            return false;
        }
        if (this.driverClass == null ? other.driverClass != null : !this.driverClass.equals(other.driverClass)) {
            return false;
        }
        if (this.newConnectionSql == null ? other.newConnectionSql != null : !this.newConnectionSql.equals(other.newConnectionSql)) {
            return false;
        }
        return !(this.pool == null ? other.pool != null : !this.pool.equals(other.pool));
    }

    public String toString() {
        return "DataSourceImpl [connectionUrl=" + this.connectionUrl + ", driverClass=" + this.driverClass + ", connectionProperties=" + this.connectionProperties + ", newConnectionSql=" + this.newConnectionSql + ", pool=" + this.pool + ", transactionIsolation=" + this.transactionIsolation + ", timeOut=" + this.timeOut + ", security=" + this.security + ", statement=" + this.statement + ", validation=" + this.validation + ", urlDelimiter=" + this.urlDelimiter + ", urlSelectorStrategyClassName=" + this.urlSelectorStrategyClassName + ", useJavaContext=" + this.useJavaContext + ", poolName=" + this.poolName + ", enabled=" + this.enabled + ", jndiName=" + this.jndiName + "]";
    }
}

