/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonSecurity;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.TransactionIsolation;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.metadata.AbstractParser;
import org.jboss.jca.common.metadata.MetadataParser;
import org.jboss.jca.common.metadata.ParserException;
import org.jboss.jca.common.metadata.ds.DataSourceImpl;
import org.jboss.jca.common.metadata.ds.DatasourcesImpl;
import org.jboss.jca.common.metadata.ds.StatementImpl;
import org.jboss.jca.common.metadata.ds.TimeOutImpl;
import org.jboss.jca.common.metadata.ds.ValidationImpl;
import org.jboss.jca.common.metadata.ds.XADataSourceImpl;

public class DsParser
extends AbstractParser
implements MetadataParser<DataSources> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DataSources parse(InputStream xmlInputStream) throws Exception {
        XMLStreamReader reader = null;
        DataSources dataSources = null;
        try {
            int iterate;
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            reader = inputFactory.createXMLStreamReader(xmlInputStream);
            try {
                iterate = reader.nextTag();
            }
            catch (XMLStreamException e) {
                iterate = reader.nextTag();
            }
            switch (iterate) {
                case 2: {
                    return dataSources;
                }
                case 1: {
                    switch (Tag.forName(reader.getLocalName())) {
                        case DATASOURCES: {
                            dataSources = this.parseDataSources(reader);
                            return dataSources;
                        }
                    }
                    throw new ParserException("Unexpected element:" + reader.getLocalName());
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private DataSources parseDataSources(XMLStreamReader reader) throws XMLStreamException, ParserException {
        ArrayList<XaDataSource> xaDataSource = new ArrayList<XaDataSource>();
        ArrayList<DataSource> datasource = new ArrayList<DataSource>();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.DATASOURCES) {
                        return new DatasourcesImpl(datasource, xaDataSource);
                    }
                    if (DataSources.Tag.forName((String)reader.getLocalName()) != DataSources.Tag.UNKNOWN) break;
                    throw new ParserException("unexpected end tag" + reader.getLocalName());
                }
                case 1: {
                    switch (DataSources.Tag.forName((String)reader.getLocalName())) {
                        case DATASOURCE: {
                            datasource.add(this.parseDataSource(reader));
                            break block0;
                        }
                        case XA_DATASOURCE: {
                            xaDataSource.add(this.parseXADataSource(reader));
                            break block0;
                        }
                    }
                    throw new ParserException("Unexpected element:" + reader.getLocalName());
                }
            }
        }
        throw new ParserException("Reached end of xml document unexpectedly");
    }

    private XaDataSource parseXADataSource(XMLStreamReader reader) throws XMLStreamException, ParserException {
        TransactionIsolation transactionIsolation = null;
        HashMap<String, String> xaDataSourceProperty = new HashMap<String, String>();
        TimeOut timeOutSettings = null;
        CommonSecurity securitySettings = null;
        Statement statementSettings = null;
        Validation validationSettings = null;
        String urlDelimiter = null;
        String urlSelectorStrategyClassName = null;
        String newConnectionSql = null;
        CommonXaPool xaPool = null;
        String xaDataSourceClass = null;
        boolean useJavaContext = false;
        String poolName = null;
        boolean enabled = true;
        String jndiName = null;
        block23: for (XaDataSource.Attribute attribute : XaDataSource.Attribute.values()) {
            switch (attribute) {
                case ENABLED: {
                    enabled = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block23;
                }
                case JNDINAME: {
                    jndiName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block23;
                }
                case POOL_NAME: {
                    poolName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block23;
                }
                case USEJAVACONTEXT: {
                    useJavaContext = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block23;
                }
            }
        }
        while (reader.hasNext()) {
            block6 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.XA_DATASOURCE) {
                        return new XADataSourceImpl(transactionIsolation, timeOutSettings, securitySettings, statementSettings, validationSettings, urlDelimiter, urlSelectorStrategyClassName, useJavaContext, poolName, enabled, jndiName, xaDataSourceProperty, xaDataSourceClass, newConnectionSql, xaPool);
                    }
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) != XaDataSource.Tag.UNKNOWN) break;
                    throw new ParserException("unexpected end tag" + reader.getLocalName());
                }
                case 1: {
                    switch (XaDataSource.Tag.forName((String)reader.getLocalName())) {
                        case XADATASOURCEPROPERTY: {
                            xaDataSourceProperty.put(this.attributeAsString(reader, "name"), this.elementAsString(reader));
                            break block6;
                        }
                        case XADATASOURCECLASS: {
                            xaDataSourceClass = this.elementAsString(reader);
                            break block6;
                        }
                        case XA_POOL: {
                            xaPool = this.parseXaPool(reader);
                            break block6;
                        }
                        case NEWCONNECTIONSQL: {
                            newConnectionSql = this.elementAsString(reader);
                            break block6;
                        }
                        case URLDELIMITER: {
                            urlDelimiter = this.elementAsString(reader);
                            break block6;
                        }
                        case URLSELECTORSTRATEGYCLASSNAME: {
                            urlSelectorStrategyClassName = this.elementAsString(reader);
                            break block6;
                        }
                        case TRANSACTIONISOLATION: {
                            transactionIsolation = TransactionIsolation.valueOf((String)this.elementAsString(reader));
                            break block6;
                        }
                        case SECURITY: {
                            securitySettings = this.parseSecuritySettings(reader);
                            break block6;
                        }
                        case STATEMENT: {
                            statementSettings = this.parseStatementSettings(reader);
                            break block6;
                        }
                        case TIMEOUT: {
                            timeOutSettings = this.parseTimeOutSettings(reader);
                            break block6;
                        }
                        case VALIDATION: {
                            validationSettings = this.parseValidationSetting(reader);
                            break block6;
                        }
                    }
                    throw new ParserException("Unexpected element:" + reader.getLocalName());
                }
            }
        }
        throw new ParserException("Reached end of xml document unexpectedly");
    }

    private DataSource parseDataSource(XMLStreamReader reader) throws XMLStreamException, ParserException {
        Object minPoolSize = null;
        Object maxPoolSize = null;
        boolean prefill = false;
        String connectionUrl = null;
        String driverClass = null;
        TransactionIsolation transactionIsolation = null;
        HashMap<String, String> connectionProperties = new HashMap<String, String>();
        TimeOut timeOutSettings = null;
        CommonSecurity securitySettings = null;
        Statement statementSettings = null;
        Validation validationSettings = null;
        String urlDelimiter = null;
        String urlSelectorStrategyClassName = null;
        String newConnectionSql = null;
        CommonPool pool = null;
        boolean useJavaContext = false;
        String poolName = null;
        boolean enabled = true;
        String jndiName = null;
        block24: for (XaDataSource.Attribute attribute : XaDataSource.Attribute.values()) {
            switch (attribute) {
                case ENABLED: {
                    enabled = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block24;
                }
                case JNDINAME: {
                    jndiName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block24;
                }
                case POOL_NAME: {
                    poolName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block24;
                }
                case USEJAVACONTEXT: {
                    useJavaContext = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block24;
                }
            }
        }
        while (reader.hasNext()) {
            block6 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.DATASOURCE) {
                        return new DataSourceImpl(connectionUrl, driverClass, transactionIsolation, connectionProperties, timeOutSettings, securitySettings, statementSettings, validationSettings, urlDelimiter, urlSelectorStrategyClassName, newConnectionSql, useJavaContext, poolName, enabled, jndiName, pool);
                    }
                    if (DataSource.Tag.forName((String)reader.getLocalName()) != DataSource.Tag.UNKNOWN) break;
                    throw new ParserException("unexpected end tag" + reader.getLocalName());
                }
                case 1: {
                    switch (DataSource.Tag.forName((String)reader.getLocalName())) {
                        case CONNECTIONPROPERTY: {
                            connectionProperties.put(this.attributeAsString(reader, "name"), this.elementAsString(reader));
                            break block6;
                        }
                        case CONNECTIONURL: {
                            connectionUrl = this.elementAsString(reader);
                            break block6;
                        }
                        case DRIVERCLASS: {
                            driverClass = this.elementAsString(reader);
                            break block6;
                        }
                        case POOL: {
                            pool = this.parsePool(reader);
                            break block6;
                        }
                        case NEWCONNECTIONSQL: {
                            newConnectionSql = this.elementAsString(reader);
                            break block6;
                        }
                        case URLDELIMITER: {
                            urlDelimiter = this.elementAsString(reader);
                            break block6;
                        }
                        case URLSELECTORSTRATEGYCLASSNAME: {
                            urlSelectorStrategyClassName = this.elementAsString(reader);
                            break block6;
                        }
                        case TRANSACTIONISOLATION: {
                            transactionIsolation = TransactionIsolation.valueOf((String)this.elementAsString(reader));
                            break block6;
                        }
                        case SECURITY: {
                            securitySettings = this.parseSecuritySettings(reader);
                            break block6;
                        }
                        case STATEMENT: {
                            statementSettings = this.parseStatementSettings(reader);
                            break block6;
                        }
                        case TIMEOUT: {
                            timeOutSettings = this.parseTimeOutSettings(reader);
                            break block6;
                        }
                        case VALIDATION: {
                            validationSettings = this.parseValidationSetting(reader);
                            break block6;
                        }
                    }
                    throw new ParserException("Unexpected element:" + reader.getLocalName());
                }
            }
        }
        throw new ParserException("Reached end of xml document unexpectedly");
    }

    private Validation parseValidationSetting(XMLStreamReader reader) throws XMLStreamException, ParserException {
        boolean validateOnMatch = false;
        boolean useFastFail = false;
        Long backgroundValidationMinutes = null;
        String staleConnectionCheckerClassName = null;
        boolean backgroundValidation = false;
        String checkValidConnectionSql = null;
        String validConnectionCheckerClassName = null;
        String exceptionSorterClassName = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.VALIDATION) {
                        return new ValidationImpl(backgroundValidation, backgroundValidationMinutes, useFastFail, validConnectionCheckerClassName, checkValidConnectionSql, validateOnMatch, staleConnectionCheckerClassName, exceptionSorterClassName);
                    }
                    if (Validation.Tag.forName((String)reader.getLocalName()) != Validation.Tag.UNKNOWN) break;
                    throw new ParserException("unexpected end tag" + reader.getLocalName());
                }
                case 1: {
                    switch (Validation.Tag.forName((String)reader.getLocalName())) {
                        case BACKGROUNDVALIDATION: {
                            backgroundValidation = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case BACKGROUNDVALIDATIONMINUTES: {
                            backgroundValidationMinutes = this.elementAsLong(reader);
                            break block0;
                        }
                        case CHECKVALIDCONNECTIONSQL: {
                            checkValidConnectionSql = this.elementAsString(reader);
                            break block0;
                        }
                        case EXCEPTIONSORTERCLASSNAME: {
                            exceptionSorterClassName = this.elementAsString(reader);
                            break block0;
                        }
                        case STALECONNECTIONCHECKERCLASSNAME: {
                            staleConnectionCheckerClassName = this.elementAsString(reader);
                            break block0;
                        }
                        case USEFASTFAIL: {
                            useFastFail = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case VALIDATEONMATCH: {
                            validateOnMatch = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case VALIDCONNECTIONCHECKERCLASSNAME: {
                            validConnectionCheckerClassName = this.elementAsString(reader);
                            break block0;
                        }
                    }
                    throw new ParserException("Unexpected element:" + reader.getLocalName());
                }
            }
        }
        throw new ParserException("Reached end of xml document unexpectedly");
    }

    private TimeOut parseTimeOutSettings(XMLStreamReader reader) throws XMLStreamException, ParserException {
        Long blockingTimeoutMillis = null;
        Long idleTimeoutMinutes = null;
        boolean setTxQuertTimeout = false;
        Long queryTimeout = null;
        Integer allocationRetry = null;
        Long allocationRetryWaitMillis = null;
        Long useTryLock = null;
        Integer xaResourceTimeout = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.TIMEOUT) {
                        return new TimeOutImpl(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout, setTxQuertTimeout, queryTimeout, useTryLock);
                    }
                    if (TimeOut.Tag.forName((String)reader.getLocalName()) != TimeOut.Tag.UNKNOWN) break;
                    throw new ParserException("unexpected end tag" + reader.getLocalName());
                }
                case 1: {
                    switch (TimeOut.Tag.forName((String)reader.getLocalName())) {
                        case ALLOCATIONRETRY: {
                            allocationRetry = this.elementAsInteger(reader);
                            break block0;
                        }
                        case ALLOCATIONRETRYWAITMILLIS: {
                            allocationRetryWaitMillis = this.elementAsLong(reader);
                            break block0;
                        }
                        case BLOCKINGTIMEOUTMILLIS: {
                            blockingTimeoutMillis = this.elementAsLong(reader);
                            break block0;
                        }
                        case IDLETIMEOUTMINUTES: {
                            idleTimeoutMinutes = this.elementAsLong(reader);
                            break block0;
                        }
                        case QUERYTIMEOUT: {
                            queryTimeout = this.elementAsLong(reader);
                            break block0;
                        }
                        case SETTXQUERYTIMEOUT: {
                            setTxQuertTimeout = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case USETRYLOCK: {
                            useTryLock = this.elementAsLong(reader);
                            break block0;
                        }
                        case XARESOURCETIMEOUT: {
                            xaResourceTimeout = this.elementAsInteger(reader);
                            break block0;
                        }
                    }
                    throw new ParserException("Unexpected element:" + reader.getLocalName());
                }
            }
        }
        throw new ParserException("Reached end of xml document unexpectedly");
    }

    private Statement parseStatementSettings(XMLStreamReader reader) throws XMLStreamException, ParserException {
        Long preparedStatementsCacheSize = null;
        boolean sharePreparedStatements = false;
        Statement.TrackStatementsEnum trackStatements = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.STATEMENT) {
                        return new StatementImpl(sharePreparedStatements, preparedStatementsCacheSize, trackStatements);
                    }
                    if (Statement.Tag.forName((String)reader.getLocalName()) != Statement.Tag.UNKNOWN) break;
                    throw new ParserException("unexpected end tag" + reader.getLocalName());
                }
                case 1: {
                    switch (Statement.Tag.forName((String)reader.getLocalName())) {
                        case PREPAREDSTATEMENTCACHESIZE: {
                            preparedStatementsCacheSize = this.elementAsLong(reader);
                            break block0;
                        }
                        case TRACKSTATEMENTS: {
                            String elementString = this.elementAsString(reader);
                            trackStatements = Statement.TrackStatementsEnum.valueOf((String)(elementString == null ? "FALSE" : elementString.toUpperCase(Locale.US)));
                            break block0;
                        }
                        case SHAREPREPAREDSTATEMENTS: {
                            sharePreparedStatements = this.elementAsBoolean(reader);
                            break block0;
                        }
                    }
                    throw new ParserException("Unexpected element:" + reader.getLocalName());
                }
            }
        }
        throw new ParserException("Reached end of xml document unexpectedly");
    }

    public static enum Tag {
        UNKNOWN(null),
        DATASOURCES("datasources");

        private final String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

