/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.resourceadapter;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.jca.common.api.metadata.common.CommonAdminObject;
import org.jboss.jca.common.api.metadata.common.CommonConnDef;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapters;
import org.jboss.jca.common.metadata.MetadataParser;
import org.jboss.jca.common.metadata.ParserException;
import org.jboss.jca.common.metadata.common.CommonIronJacamarParser;
import org.jboss.jca.common.metadata.resourceadapter.ResourceAdapterImpl;
import org.jboss.jca.common.metadata.resourceadapter.ResourceAdaptersImpl;

public class ResourceAdapterParser
extends CommonIronJacamarParser
implements MetadataParser<ResourceAdapters> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ResourceAdapters parse(InputStream xmlInputStream) throws Exception {
        XMLStreamReader reader = null;
        ResourceAdapters adapters = null;
        try {
            int iterate;
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            reader = inputFactory.createXMLStreamReader(xmlInputStream);
            try {
                iterate = reader.nextTag();
            }
            catch (XMLStreamException e) {
                iterate = reader.nextTag();
            }
            switch (iterate) {
                case 2: {
                    return adapters;
                }
                case 1: {
                    switch (Tag.forName(reader.getLocalName())) {
                        case RESOURCE_ADPTERS: {
                            adapters = this.parseResourceAdapters(reader);
                            return adapters;
                        }
                    }
                    throw new ParserException("Unexpected element:" + reader.getLocalName());
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private ResourceAdapters parseResourceAdapters(XMLStreamReader reader) throws XMLStreamException, ParserException {
        ArrayList<ResourceAdapter> resourceAdapters = new ArrayList<ResourceAdapter>();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.RESOURCE_ADPTERS) {
                        resourceAdapters.trimToSize();
                        return new ResourceAdaptersImpl(resourceAdapters);
                    }
                    if (ResourceAdapters.Tag.forName((String)reader.getLocalName()) != ResourceAdapters.Tag.UNKNOWN) break;
                    throw new ParserException("unexpected end tag" + reader.getLocalName());
                }
                case 1: {
                    switch (ResourceAdapters.Tag.forName((String)reader.getLocalName())) {
                        case RESOURCE_ADPTER: {
                            resourceAdapters.add(this.parseResourceAdapter(reader));
                            break block0;
                        }
                    }
                    throw new ParserException("Unexpected element:" + reader.getLocalName());
                }
            }
        }
        throw new ParserException("Reached end of xml document unexpectedly");
    }

    private ResourceAdapter parseResourceAdapter(XMLStreamReader reader) throws XMLStreamException, ParserException {
        ArrayList<CommonConnDef> connectionDefinitions = null;
        ArrayList<CommonAdminObject> adminObjects = null;
        ArrayList<String> beanValidationGroups = null;
        String bootstrapContext = null;
        String archive = null;
        TransactionSupportEnum transactionSupport = null;
        HashMap<String, String> configProperties = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (ResourceAdapters.Tag.forName((String)reader.getLocalName()) == ResourceAdapters.Tag.RESOURCE_ADPTER) {
                        return new ResourceAdapterImpl(archive, transactionSupport, connectionDefinitions, adminObjects, configProperties, beanValidationGroups, bootstrapContext);
                    }
                    if (ResourceAdapter.Tag.forName((String)reader.getLocalName()) != ResourceAdapter.Tag.UNKNOWN) break;
                    throw new ParserException("unexpected end tag" + reader.getLocalName());
                }
                case 1: {
                    switch (ResourceAdapter.Tag.forName((String)reader.getLocalName())) {
                        case ADMIN_OBJECTS: 
                        case CONNECTION_DEFINITIONS: 
                        case BEAN_VALIDATION_GROUPS: {
                            break block0;
                        }
                        case ADMIN_OBJECT: {
                            if (adminObjects == null) {
                                adminObjects = new ArrayList<CommonAdminObject>();
                            }
                            adminObjects.add(this.parseAdminObjects(reader));
                            break block0;
                        }
                        case CONNECTION_DEFINITION: {
                            if (connectionDefinitions == null) {
                                connectionDefinitions = new ArrayList<CommonConnDef>();
                            }
                            connectionDefinitions.add(this.parseConnectionDefinitions(reader));
                            break block0;
                        }
                        case BEAN_VALIDATION_GROUP: {
                            if (beanValidationGroups == null) {
                                beanValidationGroups = new ArrayList<String>();
                            }
                            beanValidationGroups.add(this.elementAsString(reader));
                            break block0;
                        }
                        case BOOTSTRAP_CONTEXT: {
                            bootstrapContext = this.elementAsString(reader);
                            break block0;
                        }
                        case CONFIG_PROPERTY: {
                            if (configProperties == null) {
                                configProperties = new HashMap<String, String>();
                            }
                            configProperties.put(this.attributeAsString(reader, "name"), this.elementAsString(reader));
                            break block0;
                        }
                        case TRANSACTION_SUPPORT: {
                            transactionSupport = TransactionSupportEnum.valueOf((String)this.elementAsString(reader));
                            break block0;
                        }
                        case ARCHIVE: {
                            archive = this.elementAsString(reader);
                            break block0;
                        }
                    }
                    throw new ParserException("Unexpected element:" + reader.getLocalName());
                }
            }
        }
        throw new ParserException("Reached end of xml document unexpectedly");
    }

    public static enum Tag {
        UNKNOWN(null),
        RESOURCE_ADPTERS("resource-adapters");

        private final String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

