/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.TransactionIsolation;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.ds.DataSourceAbstractImpl;

public class XADataSourceImpl
extends DataSourceAbstractImpl
implements XaDataSource {
    private static final long serialVersionUID = -1401087499308709724L;
    private final HashMap<String, String> xaDataSourceProperty;
    private String xaDataSourceClass;
    private final String driver;
    private final String newConnectionSql;
    private final CommonXaPool xaPool;
    private final Recovery recovery;

    public XADataSourceImpl(TransactionIsolation transactionIsolation, TimeOut timeOut, DsSecurity security, Statement statement, Validation validation, String urlDelimiter, String urlSelectorStrategyClassName, boolean useJavaContext, String poolName, boolean enabled, String jndiName, boolean spy, boolean useCcm, Map<String, String> xaDataSourceProperty, String xaDataSourceClass, String driver, String newConnectionSql, CommonXaPool xaPool, Recovery recovery) throws ValidateException {
        super(transactionIsolation, timeOut, security, statement, validation, urlDelimiter, urlSelectorStrategyClassName, useJavaContext, poolName, enabled, jndiName, spy, useCcm);
        if (xaDataSourceProperty != null) {
            this.xaDataSourceProperty = new HashMap(xaDataSourceProperty.size());
            this.xaDataSourceProperty.putAll(xaDataSourceProperty);
        } else {
            this.xaDataSourceProperty = new HashMap(0);
        }
        this.xaDataSourceClass = xaDataSourceClass;
        this.driver = driver;
        this.newConnectionSql = newConnectionSql;
        this.xaPool = xaPool;
        this.recovery = recovery;
        this.validate();
    }

    public final String getXaDataSourceClass() {
        return this.xaDataSourceClass;
    }

    public final String getDriver() {
        return this.driver;
    }

    public final Statement getStatement() {
        return this.statement;
    }

    public final String getUrlDelimiter() {
        return this.urlDelimiter;
    }

    public final String getUrlSelectorStrategyClassName() {
        return this.urlSelectorStrategyClassName;
    }

    public final String getNewConnectionSql() {
        return this.newConnectionSql;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.driver == null ? 0 : this.driver.hashCode());
        result = 31 * result + (this.newConnectionSql == null ? 0 : this.newConnectionSql.hashCode());
        result = 31 * result + (this.xaDataSourceClass == null ? 0 : this.xaDataSourceClass.hashCode());
        result = 31 * result + (this.xaDataSourceProperty == null ? 0 : this.xaDataSourceProperty.hashCode());
        result = 31 * result + (this.xaPool == null ? 0 : this.xaPool.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof XADataSourceImpl)) {
            return false;
        }
        XADataSourceImpl other = (XADataSourceImpl)obj;
        if (this.driver == null ? other.driver != null : !this.driver.equals(other.driver)) {
            return false;
        }
        if (this.newConnectionSql == null ? other.newConnectionSql != null : !this.newConnectionSql.equals(other.newConnectionSql)) {
            return false;
        }
        if (this.xaDataSourceClass == null ? other.xaDataSourceClass != null : !this.xaDataSourceClass.equals(other.xaDataSourceClass)) {
            return false;
        }
        if (this.xaDataSourceProperty == null ? other.xaDataSourceProperty != null : !this.xaDataSourceProperty.equals(other.xaDataSourceProperty)) {
            return false;
        }
        return !(this.xaPool == null ? other.xaPool != null : !this.xaPool.equals(other.xaPool));
    }

    public String toString() {
        return "XADataSourceImpl [xaDataSourceProperty=" + this.xaDataSourceProperty + ", xaDataSourceClass=" + this.xaDataSourceClass + ", driver=" + this.driver + ", newConnectionSql=" + this.newConnectionSql + ", xaPool=" + this.xaPool + ", transactionIsolation=" + this.transactionIsolation + ", timeOut=" + this.timeOut + ", security=" + this.security + ", statement=" + this.statement + ", validation=" + this.validation + ", urlDelimiter=" + this.urlDelimiter + ", urlSelectorStrategyClassName=" + this.urlSelectorStrategyClassName + ", useJavaContext=" + this.useJavaContext + ", poolName=" + this.poolName + ", enabled=" + this.enabled + ", jndiName=" + this.jndiName + "]";
    }

    public final Map<String, String> getXaDataSourceProperty() {
        return Collections.unmodifiableMap(this.xaDataSourceProperty);
    }

    public final CommonXaPool getXaPool() {
        return this.xaPool;
    }

    public void validate() throws ValidateException {
        if (!(this.xaDataSourceClass != null && this.xaDataSourceClass.trim().length() != 0 || this.driver != null && this.driver.trim().length() != 0)) {
            throw new ValidateException("xaDataSourceClass (xml tag " + XaDataSource.Tag.XADATASOURCECLASS + ") is required");
        }
        if (this.xaDataSourceProperty.isEmpty()) {
            throw new ValidateException("at least one xaDataSourceProperty (xml tag " + XaDataSource.Tag.XADATASOURCEPROPERTY + ") is required ");
        }
    }

    public Recovery getRecovery() {
        return this.recovery;
    }

    public final void forceXaDataSourceClass(String xaDataSourceClass) {
        this.xaDataSourceClass = xaDataSourceClass;
    }
}

