/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.TransactionIsolation;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.AbstractParser;
import org.jboss.jca.common.metadata.MetadataParser;
import org.jboss.jca.common.metadata.ParserException;
import org.jboss.jca.common.metadata.ds.DataSourceImpl;
import org.jboss.jca.common.metadata.ds.DatasourcesImpl;
import org.jboss.jca.common.metadata.ds.DsSecurityImpl;
import org.jboss.jca.common.metadata.ds.StatementImpl;
import org.jboss.jca.common.metadata.ds.TimeOutImpl;
import org.jboss.jca.common.metadata.ds.ValidationImpl;
import org.jboss.jca.common.metadata.ds.XADataSourceImpl;

public class DsParser
extends AbstractParser
implements MetadataParser<DataSources> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSources parse(InputStream xmlInputStream) throws Exception {
        XMLStreamReader reader = null;
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        reader = inputFactory.createXMLStreamReader(xmlInputStream);
        try {
            DataSources dataSources = this.parse(reader);
            return dataSources;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Override
    public DataSources parse(XMLStreamReader reader) throws Exception {
        int iterate;
        DataSources dataSources = null;
        try {
            iterate = reader.nextTag();
        }
        catch (XMLStreamException e) {
            iterate = reader.nextTag();
        }
        block1 : switch (iterate) {
            case 2: {
                break;
            }
            case 1: {
                switch (Tag.forName(reader.getLocalName())) {
                    case DATASOURCES: {
                        dataSources = this.parseDataSources(reader);
                        break block1;
                    }
                }
                throw new ParserException("Unexpected element:" + reader.getLocalName());
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return dataSources;
    }

    private DataSources parseDataSources(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        ArrayList<XaDataSource> xaDataSource = new ArrayList<XaDataSource>();
        ArrayList<DataSource> datasource = new ArrayList<DataSource>();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.DATASOURCES) {
                        return new DatasourcesImpl(datasource, xaDataSource);
                    }
                    if (DataSources.Tag.forName((String)reader.getLocalName()) != DataSources.Tag.UNKNOWN) break;
                    throw new ParserException("unexpected end tag" + reader.getLocalName());
                }
                case 1: {
                    switch (DataSources.Tag.forName((String)reader.getLocalName())) {
                        case DATASOURCE: {
                            datasource.add(this.parseDataSource(reader));
                            break block0;
                        }
                        case XA_DATASOURCE: {
                            xaDataSource.add(this.parseXADataSource(reader));
                            break block0;
                        }
                    }
                    throw new ParserException("Unexpected element:" + reader.getLocalName());
                }
            }
        }
        throw new ParserException("Reached end of xml document unexpectedly");
    }

    private XaDataSource parseXADataSource(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        TransactionIsolation transactionIsolation = null;
        HashMap<String, String> xaDataSourceProperty = new HashMap<String, String>();
        TimeOut timeOutSettings = null;
        DsSecurity securitySettings = null;
        Statement statementSettings = null;
        Validation validationSettings = null;
        String urlDelimiter = null;
        String urlSelectorStrategyClassName = null;
        String newConnectionSql = null;
        CommonXaPool xaPool = null;
        Recovery recovery = null;
        String xaDataSourceClass = null;
        String driver = null;
        boolean useJavaContext = true;
        String poolName = null;
        boolean enabled = true;
        String jndiName = null;
        boolean spy = false;
        boolean useCcm = true;
        block27: for (XaDataSource.Attribute attribute : XaDataSource.Attribute.values()) {
            switch (attribute) {
                case ENABLED: {
                    enabled = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block27;
                }
                case JNDINAME: {
                    jndiName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block27;
                }
                case POOL_NAME: {
                    poolName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block27;
                }
                case USEJAVACONTEXT: {
                    useJavaContext = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block27;
                }
                case SPY: {
                    spy = this.attributeAsBoolean(reader, attribute.getLocalName(), false);
                    continue block27;
                }
                case USE_CCM: {
                    useCcm = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block27;
                }
            }
        }
        while (reader.hasNext()) {
            block8 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.XA_DATASOURCE) {
                        return new XADataSourceImpl(transactionIsolation, timeOutSettings, securitySettings, statementSettings, validationSettings, urlDelimiter, urlSelectorStrategyClassName, useJavaContext, poolName, enabled, jndiName, spy, useCcm, xaDataSourceProperty, xaDataSourceClass, driver, newConnectionSql, xaPool, recovery);
                    }
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) != XaDataSource.Tag.UNKNOWN) break;
                    throw new ParserException("unexpected end tag" + reader.getLocalName());
                }
                case 1: {
                    switch (XaDataSource.Tag.forName((String)reader.getLocalName())) {
                        case XADATASOURCEPROPERTY: {
                            xaDataSourceProperty.put(this.attributeAsString(reader, "name"), this.elementAsString(reader));
                            break block8;
                        }
                        case XADATASOURCECLASS: {
                            xaDataSourceClass = this.elementAsString(reader);
                            break block8;
                        }
                        case DRIVER: {
                            driver = this.elementAsString(reader);
                            break block8;
                        }
                        case XA_POOL: {
                            xaPool = this.parseXaPool(reader);
                            break block8;
                        }
                        case NEWCONNECTIONSQL: {
                            newConnectionSql = this.elementAsString(reader);
                            break block8;
                        }
                        case URLDELIMITER: {
                            urlDelimiter = this.elementAsString(reader);
                            break block8;
                        }
                        case URLSELECTORSTRATEGYCLASSNAME: {
                            urlSelectorStrategyClassName = this.elementAsString(reader);
                            break block8;
                        }
                        case TRANSACTIONISOLATION: {
                            transactionIsolation = TransactionIsolation.valueOf((String)this.elementAsString(reader));
                            break block8;
                        }
                        case SECURITY: {
                            securitySettings = this.parseDsSecurity(reader);
                            break block8;
                        }
                        case STATEMENT: {
                            statementSettings = this.parseStatementSettings(reader);
                            break block8;
                        }
                        case TIMEOUT: {
                            timeOutSettings = this.parseTimeOutSettings(reader);
                            break block8;
                        }
                        case VALIDATION: {
                            validationSettings = this.parseValidationSetting(reader);
                            break block8;
                        }
                        case RECOVERY: {
                            recovery = this.parseRecovery(reader);
                            break block8;
                        }
                    }
                    throw new ParserException("Unexpected element:" + reader.getLocalName());
                }
            }
        }
        throw new ParserException("Reached end of xml document unexpectedly");
    }

    private DsSecurity parseDsSecurity(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String userName = null;
        String password = null;
        String securityDomain = null;
        Extension reauthPlugin = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.SECURITY) {
                        return new DsSecurityImpl(userName, password, securityDomain, reauthPlugin);
                    }
                    if (DsSecurity.Tag.forName((String)reader.getLocalName()) != DsSecurity.Tag.UNKNOWN) break;
                    throw new ParserException("unexpected end tag" + reader.getLocalName());
                }
                case 1: {
                    DsSecurity.Tag tag = DsSecurity.Tag.forName((String)reader.getLocalName());
                    switch (tag) {
                        case PASSWORD: {
                            password = this.elementAsString(reader);
                            break block0;
                        }
                        case USERNAME: {
                            userName = this.elementAsString(reader);
                            break block0;
                        }
                        case SECURITY_DOMAIN: {
                            securityDomain = this.elementAsString(reader);
                            break block0;
                        }
                        case REAUTH_PLUGIN: {
                            reauthPlugin = this.parseExtension(reader, tag.getLocalName());
                            break block0;
                        }
                    }
                    throw new ParserException("Unexpected element:" + reader.getLocalName());
                }
            }
        }
        throw new ParserException("Reached end of xml document unexpectedly");
    }

    private DataSource parseDataSource(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String connectionUrl = null;
        String driverClass = null;
        String driver = null;
        TransactionIsolation transactionIsolation = null;
        HashMap<String, String> connectionProperties = new HashMap<String, String>();
        TimeOut timeOutSettings = null;
        DsSecurity securitySettings = null;
        Statement statementSettings = null;
        Validation validationSettings = null;
        String urlDelimiter = null;
        String urlSelectorStrategyClassName = null;
        String newConnectionSql = null;
        CommonPool pool = null;
        boolean useJavaContext = true;
        String poolName = null;
        boolean enabled = true;
        String jndiName = null;
        boolean spy = false;
        boolean useCcm = true;
        block27: for (XaDataSource.Attribute attribute : XaDataSource.Attribute.values()) {
            switch (attribute) {
                case ENABLED: {
                    enabled = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block27;
                }
                case JNDINAME: {
                    jndiName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block27;
                }
                case POOL_NAME: {
                    poolName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block27;
                }
                case USEJAVACONTEXT: {
                    useJavaContext = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block27;
                }
                case SPY: {
                    spy = this.attributeAsBoolean(reader, attribute.getLocalName(), false);
                    continue block27;
                }
                case USE_CCM: {
                    useCcm = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block27;
                }
            }
        }
        while (reader.hasNext()) {
            block8 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.DATASOURCE) {
                        return new DataSourceImpl(connectionUrl, driverClass, driver, transactionIsolation, connectionProperties, timeOutSettings, securitySettings, statementSettings, validationSettings, urlDelimiter, urlSelectorStrategyClassName, newConnectionSql, useJavaContext, poolName, enabled, jndiName, spy, useCcm, pool);
                    }
                    if (DataSource.Tag.forName((String)reader.getLocalName()) != DataSource.Tag.UNKNOWN) break;
                    throw new ParserException("unexpected end tag" + reader.getLocalName());
                }
                case 1: {
                    switch (DataSource.Tag.forName((String)reader.getLocalName())) {
                        case CONNECTIONPROPERTY: {
                            connectionProperties.put(this.attributeAsString(reader, "name"), this.elementAsString(reader));
                            break block8;
                        }
                        case CONNECTIONURL: {
                            connectionUrl = this.elementAsString(reader);
                            break block8;
                        }
                        case DRIVERCLASS: {
                            driverClass = this.elementAsString(reader);
                            break block8;
                        }
                        case DRIVER: {
                            driver = this.elementAsString(reader);
                            break block8;
                        }
                        case POOL: {
                            pool = this.parsePool(reader);
                            break block8;
                        }
                        case NEWCONNECTIONSQL: {
                            newConnectionSql = this.elementAsString(reader);
                            break block8;
                        }
                        case URLDELIMITER: {
                            urlDelimiter = this.elementAsString(reader);
                            break block8;
                        }
                        case URLSELECTORSTRATEGYCLASSNAME: {
                            urlSelectorStrategyClassName = this.elementAsString(reader);
                            break block8;
                        }
                        case TRANSACTIONISOLATION: {
                            transactionIsolation = TransactionIsolation.valueOf((String)this.elementAsString(reader));
                            break block8;
                        }
                        case SECURITY: {
                            securitySettings = this.parseDsSecurity(reader);
                            break block8;
                        }
                        case STATEMENT: {
                            statementSettings = this.parseStatementSettings(reader);
                            break block8;
                        }
                        case TIMEOUT: {
                            timeOutSettings = this.parseTimeOutSettings(reader);
                            break block8;
                        }
                        case VALIDATION: {
                            validationSettings = this.parseValidationSetting(reader);
                            break block8;
                        }
                    }
                    throw new ParserException("Unexpected element:" + reader.getLocalName());
                }
            }
        }
        throw new ParserException("Reached end of xml document unexpectedly");
    }

    private Validation parseValidationSetting(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        boolean validateOnMatch = false;
        boolean useFastFail = false;
        Long backgroundValidationMinutes = null;
        Extension staleConnectionChecker = null;
        boolean backgroundValidation = false;
        String checkValidConnectionSql = null;
        Extension validConnectionChecker = null;
        Extension exceptionSorter = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.VALIDATION) {
                        return new ValidationImpl(backgroundValidation, backgroundValidationMinutes, useFastFail, validConnectionChecker, checkValidConnectionSql, validateOnMatch, staleConnectionChecker, exceptionSorter);
                    }
                    if (Validation.Tag.forName((String)reader.getLocalName()) != Validation.Tag.UNKNOWN) break;
                    throw new ParserException("unexpected end tag" + reader.getLocalName());
                }
                case 1: {
                    Validation.Tag currTag = Validation.Tag.forName((String)reader.getLocalName());
                    switch (currTag) {
                        case BACKGROUNDVALIDATION: {
                            backgroundValidation = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case BACKGROUNDVALIDATIONMINUTES: {
                            backgroundValidationMinutes = this.elementAsLong(reader);
                            break block0;
                        }
                        case CHECKVALIDCONNECTIONSQL: {
                            checkValidConnectionSql = this.elementAsString(reader);
                            break block0;
                        }
                        case EXCEPTIONSORTER: {
                            exceptionSorter = this.parseExtension(reader, currTag.getLocalName());
                            break block0;
                        }
                        case STALECONNECTIONCHECKER: {
                            staleConnectionChecker = this.parseExtension(reader, currTag.getLocalName());
                            break block0;
                        }
                        case USEFASTFAIL: {
                            useFastFail = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case VALIDATEONMATCH: {
                            validateOnMatch = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case VALIDCONNECTIONCHECKER: {
                            validConnectionChecker = this.parseExtension(reader, currTag.getLocalName());
                            break block0;
                        }
                    }
                    throw new ParserException("Unexpected element:" + reader.getLocalName());
                }
            }
        }
        throw new ParserException("Reached end of xml document unexpectedly");
    }

    private TimeOut parseTimeOutSettings(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        Long blockingTimeoutMillis = null;
        Long idleTimeoutMinutes = null;
        boolean setTxQuertTimeout = false;
        Long queryTimeout = null;
        Integer allocationRetry = null;
        Long allocationRetryWaitMillis = null;
        Long useTryLock = null;
        Integer xaResourceTimeout = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.TIMEOUT) {
                        return new TimeOutImpl(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout, setTxQuertTimeout, queryTimeout, useTryLock);
                    }
                    if (TimeOut.Tag.forName((String)reader.getLocalName()) != TimeOut.Tag.UNKNOWN) break;
                    throw new ParserException("unexpected end tag" + reader.getLocalName());
                }
                case 1: {
                    switch (TimeOut.Tag.forName((String)reader.getLocalName())) {
                        case ALLOCATIONRETRY: {
                            allocationRetry = this.elementAsInteger(reader);
                            break block0;
                        }
                        case ALLOCATIONRETRYWAITMILLIS: {
                            allocationRetryWaitMillis = this.elementAsLong(reader);
                            break block0;
                        }
                        case BLOCKINGTIMEOUTMILLIS: {
                            blockingTimeoutMillis = this.elementAsLong(reader);
                            break block0;
                        }
                        case IDLETIMEOUTMINUTES: {
                            idleTimeoutMinutes = this.elementAsLong(reader);
                            break block0;
                        }
                        case QUERYTIMEOUT: {
                            queryTimeout = this.elementAsLong(reader);
                            break block0;
                        }
                        case SETTXQUERYTIMEOUT: {
                            setTxQuertTimeout = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case USETRYLOCK: {
                            useTryLock = this.elementAsLong(reader);
                            break block0;
                        }
                        case XARESOURCETIMEOUT: {
                            xaResourceTimeout = this.elementAsInteger(reader);
                            break block0;
                        }
                    }
                    throw new ParserException("Unexpected element:" + reader.getLocalName());
                }
            }
        }
        throw new ParserException("Reached end of xml document unexpectedly");
    }

    private Statement parseStatementSettings(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        Long preparedStatementsCacheSize = null;
        boolean sharePreparedStatements = false;
        Statement.TrackStatementsEnum trackStatements = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.STATEMENT) {
                        return new StatementImpl(sharePreparedStatements, preparedStatementsCacheSize, trackStatements);
                    }
                    if (Statement.Tag.forName((String)reader.getLocalName()) != Statement.Tag.UNKNOWN) break;
                    throw new ParserException("unexpected end tag" + reader.getLocalName());
                }
                case 1: {
                    switch (Statement.Tag.forName((String)reader.getLocalName())) {
                        case PREPAREDSTATEMENTCACHESIZE: {
                            preparedStatementsCacheSize = this.elementAsLong(reader);
                            break block0;
                        }
                        case TRACKSTATEMENTS: {
                            String elementString = this.elementAsString(reader);
                            trackStatements = Statement.TrackStatementsEnum.valueOf((String)(elementString == null ? "FALSE" : elementString.toUpperCase(Locale.US)));
                            break block0;
                        }
                        case SHAREPREPAREDSTATEMENTS: {
                            sharePreparedStatements = this.elementAsBoolean(reader);
                            break block0;
                        }
                    }
                    throw new ParserException("Unexpected element:" + reader.getLocalName());
                }
            }
        }
        throw new ParserException("Reached end of xml document unexpectedly");
    }

    public static enum Tag {
        UNKNOWN(null),
        DATASOURCES("datasources");

        private final String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

