/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds;

import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.ds.CommonDataSource;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.TransactionIsolation;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Messages;

public abstract class DataSourceAbstractImpl
implements CommonDataSource {
    private static final long serialVersionUID = -5612846950298960159L;
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    protected final TransactionIsolation transactionIsolation;
    protected final TimeOut timeOut;
    protected final DsSecurity security;
    protected final Statement statement;
    protected final Validation validation;
    protected final String urlDelimiter;
    protected final String urlSelectorStrategyClassName;
    protected final Boolean useJavaContext;
    protected final String poolName;
    protected Boolean enabled;
    protected final String jndiName;
    protected final boolean spy;
    protected final boolean useCcm;

    protected DataSourceAbstractImpl(TransactionIsolation transactionIsolation, TimeOut timeOut, DsSecurity security, Statement statement, Validation validation, String urlDelimiter, String urlSelectorStrategyClassName, Boolean useJavaContext, String poolName, Boolean enabled, String jndiName, boolean spy, boolean useCcm) throws ValidateException {
        this.transactionIsolation = transactionIsolation;
        this.timeOut = timeOut;
        this.security = security;
        this.statement = statement;
        this.validation = validation;
        this.urlDelimiter = urlDelimiter;
        this.urlSelectorStrategyClassName = urlSelectorStrategyClassName;
        this.useJavaContext = useJavaContext;
        this.poolName = poolName;
        this.enabled = enabled;
        this.jndiName = jndiName;
        this.spy = spy;
        this.useCcm = useCcm;
        this.partialCommonValidation();
    }

    public final TransactionIsolation getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public final TimeOut getTimeOut() {
        return this.timeOut;
    }

    public final DsSecurity getSecurity() {
        return this.security;
    }

    public final Validation getValidation() {
        return this.validation;
    }

    public final Boolean isUseJavaContext() {
        return this.useJavaContext;
    }

    public final String getPoolName() {
        return this.poolName;
    }

    public final Boolean isEnabled() {
        return this.enabled;
    }

    public final String getJndiName() {
        return this.jndiName;
    }

    public final boolean isSpy() {
        return this.spy;
    }

    public final boolean isUseCcm() {
        return this.useCcm;
    }

    protected void partialCommonValidation() throws ValidateException {
        if (this.jndiName == null) {
            throw new ValidateException(bundle.requiredAttributeMissing(DataSource.Attribute.JNDINAME.getLocalName(), this.getClass().getCanonicalName()));
        }
        if (this.poolName == null) {
            throw new ValidateException(bundle.requiredAttributeMissing(DataSource.Attribute.POOL_NAME.getLocalName(), this.getClass().getCanonicalName()));
        }
        if (this.timeOut != null) {
            this.timeOut.validate();
        }
        if (this.security != null) {
            this.security.validate();
        }
        if (this.statement != null) {
            this.statement.validate();
        }
        if (this.validation != null) {
            this.validation.validate();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.enabled == null ? 0 : this.enabled.hashCode());
        result = 31 * result + (this.jndiName == null ? 0 : this.jndiName.hashCode());
        result = 31 * result + (this.poolName == null ? 0 : this.poolName.hashCode());
        result = 31 * result + (this.security == null ? 0 : this.security.hashCode());
        result = 31 * result + (this.statement == null ? 0 : this.statement.hashCode());
        result = 31 * result + (this.timeOut == null ? 0 : this.timeOut.hashCode());
        result = 31 * result + (this.transactionIsolation == null ? 0 : this.transactionIsolation.hashCode());
        result = 31 * result + (this.urlDelimiter == null ? 0 : this.urlDelimiter.hashCode());
        result = 31 * result + (this.urlSelectorStrategyClassName == null ? 0 : this.urlSelectorStrategyClassName.hashCode());
        result = 31 * result + (this.useJavaContext == null ? 0 : this.useJavaContext.hashCode());
        result = 31 * result + (this.validation == null ? 0 : this.validation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceAbstractImpl)) {
            return false;
        }
        DataSourceAbstractImpl other = (DataSourceAbstractImpl)obj;
        if (this.enabled == null ? other.enabled != null : !this.enabled.equals(other.enabled)) {
            return false;
        }
        if (this.jndiName == null ? other.jndiName != null : !this.jndiName.equals(other.jndiName)) {
            return false;
        }
        if (this.poolName == null ? other.poolName != null : !this.poolName.equals(other.poolName)) {
            return false;
        }
        if (this.security == null ? other.security != null : !this.security.equals(other.security)) {
            return false;
        }
        if (this.statement == null ? other.statement != null : !this.statement.equals(other.statement)) {
            return false;
        }
        if (this.timeOut == null ? other.timeOut != null : !this.timeOut.equals(other.timeOut)) {
            return false;
        }
        if (this.transactionIsolation != other.transactionIsolation) {
            return false;
        }
        if (this.urlDelimiter == null ? other.urlDelimiter != null : !this.urlDelimiter.equals(other.urlDelimiter)) {
            return false;
        }
        if (this.urlSelectorStrategyClassName == null ? other.urlSelectorStrategyClassName != null : !this.urlSelectorStrategyClassName.equals(other.urlSelectorStrategyClassName)) {
            return false;
        }
        if (this.useJavaContext == null ? other.useJavaContext != null : !this.useJavaContext.equals(other.useJavaContext)) {
            return false;
        }
        return !(this.validation == null ? other.validation != null : !this.validation.equals(other.validation));
    }

    public final void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }
}

