/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds;

import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.common.CommonValidationImpl;
import org.jboss.logging.Messages;

public class ValidationImpl
extends CommonValidationImpl
implements Validation {
    private static final long serialVersionUID = 7816717816552118419L;
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    private final Extension validConnectionChecker;
    private final String checkValidConnectionSql;
    private final Boolean validateOnMatch;
    private final Extension staleConnectionChecker;
    private final Extension exceptionSorter;

    public ValidationImpl(Boolean backgroundValidation, Long backgroundValidationMinutes, Boolean useFastFail, Extension validConnectionChecker, String checkValidConnectionSql, Boolean validateOnMatch, Extension staleConnectionChecker, Extension exceptionSorter) throws ValidateException {
        super(backgroundValidation, backgroundValidationMinutes, useFastFail);
        this.validConnectionChecker = validConnectionChecker;
        this.checkValidConnectionSql = checkValidConnectionSql;
        this.validateOnMatch = validateOnMatch;
        this.staleConnectionChecker = staleConnectionChecker;
        this.exceptionSorter = exceptionSorter;
        this.validate();
    }

    public final String getCheckValidConnectionSql() {
        return this.checkValidConnectionSql;
    }

    public final Boolean isValidateOnMatch() {
        return this.validateOnMatch;
    }

    public final Extension getValidConnectionChecker() {
        return this.validConnectionChecker;
    }

    public final Boolean getValidateOnMatch() {
        return this.validateOnMatch;
    }

    public final Extension getStaleConnectionChecker() {
        return this.staleConnectionChecker;
    }

    public final Extension getExceptionSorter() {
        return this.exceptionSorter;
    }

    public void validate() throws ValidateException {
        if (this.backgroundValidationMinutes != null && this.backgroundValidationMinutes < 0L) {
            throw new ValidateException(bundle.invalidNegative(Validation.Tag.BACKGROUNDVALIDATIONMINUTES.getLocalName()));
        }
        if (this.validConnectionChecker != null) {
            try {
                this.validConnectionChecker.validate();
            }
            catch (ValidateException ve) {
                throw new ValidateException(bundle.invalidTag(Validation.Tag.VALIDCONNECTIONCHECKER.getLocalName()), (Throwable)ve);
            }
        }
        if (this.exceptionSorter != null) {
            try {
                this.exceptionSorter.validate();
            }
            catch (ValidateException ve) {
                throw new ValidateException(bundle.invalidTag(Validation.Tag.EXCEPTIONSORTER.getLocalName()), (Throwable)ve);
            }
        }
        if (this.staleConnectionChecker != null) {
            try {
                this.staleConnectionChecker.validate();
            }
            catch (ValidateException ve) {
                throw new ValidateException(bundle.invalidTag(Validation.Tag.STALECONNECTIONCHECKER.getLocalName()), (Throwable)ve);
            }
        }
    }

    @Override
    public String toString() {
        return "ValidationImpl [validConnectionChecker=" + this.validConnectionChecker + ", checkValidConnectionSql=" + this.checkValidConnectionSql + ", validateOnMatch=" + this.validateOnMatch + ", staleConnectionChecker=" + this.staleConnectionChecker + ", exceptionSorter=" + this.exceptionSorter + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.checkValidConnectionSql == null ? 0 : this.checkValidConnectionSql.hashCode());
        result = 31 * result + (this.exceptionSorter == null ? 0 : this.exceptionSorter.hashCode());
        result = 31 * result + (this.staleConnectionChecker == null ? 0 : this.staleConnectionChecker.hashCode());
        result = 31 * result + (this.validConnectionChecker == null ? 0 : this.validConnectionChecker.hashCode());
        result = 31 * result + (this.validateOnMatch == null ? 0 : this.validateOnMatch.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ValidationImpl)) {
            return false;
        }
        ValidationImpl other = (ValidationImpl)obj;
        if (this.checkValidConnectionSql == null ? other.checkValidConnectionSql != null : !this.checkValidConnectionSql.equals(other.checkValidConnectionSql)) {
            return false;
        }
        if (this.exceptionSorter == null ? other.exceptionSorter != null : !this.exceptionSorter.equals((Object)other.exceptionSorter)) {
            return false;
        }
        if (this.staleConnectionChecker == null ? other.staleConnectionChecker != null : !this.staleConnectionChecker.equals((Object)other.staleConnectionChecker)) {
            return false;
        }
        if (this.validConnectionChecker == null ? other.validConnectionChecker != null : !this.validConnectionChecker.equals((Object)other.validConnectionChecker)) {
            return false;
        }
        return !(this.validateOnMatch == null ? other.validateOnMatch != null : !this.validateOnMatch.equals(other.validateOnMatch));
    }
}

