/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.resourceadapter.v11;

import java.util.List;
import java.util.Map;
import org.jboss.jca.common.api.metadata.common.CommonAdminObject;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.common.v11.CommonConnDef;
import org.jboss.jca.common.api.metadata.resourceadapter.v11.ResourceAdapter;
import org.jboss.jca.common.metadata.common.v11.CommonIronJacamarImpl;

public class ResourceAdapterImpl
extends CommonIronJacamarImpl
implements ResourceAdapter {
    private static final long serialVersionUID = 7607776873201143875L;
    protected final String archive;
    protected final String id;

    public ResourceAdapterImpl(String id, String archive, TransactionSupportEnum transactionSupport, List<CommonConnDef> connectionDefinitions, List<CommonAdminObject> adminObjects, Map<String, String> configProperties, List<String> beanValidationGroups, String bootstrapContext) {
        super(transactionSupport, configProperties, adminObjects, connectionDefinitions, beanValidationGroups, bootstrapContext);
        this.id = id;
        this.archive = archive;
    }

    public final String getId() {
        return this.id;
    }

    public final String getArchive() {
        return this.archive;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.archive == null ? 0 : this.archive.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ResourceAdapterImpl)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ResourceAdapterImpl other = (ResourceAdapterImpl)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.archive == null ? other.archive != null : !this.archive.equals(other.archive));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<resource-adapter");
        if (this.id != null) {
            sb.append(" ").append(ResourceAdapter.Attribute.ID).append("=\"").append(this.id).append("\"");
        }
        sb.append(">");
        sb.append("<").append(ResourceAdapter.Tag.ARCHIVE).append(">");
        sb.append(this.archive);
        sb.append("</").append(ResourceAdapter.Tag.ARCHIVE).append(">");
        if (this.beanValidationGroups != null && this.beanValidationGroups.size() > 0) {
            sb.append("<").append(ResourceAdapter.Tag.BEAN_VALIDATION_GROUPS).append(">");
            for (String bvg : this.beanValidationGroups) {
                sb.append("<").append(ResourceAdapter.Tag.BEAN_VALIDATION_GROUP).append(">");
                sb.append(bvg);
                sb.append("</").append(ResourceAdapter.Tag.BEAN_VALIDATION_GROUP).append(">");
            }
            sb.append("</").append(ResourceAdapter.Tag.BEAN_VALIDATION_GROUPS).append(">");
        }
        if (this.bootstrapContext != null) {
            sb.append("<").append(ResourceAdapter.Tag.BOOTSTRAP_CONTEXT).append(">");
            sb.append(this.bootstrapContext);
            sb.append("</").append(ResourceAdapter.Tag.BOOTSTRAP_CONTEXT).append(">");
        }
        if (this.configProperties != null && this.configProperties.size() > 0) {
            for (Map.Entry entry : this.configProperties.entrySet()) {
                sb.append("<").append(ResourceAdapter.Tag.CONFIG_PROPERTY);
                sb.append(" name=\"").append((String)entry.getKey()).append("\">");
                sb.append((String)entry.getValue());
                sb.append("</").append(ResourceAdapter.Tag.CONFIG_PROPERTY).append(">");
            }
        }
        if (this.transactionSupport != null) {
            sb.append("<").append(ResourceAdapter.Tag.TRANSACTION_SUPPORT).append(">");
            sb.append(this.transactionSupport);
            sb.append("</").append(ResourceAdapter.Tag.TRANSACTION_SUPPORT).append(">");
        }
        if (this.connectionDefinitions != null && this.connectionDefinitions.size() > 0) {
            sb.append("<").append(ResourceAdapter.Tag.CONNECTION_DEFINITIONS).append(">");
            for (CommonConnDef cd : this.connectionDefinitions) {
                sb.append(cd);
            }
            sb.append("</").append(ResourceAdapter.Tag.CONNECTION_DEFINITIONS).append(">");
        }
        if (this.adminObjects != null && this.adminObjects.size() > 0) {
            sb.append("<").append(ResourceAdapter.Tag.ADMIN_OBJECTS).append(">");
            for (CommonAdminObject ao : this.adminObjects) {
                sb.append(ao);
            }
            sb.append("</").append(ResourceAdapter.Tag.ADMIN_OBJECTS).append(">");
        }
        sb.append("</resource-adapter>");
        return sb.toString();
    }
}

