/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.common;

import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Messages;

public class CommonValidationImpl
implements CommonValidation {
    private static final long serialVersionUID = 2158460908861877316L;
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    protected final Boolean backgroundValidation;
    protected final Long backgroundValidationMillis;
    protected final Boolean useFastFail;

    public CommonValidationImpl(Boolean backgroundValidation, Long backgroundValidationMillis, Boolean useFastFail) throws ValidateException {
        this.backgroundValidation = backgroundValidation;
        this.backgroundValidationMillis = backgroundValidationMillis;
        this.useFastFail = useFastFail;
        this.partialCommonValidate();
    }

    public final Boolean isBackgroundValidation() {
        return this.backgroundValidation;
    }

    public final Long getBackgroundValidationMillis() {
        return this.backgroundValidationMillis;
    }

    public final Boolean isUseFastFail() {
        return this.useFastFail;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.backgroundValidation == null ? 0 : this.backgroundValidation.hashCode());
        result = 31 * result + (this.backgroundValidationMillis == null ? 0 : this.backgroundValidationMillis.hashCode());
        result = 31 * result + (this.useFastFail == null ? 0 : this.useFastFail.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommonValidationImpl)) {
            return false;
        }
        CommonValidationImpl other = (CommonValidationImpl)obj;
        if (this.backgroundValidation == null ? other.backgroundValidation != null : !this.backgroundValidation.equals(other.backgroundValidation)) {
            return false;
        }
        if (this.backgroundValidationMillis == null ? other.backgroundValidationMillis != null : !this.backgroundValidationMillis.equals(other.backgroundValidationMillis)) {
            return false;
        }
        return !(this.useFastFail == null ? other.useFastFail != null : !this.useFastFail.equals(other.useFastFail));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<validation>");
        if (this.backgroundValidation != null) {
            sb.append("<").append(CommonValidation.Tag.BACKGROUND_VALIDATION).append(">");
            sb.append(this.backgroundValidation);
            sb.append("</").append(CommonValidation.Tag.BACKGROUND_VALIDATION).append(">");
        }
        if (this.backgroundValidationMillis != null) {
            sb.append("<").append(CommonValidation.Tag.BACKGROUND_VALIDATION_MILLIS).append(">");
            sb.append(this.backgroundValidationMillis);
            sb.append("</").append(CommonValidation.Tag.BACKGROUND_VALIDATION_MILLIS).append(">");
        }
        if (this.useFastFail != null) {
            sb.append("<").append(CommonValidation.Tag.USE_FAST_FAIL).append(">");
            sb.append(this.useFastFail);
            sb.append("</").append(CommonValidation.Tag.USE_FAST_FAIL).append(">");
        }
        sb.append("</validation>");
        return sb.toString();
    }

    private void partialCommonValidate() throws ValidateException {
        if (this.backgroundValidationMillis != null && this.backgroundValidationMillis < 0L) {
            throw new ValidateException(bundle.invalidNegative(CommonValidation.Tag.BACKGROUND_VALIDATION_MILLIS.getLocalName()));
        }
    }
}

