/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.common.v12;

import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonSecurity;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.common.v11.ConnDefXaPool;
import org.jboss.jca.common.api.metadata.common.v12.CommonConnDef;
import org.jboss.jca.common.api.metadata.resourceadapter.v12.ResourceAdapter;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.ParserException;
import org.jboss.jca.common.metadata.common.v12.CommonConnDefImpl;
import org.jboss.logging.Messages;

public abstract class CommonIronJacamarParser
extends org.jboss.jca.common.metadata.common.v11.CommonIronJacamarParser {
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);

    protected CommonConnDef parseConnectionDefinitions(XMLStreamReader reader, Boolean isXA) throws XMLStreamException, ParserException, ValidateException {
        HashMap<String, String> configProperties = new HashMap<String, String>();
        CommonSecurity security = null;
        CommonTimeOut timeOut = null;
        CommonValidation validation = null;
        ConnDefXaPool pool = null;
        Recovery recovery = null;
        Boolean useJavaContext = Defaults.USE_JAVA_CONTEXT;
        String className = null;
        Boolean enabled = Defaults.ENABLED;
        String jndiName = null;
        String poolName = null;
        Boolean useCcm = Defaults.USE_CCM;
        Boolean sharable = Defaults.SHARABLE;
        Boolean enlistment = Defaults.ENLISTMENT;
        Boolean connectable = Defaults.CONNECTABLE;
        Boolean tracking = Defaults.TRACKING;
        int attributeSize = reader.getAttributeCount();
        if (isXA == null) {
            isXA = Boolean.FALSE;
        }
        block25: for (int i = 0; i < attributeSize; ++i) {
            CommonConnDef.Attribute attribute = CommonConnDef.Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    enabled = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.ENABLED);
                    continue block25;
                }
                case JNDI_NAME: {
                    jndiName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block25;
                }
                case CLASS_NAME: {
                    className = this.attributeAsString(reader, attribute.getLocalName());
                    continue block25;
                }
                case POOL_NAME: {
                    poolName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block25;
                }
                case USE_JAVA_CONTEXT: {
                    useJavaContext = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.USE_JAVA_CONTEXT);
                    continue block25;
                }
                case USE_CCM: {
                    useCcm = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.USE_CCM);
                    continue block25;
                }
                case SHARABLE: {
                    sharable = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.SHARABLE);
                    continue block25;
                }
                case ENLISTMENT: {
                    enlistment = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.ENLISTMENT);
                    continue block25;
                }
                case CONNECTABLE: {
                    connectable = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.CONNECTABLE);
                    continue block25;
                }
                case TRACKING: {
                    tracking = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.TRACKING);
                    continue block25;
                }
                default: {
                    throw new ParserException(bundle.unexpectedAttribute(attribute.getLocalName(), reader.getLocalName()));
                }
            }
        }
        if (jndiName == null || jndiName.trim().equals("")) {
            throw new ParserException(bundle.missingJndiName(reader.getLocalName()));
        }
        while (reader.hasNext()) {
            block12 : switch (reader.nextTag()) {
                case 2: {
                    if (ResourceAdapter.Tag.forName((String)reader.getLocalName()) == ResourceAdapter.Tag.CONNECTION_DEFINITION) {
                        return new CommonConnDefImpl(configProperties, className, jndiName, poolName, enabled, useJavaContext, useCcm, sharable, enlistment, connectable, tracking, (CommonPool)pool, timeOut, validation, security, recovery, isXA);
                    }
                    if (CommonConnDef.Tag.forName((String)reader.getLocalName()) != CommonConnDef.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (CommonConnDef.Tag.forName((String)reader.getLocalName())) {
                        case CONFIG_PROPERTY: {
                            this.parseConfigProperty(configProperties, reader);
                            break block12;
                        }
                        case SECURITY: {
                            security = this.parseSecuritySettings(reader);
                            break block12;
                        }
                        case TIMEOUT: {
                            timeOut = this.parseTimeOut(reader, isXA);
                            break block12;
                        }
                        case VALIDATION: {
                            validation = this.parseValidation(reader);
                            break block12;
                        }
                        case XA_POOL: {
                            if (pool != null) {
                                throw new ParserException(bundle.multiplePools());
                            }
                            pool = this.parseXaPool(reader);
                            isXA = Boolean.TRUE;
                            break block12;
                        }
                        case POOL: {
                            if (pool != null) {
                                throw new ParserException(bundle.multiplePools());
                            }
                            pool = this.parsePool(reader);
                            break block12;
                        }
                        case RECOVERY: {
                            recovery = this.parseRecovery(reader);
                            break block12;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }
}

