/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.common;

import java.io.BufferedWriter;
import java.io.Externalizable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import javax.naming.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.TransactionSupport;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.TransactionManager;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.Capacity;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.common.Security;
import org.jboss.jca.common.api.metadata.common.SecurityMetadata;
import org.jboss.jca.common.api.metadata.common.TimeOut;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.common.Validation;
import org.jboss.jca.common.api.metadata.common.XaPool;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.common.api.metadata.resourceadapter.WorkManagerSecurity;
import org.jboss.jca.common.api.metadata.spec.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.spec.Connector;
import org.jboss.jca.common.api.metadata.spec.MessageListener;
import org.jboss.jca.common.api.metadata.spec.ResourceAdapter;
import org.jboss.jca.common.api.metadata.spec.XsdString;
import org.jboss.jca.common.metadata.spec.ConfigPropertyImpl;
import org.jboss.jca.core.api.bootstrap.CloneableBootstrapContext;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.api.management.AdminObject;
import org.jboss.jca.core.api.management.ConfigProperty;
import org.jboss.jca.core.api.management.ConnectionFactory;
import org.jboss.jca.core.api.management.ManagedEnlistmentTrace;
import org.jboss.jca.core.api.workmanager.WorkManager;
import org.jboss.jca.core.bootstrapcontext.BootstrapContextCoordinator;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.connectionmanager.ConnectionManagerFactory;
import org.jboss.jca.core.connectionmanager.NoTxConnectionManager;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.api.PoolFactory;
import org.jboss.jca.core.connectionmanager.pool.api.PoolStrategy;
import org.jboss.jca.core.connectionmanager.pool.api.PrefillPool;
import org.jboss.jca.core.connectionmanager.pool.capacity.CapacityFactory;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPoolFactory;
import org.jboss.jca.core.recovery.DefaultRecoveryPlugin;
import org.jboss.jca.core.security.CallbackImpl;
import org.jboss.jca.core.spi.mdr.AlreadyExistsException;
import org.jboss.jca.core.spi.recovery.RecoveryPlugin;
import org.jboss.jca.core.spi.security.Callback;
import org.jboss.jca.core.spi.security.SubjectFactory;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.core.spi.transaction.XAResourceStatistics;
import org.jboss.jca.core.spi.transaction.recovery.XAResourceRecovery;
import org.jboss.jca.core.util.Injection;
import org.jboss.jca.deployers.DeployersBundle;
import org.jboss.jca.deployers.DeployersLogger;
import org.jboss.jca.deployers.common.BeanValidation;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.Configuration;
import org.jboss.jca.deployers.common.DelegatorInvocationHandler;
import org.jboss.jca.deployers.common.DeployException;
import org.jboss.jca.deployers.common.SecurityActions;
import org.jboss.jca.validator.Failure;
import org.jboss.jca.validator.FailureHelper;
import org.jboss.jca.validator.Key;
import org.jboss.jca.validator.Validate;
import org.jboss.jca.validator.ValidateClass;
import org.jboss.jca.validator.ValidateObject;
import org.jboss.jca.validator.Validator;
import org.jboss.jca.validator.ValidatorException;
import org.jboss.logging.Messages;

public abstract class AbstractResourceAdapterDeployer {
    private static DeployersBundle bundle = (DeployersBundle)Messages.getBundle(DeployersBundle.class);
    protected final DeployersLogger log = this.getLogger();
    protected final boolean validateClasses;
    private Configuration configuration = null;

    public AbstractResourceAdapterDeployer(boolean validateClasses) {
        this.validateClasses = validateClasses;
    }

    public void setConfiguration(Configuration value) {
        this.configuration = value;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Set<Failure> validateArchive(URL url, List<Validate> archiveValidation, Set<Failure> failures) {
        if (!this.getConfiguration().getArchiveValidation()) {
            return null;
        }
        for (Validate validate : archiveValidation) {
            if (validate instanceof ValidateObject || this.validateClasses) continue;
            return null;
        }
        Validator validator = new Validator();
        List partialFailures = validator.validate(archiveValidation);
        if (partialFailures != null) {
            if (failures == null) {
                failures = new HashSet<Failure>();
            }
            failures.addAll(partialFailures);
        }
        return failures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printFailuresLog(String urlFileName, Validator validator, Collection<Failure> failures, File reportDirectory, FailureHelper ... fhInput) {
        String errorText = "";
        FailureHelper fh = null;
        fh = fhInput.length == 0 ? new FailureHelper(failures) : fhInput[0];
        if (failures != null && failures.size() > 0) {
            if (reportDirectory == null) {
                reportDirectory = this.getReportDirectory();
            }
            if (reportDirectory != null && reportDirectory.exists()) {
                int lastSepaIndex;
                int lastIndex;
                int lastSlashIndex = urlFileName.lastIndexOf("/");
                int n = lastIndex = lastSlashIndex > (lastSepaIndex = urlFileName.lastIndexOf(File.separator)) ? lastSlashIndex : lastSepaIndex;
                if (lastIndex != -1) {
                    urlFileName = urlFileName.substring(lastIndex + 1);
                }
                urlFileName = urlFileName + ".log";
                File report = new File(reportDirectory, urlFileName);
                FileWriter fw = null;
                BufferedWriter bw = null;
                try {
                    fw = new FileWriter(report);
                    bw = new BufferedWriter(fw, 8192);
                    bw.write(fh.asText(validator.getResourceBundle()));
                    bw.flush();
                    errorText = "Validation failures - see: " + report.getAbsolutePath();
                }
                catch (IOException ioe) {
                    this.log.validationReportFailure(ioe.getMessage(), ioe);
                }
                finally {
                    if (bw != null) {
                        try {
                            bw.close();
                        }
                        catch (IOException ignore) {}
                    }
                    if (fw != null) {
                        try {
                            fw.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
            } else {
                errorText = fh.asText(validator.getResourceBundle());
            }
        }
        return errorText;
    }

    protected boolean hasFailuresLevel(Collection<Failure> failures, int severity) {
        if (failures != null) {
            for (Failure failure : failures) {
                if (failure.getSeverity() != severity) continue;
                return true;
            }
        }
        return false;
    }

    protected void startContext(javax.resource.spi.ResourceAdapter resourceAdapter, String bootstrapContextIdentifier, String bootstrapContextName, Callback cb) throws DeployException {
        try {
            CloneableBootstrapContext cbc = BootstrapContextCoordinator.getInstance().createBootstrapContext(bootstrapContextIdentifier, bootstrapContextName);
            cbc.setResourceAdapter(resourceAdapter);
            if (cb != null) {
                this.setCallbackSecurity((WorkManager)cbc.getWorkManager(), cb);
            }
            resourceAdapter.start((BootstrapContext)cbc);
        }
        catch (Throwable t) {
            throw new DeployException(bundle.unableToStartResourceAdapter(resourceAdapter.getClass().getName()), t);
        }
    }

    protected void setCallbackSecurity(WorkManager workManager, Callback cb) {
        workManager.setCallbackSecurity(cb);
    }

    protected void associateResourceAdapter(javax.resource.spi.ResourceAdapter resourceAdapter, Object object) throws DeployException {
        if (resourceAdapter != null && object != null && object instanceof ResourceAdapterAssociation) {
            try {
                ResourceAdapterAssociation raa = (ResourceAdapterAssociation)object;
                raa.setResourceAdapter(resourceAdapter);
            }
            catch (Throwable t) {
                throw new DeployException(bundle.unableToAssociate(object.getClass().getName()), t);
            }
        }
    }

    private Set<String> findManagedConnectionFactories(ResourceAdapter ra) {
        HashSet<String> result = new HashSet<String>(1);
        if (ra != null && ra.getOutboundResourceadapter() != null) {
            for (ConnectionDefinition cd : ra.getOutboundResourceadapter().getConnectionDefinitions()) {
                result.add(cd.getManagedConnectionFactoryClass().getValue());
            }
        }
        return result;
    }

    private Set<String> resolveAdminObjects(ResourceAdapter ra) {
        HashSet<String> result = new HashSet<String>(1);
        if (ra != null && ra.getAdminObjects() != null) {
            for (org.jboss.jca.common.api.metadata.spec.AdminObject ao : ra.getAdminObjects()) {
                result.add(ao.getAdminobjectClass().getValue());
            }
        }
        return result;
    }

    protected Set<org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition> findConnectionDefinitions(String clz, Set<String> mcfs, List<org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition> defs, ClassLoader cl) throws DeployException {
        HashSet<org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition> result = null;
        if (mcfs != null && defs != null) {
            if (mcfs.size() == 1 && defs.size() == 1) {
                org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition cd = defs.get(0);
                if (cd.getClassName() != null && !clz.equals(cd.getClassName())) {
                    this.log.connectionDefinitionMismatch(cd.getClassName());
                    throw new DeployException(clz + " not a valid connection definition");
                }
                boolean add = true;
                if (cd.getClassName() != null && !this.verifyManagedConnectionFactory(cd.getClassName(), cl)) {
                    this.log.connectionDefinitionInvalid(cd.getClassName());
                    add = false;
                }
                if (add) {
                    result = new HashSet<org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition>(1);
                    result.add(cd);
                    return result;
                }
            }
            if (clz == null) {
                throw new IllegalArgumentException(bundle.undefinedManagedConnectionFactory());
            }
            for (org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition cd : defs) {
                if (cd.getClassName() == null) {
                    this.log.connectionDefinitionNull();
                    continue;
                }
                if (clz.equals(cd.getClassName())) {
                    if (result == null) {
                        result = new HashSet();
                    }
                    result.add(cd);
                    continue;
                }
                if (this.verifyManagedConnectionFactory(cd.getClassName(), cl)) continue;
                this.log.connectionDefinitionInvalid(cd.getClassName());
            }
        }
        return result;
    }

    private boolean verifyManagedConnectionFactory(String clz, ClassLoader cl) {
        if (clz != null) {
            try {
                Class<?> c = Class.forName(clz, true, cl);
                if (ManagedConnectionFactory.class.isAssignableFrom(c)) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean verifyClass(String clz, ClassLoader cl) {
        if (clz != null) {
            try {
                Class<?> c = Class.forName(clz, true, cl);
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean verifyInstance(String interfaceClz, String implClz, ClassLoader cl) {
        if (interfaceClz != null && implClz != null) {
            try {
                Class<?> interfaceDef = Class.forName(interfaceClz, true, cl);
                Class<?> implDef = Class.forName(implClz, true, cl);
                return interfaceDef.isAssignableFrom(implDef);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return false;
    }

    protected Set<org.jboss.jca.common.api.metadata.resourceadapter.AdminObject> findAdminObjects(String clz, Set<String> aos, List<org.jboss.jca.common.api.metadata.resourceadapter.AdminObject> defs) throws DeployException {
        HashSet<Object> result = null;
        if (aos != null && defs != null) {
            if (aos.size() == 1 && defs.size() == 1) {
                org.jboss.jca.common.api.metadata.resourceadapter.AdminObject cao = defs.get(0);
                if (cao.getClassName() != null && !clz.equals(cao.getClassName())) {
                    this.log.adminObjectMismatch(cao.getClassName());
                    throw new DeployException(clz + " not a valid admin object");
                }
                result = new HashSet<org.jboss.jca.common.api.metadata.resourceadapter.AdminObject>(1);
                result.add(cao);
                return result;
            }
            if (clz == null) {
                throw new IllegalArgumentException(bundle.undefinedAdminObject());
            }
            for (org.jboss.jca.common.api.metadata.resourceadapter.AdminObject cao : defs) {
                if (cao.getClassName() == null) {
                    this.log.adminObjectNull();
                    continue;
                }
                if (!clz.equals(cao.getClassName())) continue;
                if (result == null) {
                    result = new HashSet();
                }
                result.add(cao);
            }
        }
        return result;
    }

    protected PoolConfiguration createPoolConfiguration(org.jboss.jca.common.api.metadata.common.Pool pp, TimeOut tp, Validation vp) {
        PoolConfiguration pc = new PoolConfiguration();
        if (pp != null) {
            if (pp.getMinPoolSize() != null) {
                pc.setMinSize(pp.getMinPoolSize().intValue());
            }
            if (pp.getInitialPoolSize() != null) {
                pc.setInitialSize(pp.getInitialPoolSize().intValue());
            }
            if (pp.getMaxPoolSize() != null) {
                pc.setMaxSize(pp.getMaxPoolSize().intValue());
            }
            if (pp.isPrefill() != null) {
                pc.setPrefill(pp.isPrefill().booleanValue());
            }
            if (pp.isUseStrictMin() != null) {
                pc.setStrictMin(pp.isUseStrictMin().booleanValue());
            }
            if (pp.isFair() != null) {
                pc.setFair(pp.isFair().booleanValue());
            }
        }
        if (tp != null) {
            if (tp.getBlockingTimeoutMillis() != null) {
                pc.setBlockingTimeout(tp.getBlockingTimeoutMillis().longValue());
            }
            if (tp.getIdleTimeoutMinutes() != null) {
                pc.setIdleTimeoutMinutes(tp.getIdleTimeoutMinutes().intValue());
            }
        }
        if (vp != null) {
            if (vp.isValidateOnMatch() != null) {
                pc.setValidateOnMatch(vp.isValidateOnMatch().booleanValue());
            }
            if (vp.isBackgroundValidation() != null) {
                pc.setBackgroundValidation(vp.isBackgroundValidation().booleanValue());
            }
            if (vp.getBackgroundValidationMillis() != null) {
                pc.setBackgroundValidationMillis((long)vp.getBackgroundValidationMillis().intValue());
            }
            if (vp.isUseFastFail() != null) {
                pc.setUseFastFail(vp.isUseFastFail().booleanValue());
            }
        }
        return pc;
    }

    public void start() {
        if (!this.checkConfigurationIsValid()) {
            throw new IllegalStateException("Configuration not valid or not defined");
        }
    }

    protected Set<Failure> initActivationSpec(ClassLoader cl, Connector cmd, javax.resource.spi.ResourceAdapter resourceAdapter, List<Validate> archiveValidationObjects, List<Object> beanValidationObjects, Set<Failure> failures, URL url, boolean activateDeployment) throws DeployException {
        List mlMetas;
        ResourceAdapter raSpec;
        if (cmd.getVersion() != Connector.Version.V_10 && (raSpec = cmd.getResourceadapter()) != null && raSpec.getInboundResourceadapter() != null && raSpec.getInboundResourceadapter().getMessageadapter() != null && raSpec.getInboundResourceadapter().getMessageadapter().getMessagelisteners() != null && (mlMetas = raSpec.getInboundResourceadapter().getMessageadapter().getMessagelisteners()).size() > 0) {
            for (MessageListener mlMD : mlMetas) {
                if (mlMD.getActivationspec() == null || mlMD.getActivationspec().getActivationspecClass().getValue() == null) continue;
                List asCps = null;
                if (mlMD.getActivationspec().getConfigProperties() != null) {
                    asCps = mlMD.getActivationspec().getConfigProperties();
                }
                failures = this.validateArchive(url, Arrays.asList(new ValidateClass(Key.ACTIVATION_SPEC, mlMD.getActivationspec().getActivationspecClass().getValue(), cl, asCps)), failures);
                if (this.getConfiguration().getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1) || !activateDeployment) continue;
                String asClass = mlMD.getActivationspec().getActivationspecClass().getValue();
                Object oa = this.initAndInject(asClass, asCps, cl);
                if (oa == null || !(oa instanceof ActivationSpec)) {
                    throw new DeployException(bundle.invalidActivationSpec(asClass));
                }
                ActivationSpec as = (ActivationSpec)oa;
                if (this.log.isTraceEnabled()) {
                    this.log.tracef("ActivationSpec: %s", as.getClass().getName());
                    this.log.tracef("ActivationSpec defined in classloader: %s", SecurityActions.getClassLoader(as.getClass()));
                }
                this.associateResourceAdapter(resourceAdapter, as);
                archiveValidationObjects.add((Validate)new ValidateObject(Key.ACTIVATION_SPEC, (Object)as, asCps));
            }
        }
        return failures;
    }

    protected Set<Failure> initAdminObject(Connector cmd, ClassLoader cl, List<Validate> archiveValidationObjects, List<Object> beanValidationObjects, Set<Failure> failures, URL url, String deploymentName, boolean activateDeployment, javax.resource.spi.ResourceAdapter resourceAdapter, List<org.jboss.jca.common.api.metadata.resourceadapter.AdminObject> aosAct, List<Object> aos, List<String> aoJndiNames, org.jboss.jca.core.api.management.Connector mgtConnector) throws DeployException {
        List aoMetas;
        ResourceAdapter raSpec;
        if (cmd.getVersion() != Connector.Version.V_10 && (raSpec = cmd.getResourceadapter()) != null && raSpec.getAdminObjects() != null && (aoMetas = raSpec.getAdminObjects()).size() > 0) {
            Set<String> aosClz = this.resolveAdminObjects(raSpec);
            HashSet<String> processedAos = new HashSet<String>();
            for (int i = 0; i < aoMetas.size(); ++i) {
                String aoClz;
                org.jboss.jca.common.api.metadata.spec.AdminObject aoMeta = (org.jboss.jca.common.api.metadata.spec.AdminObject)aoMetas.get(i);
                this.log.debugf("Activating: %s", aoMeta);
                if (aoMeta.getAdminobjectClass() == null || aoMeta.getAdminobjectClass().getValue() == null || processedAos.contains(aoClz = aoMeta.getAdminobjectClass().getValue())) continue;
                processedAos.add(aoClz);
                failures = this.validateArchive(url, Arrays.asList(new ValidateClass(Key.ADMIN_OBJECT, aoClz, cl, aoMeta.getConfigProperties())), failures);
                if (this.getConfiguration().getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1)) continue;
                Set<org.jboss.jca.common.api.metadata.resourceadapter.AdminObject> adminObjects = null;
                if (aosAct != null) {
                    adminObjects = this.findAdminObjects(aoClz, aosClz, aosAct);
                }
                if (!this.requireExplicitJndiBindings() && aosAct == null && aosClz.size() == 1) {
                    adminObjects = new HashSet<org.jboss.jca.common.api.metadata.resourceadapter.AdminObject>(1);
                    adminObjects.add(null);
                }
                if (activateDeployment && adminObjects != null) {
                    Injection injector = new Injection();
                    for (org.jboss.jca.common.api.metadata.resourceadapter.AdminObject adminObject : adminObjects) {
                        Object ao = this.initAndInject(aoClz, aoMeta.getConfigProperties(), cl);
                        if (adminObject != null && adminObject.getConfigProperties() != null && adminObject.getConfigProperties().size() > 0) {
                            for (Map.Entry entry : adminObject.getConfigProperties().entrySet()) {
                                try {
                                    injector.inject(ao, (String)entry.getKey(), entry.getValue());
                                }
                                catch (Throwable t) {
                                    throw new DeployException(bundle.unableToInject(ao.getClass().getName(), (String)entry.getKey(), (String)entry.getValue()));
                                }
                            }
                        }
                        this.associateResourceAdapter(resourceAdapter, ao);
                        if (this.log.isTraceEnabled()) {
                            this.log.tracef("AdminObject: %s", ao.getClass().getName());
                            this.log.tracef("AdminObject defined in classloader: %s", SecurityActions.getClassLoader(ao.getClass()));
                        }
                        archiveValidationObjects.add((Validate)new ValidateObject(Key.ADMIN_OBJECT, ao, aoMeta.getConfigProperties()));
                        beanValidationObjects.add(ao);
                        if (ao == null) continue;
                        boolean adminObjectBound = false;
                        boolean adminObjectVerified = false;
                        if (ao instanceof ResourceAdapterAssociation) {
                            if (ao instanceof Serializable && ao instanceof javax.resource.Referenceable) {
                                adminObjectVerified = true;
                            }
                        } else {
                            if (!(ao instanceof Referenceable)) {
                                DelegatorInvocationHandler dih = new DelegatorInvocationHandler(ao);
                                ArrayList interfaces = new ArrayList();
                                Class<?> clz = ao.getClass();
                                while (!clz.equals(Object.class)) {
                                    Class<?>[] is = clz.getInterfaces();
                                    if (is != null) {
                                        for (Class<?> interfaceClass : is) {
                                            if (interfaceClass.equals(javax.resource.Referenceable.class) || interfaceClass.equals(ResourceAdapterAssociation.class) || interfaceClass.equals(Serializable.class) || interfaceClass.equals(Externalizable.class) || interfaces.contains(interfaceClass)) continue;
                                            interfaces.add(interfaceClass);
                                        }
                                    }
                                    clz = clz.getSuperclass();
                                }
                                interfaces.add(Serializable.class);
                                interfaces.add(javax.resource.Referenceable.class);
                                ao = Proxy.newProxyInstance(SecurityActions.getClassLoader(ao.getClass()), interfaces.toArray(new Class[interfaces.size()]), (InvocationHandler)dih);
                            }
                            adminObjectVerified = true;
                        }
                        if (adminObjectVerified) {
                            try {
                                String jndiName = null;
                                if (adminObject != null) {
                                    jndiName = this.buildJndiName(adminObject.getJndiName(), adminObject.isUseJavaContext());
                                    this.bindAdminObject(url, deploymentName, ao, jndiName);
                                } else {
                                    String[] names = this.bindAdminObject(url, deploymentName, ao);
                                    jndiName = names[0];
                                }
                                aos.add(ao);
                                aoJndiNames.add(jndiName);
                                adminObjectBound = true;
                                AdminObject mgtAo = new AdminObject(ao);
                                mgtAo.getConfigProperties().addAll(this.createManagementView(aoMeta.getConfigProperties()));
                                mgtAo.setJndiName(jndiName);
                                mgtConnector.getAdminObjects().add(mgtAo);
                            }
                            catch (Throwable t) {
                                throw new DeployException(bundle.failedToBindAdminObject(ao.getClass().getName()), t);
                            }
                        }
                        if (adminObjectBound) continue;
                        this.log.adminObjectNotBound(aoClz);
                        this.log.adminObjectNotSpecCompliant(aoClz);
                    }
                    continue;
                }
                this.log.debugf("No activation: %s", aoClz);
            }
        }
        return failures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadNativeLibraries(File root) {
        if (root != null && root.exists()) {
            ArrayList<String> libs = null;
            if (root.isDirectory()) {
                if (root.listFiles() != null) {
                    for (File f : root.listFiles()) {
                        String fileName = f.getName().toLowerCase(Locale.US);
                        if (!fileName.endsWith(".a") && !fileName.endsWith(".so") && !fileName.endsWith(".dll")) continue;
                        if (libs == null) {
                            libs = new ArrayList<String>();
                        }
                        libs.add(f.getAbsolutePath());
                    }
                } else {
                    this.log.debugf("Root is a directory, but there were an I/O error: %s", root.getAbsolutePath());
                }
            } else {
                JarFile jarFile = null;
                try {
                    jarFile = new JarFile(root);
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry jarEntry = entries.nextElement();
                        String entryName = jarEntry.getName().toLowerCase(Locale.US);
                        if (!entryName.endsWith(".a") && !entryName.endsWith(".so") && !entryName.endsWith(".dll")) continue;
                        if (libs == null) {
                            libs = new ArrayList();
                        }
                        libs.add(jarEntry.getName());
                    }
                }
                catch (Throwable t) {
                    this.log.debugf("Unable to load native libraries from: %s", root.getAbsolutePath());
                }
                finally {
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
            if (libs != null) {
                for (String lib : libs) {
                    try {
                        SecurityActions.load(lib);
                        this.log.debugf("Loaded library: %s", lib);
                    }
                    catch (Throwable t) {
                        this.log.debugf("Unable to load library: %s", lib);
                    }
                }
            }
        }
    }

    protected CommonDeployment createObjectsAndInjectValue(URL url, String deploymentName, File root, ClassLoader cl, Connector cmd, Activation activation) throws DeployException, ResourceException, ValidatorException, AlreadyExistsException, ClassNotFoundException, Throwable {
        Set<Failure> failures = null;
        try {
            String mgtUniqueId;
            if (cmd != null && cmd.getLicense() != null && cmd.getLicense().isLicenseRequired()) {
                this.log.requiredLicenseTerms(url.toExternalForm());
            }
            if ((mgtUniqueId = url.getFile()).indexOf("/") != -1) {
                mgtUniqueId = mgtUniqueId.substring(mgtUniqueId.lastIndexOf("/") + 1);
            }
            org.jboss.jca.core.api.management.Connector mgtConnector = new org.jboss.jca.core.api.management.Connector(mgtUniqueId);
            Object resourceAdapter = null;
            Map raConfigProperties = null;
            String resourceAdapterKey = null;
            String bootstrapContextIdentifier = null;
            ArrayList<Validate> archiveValidationObjects = new ArrayList<Validate>();
            ArrayList<Object> beanValidationObjects = new ArrayList<Object>();
            ArrayList<Object> cfs = new ArrayList<Object>();
            ArrayList<String> cfJndiNames = new ArrayList<String>();
            ArrayList<NoTxConnectionManager> cfCMs = new ArrayList<NoTxConnectionManager>();
            ArrayList<Object> aos = new ArrayList<Object>();
            ArrayList<String> aoJndiNames = new ArrayList<String>();
            ArrayList<XAResourceRecovery> recoveryModules = new ArrayList<XAResourceRecovery>(1);
            Callback callback = null;
            boolean isXA = false;
            boolean activateDeployment = this.checkActivation(cmd, activation);
            if (this.log.isTraceEnabled()) {
                this.log.tracef("Connector=%s", cmd);
                this.log.tracef("Activation=%s", this.stripPassword(activation != null ? activation.toString() : ""));
                this.log.tracef("ActivateDeployment=%s", activateDeployment);
            }
            if (activateDeployment) {
                this.loadNativeLibraries(root);
            }
            if (activation != null && activation.getWorkManager() != null && activation.getWorkManager().getSecurity() != null) {
                callback = this.createCallback(activation.getWorkManager().getSecurity());
            }
            if (cmd != null) {
                List cdMetas;
                ResourceAdapter ra = cmd.getResourceadapter();
                if (cmd.getVersion() != Connector.Version.V_10) {
                    if ((cmd.getVersion() == Connector.Version.V_16 || cmd.getVersion() == Connector.Version.V_17) && cmd.getRequiredWorkContexts() != null && cmd.getRequiredWorkContexts().size() > 0) {
                        CloneableBootstrapContext bc = BootstrapContextCoordinator.getInstance().getDefaultBootstrapContext();
                        for (String string : cmd.getRequiredWorkContexts()) {
                            try {
                                Class<?> rwc = Class.forName(string, true, cl);
                                if (bc.isContextSupported(rwc)) continue;
                                throw new DeployException(bundle.invalidRequiredWorkContext(string));
                            }
                            catch (Throwable t) {
                                throw new DeployException(bundle.invalidRequiredWorkContext(string), t);
                            }
                        }
                    }
                    if (ra != null && ra.getResourceadapterClass() != null) {
                        failures = this.validateArchive(url, Arrays.asList(new ValidateClass(Key.RESOURCE_ADAPTER, ra.getResourceadapterClass(), cl, cmd.getResourceadapter().getConfigProperties())), failures);
                        if (!(this.getConfiguration().getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1) || !activateDeployment)) {
                            String raClz = ra.getResourceadapterClass();
                            Object or = this.initAndInject(raClz, ra.getConfigProperties(), cl);
                            if (or == null || !(or instanceof javax.resource.spi.ResourceAdapter)) {
                                throw new DeployException(bundle.invalidResourceAdapter(raClz));
                            }
                            resourceAdapter = (javax.resource.spi.ResourceAdapter)or;
                            if (activation != null) {
                                raConfigProperties = activation.getConfigProperties();
                            }
                            if (raConfigProperties != null) {
                                Injection injection = new Injection();
                                for (Map.Entry entry : raConfigProperties.entrySet()) {
                                    try {
                                        injection.inject(resourceAdapter, (String)entry.getKey(), entry.getValue());
                                    }
                                    catch (Throwable t) {
                                        throw new DeployException(bundle.unableToInject(resourceAdapter.getClass().getName(), (String)entry.getKey(), (String)entry.getValue()));
                                    }
                                }
                            }
                            if (this.log.isTraceEnabled()) {
                                this.log.tracef("ResourceAdapter: %s", resourceAdapter.getClass().getName());
                                this.log.tracef("ResourceAdapter defined in classloader: %s", SecurityActions.getClassLoader(resourceAdapter.getClass()));
                            }
                            archiveValidationObjects.add((Validate)new ValidateObject(Key.RESOURCE_ADAPTER, resourceAdapter, ra.getConfigProperties()));
                            beanValidationObjects.add(resourceAdapter);
                            if (activateDeployment) {
                                org.jboss.jca.core.api.management.ResourceAdapter resourceAdapter2 = new org.jboss.jca.core.api.management.ResourceAdapter((javax.resource.spi.ResourceAdapter)resourceAdapter);
                                resourceAdapter2.getConfigProperties().addAll(this.createManagementView(ra.getConfigProperties()));
                                mgtConnector.setResourceAdapter(resourceAdapter2);
                            }
                        }
                    }
                }
                if (ra != null && ra.getOutboundResourceadapter() != null && ra.getOutboundResourceadapter().getConnectionDefinitions() != null && (cdMetas = ra.getOutboundResourceadapter().getConnectionDefinitions()).size() > 0) {
                    Set<String> mcfs = this.findManagedConnectionFactories(ra);
                    HashSet<String> hashSet = new HashSet<String>();
                    for (int cdIndex = 0; cdIndex < cdMetas.size(); ++cdIndex) {
                        List cdDefs;
                        ConnectionDefinition cdMeta = (ConnectionDefinition)cdMetas.get(cdIndex);
                        String mcfClz = cdMeta.getManagedConnectionFactoryClass().getValue();
                        if (hashSet.contains(mcfClz)) continue;
                        hashSet.add(mcfClz);
                        this.log.debugf("CdMeta: %s", cdMeta);
                        failures = this.validateArchive(url, Arrays.asList(new ValidateClass(Key.MANAGED_CONNECTION_FACTORY, mcfClz, cl, cdMeta.getConfigProperties())), failures);
                        if (this.getConfiguration().getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1)) continue;
                        Set<org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition> connectionDefinitions = null;
                        if (activation != null && (cdDefs = activation.getConnectionDefinitions()) != null) {
                            connectionDefinitions = this.findConnectionDefinitions(mcfClz, mcfs, cdDefs, cl);
                        }
                        if (!this.requireExplicitJndiBindings() && activation == null && mcfs.size() == 1) {
                            connectionDefinitions = new HashSet<org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition>(1);
                            connectionDefinitions.add(null);
                        }
                        if (activateDeployment && connectionDefinitions != null) {
                            this.log.debugf("ConnectionDefinitions: %s", connectionDefinitions.size());
                            String cfIntClz = cdMeta.getConnectionFactoryInterface().getValue();
                            if (!this.verifyClass(cfIntClz, cl)) {
                                throw new DeployException(bundle.invalidConnectionFactoryInterface(cfIntClz));
                            }
                            String cfImplClz = cdMeta.getConnectionFactoryImplClass().getValue();
                            if (!this.verifyClass(cfImplClz, cl)) {
                                throw new DeployException(bundle.invalidConnectionFactoryImplementation(cfImplClz));
                            }
                            if (!this.verifyInstance(cfIntClz, cfImplClz, cl)) {
                                throw new DeployException(bundle.invalidConnectionFactoryImplementationDueToInterface(cfImplClz, cfIntClz));
                            }
                            String cIntClz = cdMeta.getConnectionInterface().getValue();
                            if (!this.verifyClass(cIntClz, cl)) {
                                throw new DeployException(bundle.invalidConnectionInterface(cIntClz));
                            }
                            String cImplClz = cdMeta.getConnectionImplClass().getValue();
                            if (!this.verifyClass(cImplClz, cl)) {
                                throw new DeployException(bundle.invalidConnectionImplementation(cImplClz));
                            }
                            if (!this.verifyInstance(cIntClz, cImplClz, cl)) {
                                throw new DeployException(bundle.invalidConnectionImplementationDueToInterface(cImplClz, cIntClz));
                            }
                            for (org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition connectionDefinition : connectionDefinitions) {
                                ManagedConnectionPoolFactory mcpf;
                                String mcpClass;
                                XaPool xaPool;
                                this.log.debugf("Activating: %s", connectionDefinition);
                                if (connectionDefinition != null && !connectionDefinition.isEnabled().booleanValue()) continue;
                                Object om = this.initAndInject(mcfClz, cdMeta.getConfigProperties(), cl);
                                if (om == null || !(om instanceof ManagedConnectionFactory)) {
                                    throw new DeployException(bundle.invalidManagedConnectionFactory(mcfClz));
                                }
                                ManagedConnectionFactory mcf = (ManagedConnectionFactory)om;
                                if (connectionDefinition != null && connectionDefinition.getConfigProperties() != null) {
                                    Injection injector = new Injection();
                                    for (Map.Entry entry : connectionDefinition.getConfigProperties().entrySet()) {
                                        try {
                                            injector.inject((Object)mcf, (String)entry.getKey(), entry.getValue());
                                        }
                                        catch (Throwable t) {
                                            throw new DeployException(bundle.unableToInject(mcf.getClass().getName(), (String)entry.getKey(), (String)entry.getValue()));
                                        }
                                    }
                                }
                                if (this.log.isTraceEnabled()) {
                                    this.log.tracef("ManagedConnectionFactory: %s", mcf.getClass().getName());
                                    this.log.tracef("ManagedConnectionFactory defined in classloader: %s", SecurityActions.getClassLoader(mcf.getClass()));
                                }
                                mcf.setLogWriter(this.getLogPrintWriter());
                                archiveValidationObjects.add((Validate)new ValidateObject(Key.MANAGED_CONNECTION_FACTORY, (Object)mcf, cdMeta.getConfigProperties()));
                                beanValidationObjects.add(mcf);
                                this.associateResourceAdapter((javax.resource.spi.ResourceAdapter)resourceAdapter, mcf);
                                PoolConfiguration pc = null;
                                FlushStrategy flushStrategy = FlushStrategy.FAILING_CONNECTION_ONLY;
                                if (connectionDefinition != null) {
                                    pc = this.createPoolConfiguration(connectionDefinition.getPool(), connectionDefinition.getTimeOut(), connectionDefinition.getValidation());
                                    if (connectionDefinition.getPool() != null) {
                                        flushStrategy = connectionDefinition.getPool().getFlushStrategy();
                                    }
                                } else {
                                    pc = this.createPoolConfiguration(null, null, null);
                                }
                                if (connectionDefinition != null && (connectionDefinition.getValidation() == null || connectionDefinition.getValidation().isValidateOnMatch() == null && connectionDefinition.getValidation().isBackgroundValidation() == null) && !pc.isValidateOnMatch() && !pc.isBackgroundValidation() && mcf instanceof ValidatingManagedConnectionFactory) {
                                    this.log.enablingValidateOnMatch(connectionDefinition.getJndiName());
                                    pc.setValidateOnMatch(true);
                                }
                                if (flushStrategy == null) {
                                    flushStrategy = FlushStrategy.FAILING_CONNECTION_ONLY;
                                }
                                PoolFactory pf = new PoolFactory();
                                Boolean noTxSeparatePool = Defaults.NO_TX_SEPARATE_POOL;
                                if (connectionDefinition != null && connectionDefinition.getPool() != null && connectionDefinition.isXa().booleanValue() && (xaPool = (XaPool)connectionDefinition.getPool()) != null) {
                                    noTxSeparatePool = xaPool.isNoTxSeparatePool();
                                }
                                Security security = null;
                                if (connectionDefinition != null && connectionDefinition.getSecurity() != null) {
                                    security = connectionDefinition.getSecurity();
                                }
                                PoolStrategy strategy = PoolStrategy.ONE_POOL;
                                String securityDomain = null;
                                boolean isCRI = false;
                                if (security != null) {
                                    if (security.isApplication()) {
                                        strategy = PoolStrategy.POOL_BY_CRI;
                                        pc.setMinSize(0);
                                        isCRI = true;
                                    } else if (security.getSecurityDomain() != null && security.getSecurityDomain().trim().length() != 0) {
                                        strategy = PoolStrategy.POOL_BY_SUBJECT;
                                        securityDomain = security.getSecurityDomain();
                                    } else if (security.getSecurityDomainAndApplication() != null && security.getSecurityDomainAndApplication().trim().length() != 0) {
                                        strategy = PoolStrategy.POOL_BY_SUBJECT_AND_CRI;
                                        securityDomain = security.getSecurityDomainAndApplication();
                                        pc.setMinSize(0);
                                        isCRI = true;
                                    }
                                }
                                if (ra != null && ra.getOutboundResourceadapter() != null && ra.getOutboundResourceadapter().getReauthenticationSupport()) {
                                    strategy = PoolStrategy.REAUTH;
                                    isCRI = false;
                                }
                                Boolean sharable = Defaults.SHARABLE;
                                Boolean enlistment = Defaults.ENLISTMENT;
                                Boolean connectable = Defaults.CONNECTABLE;
                                Boolean tracking = Defaults.TRACKING;
                                if (connectionDefinition != null) {
                                    sharable = connectionDefinition.isSharable();
                                    enlistment = connectionDefinition.isEnlistment();
                                    connectable = connectionDefinition.isConnectable();
                                    tracking = connectionDefinition.isTracking();
                                }
                                String string = mcpClass = connectionDefinition != null ? connectionDefinition.getMcp() : null;
                                if (mcpClass == null && (mcpf = new ManagedConnectionPoolFactory()).isOverride()) {
                                    mcpClass = mcpf.getDefaultImplementation();
                                }
                                if (mcpClass == null) {
                                    mcpClass = "org.jboss.jca.core.connectionmanager.pool.mcp.SemaphoreConcurrentLinkedDequeManagedConnectionPool";
                                }
                                Pool pool = pf.create(strategy, mcf, pc, noTxSeparatePool.booleanValue(), sharable.booleanValue(), mcpClass);
                                this.applyCapacity(connectionDefinition, pool, isCRI);
                                ConnectionManagerFactory cmf = new ConnectionManagerFactory();
                                NoTxConnectionManager cm = null;
                                TransactionSupport.TransactionSupportLevel tsl = TransactionSupport.TransactionSupportLevel.NoTransaction;
                                TransactionSupportEnum tsmd = TransactionSupportEnum.NoTransaction;
                                tsmd = activation != null && activation.getTransactionSupport() != null ? activation.getTransactionSupport() : ra.getOutboundResourceadapter().getTransactionSupport();
                                if (tsmd == TransactionSupportEnum.NoTransaction) {
                                    tsl = TransactionSupport.TransactionSupportLevel.NoTransaction;
                                } else if (tsmd == TransactionSupportEnum.LocalTransaction) {
                                    tsl = TransactionSupport.TransactionSupportLevel.LocalTransaction;
                                } else if (tsmd == TransactionSupportEnum.XATransaction) {
                                    tsl = TransactionSupport.TransactionSupportLevel.XATransaction;
                                }
                                if (mcf instanceof TransactionSupport) {
                                    TransactionSupport.TransactionSupportLevel oldTSL = tsl;
                                    tsl = ((TransactionSupport)mcf).getTransactionSupport();
                                    if (tsl != oldTSL) {
                                        this.log.changedTransactionSupport(connectionDefinition != null ? connectionDefinition.getJndiName() : mcf.getClass().getName());
                                    }
                                }
                                XAResourceRecovery recoveryImpl = null;
                                boolean enableRecovery = false;
                                Integer allocationRetry = null;
                                Long allocationRetryWaitMillis = null;
                                if (connectionDefinition != null && connectionDefinition.getTimeOut() != null) {
                                    allocationRetry = connectionDefinition.getTimeOut().getAllocationRetry();
                                    allocationRetryWaitMillis = connectionDefinition.getTimeOut().getAllocationRetryWaitMillis();
                                }
                                Boolean useCCM = Boolean.TRUE;
                                if (connectionDefinition != null) {
                                    useCCM = connectionDefinition.isUseCcm();
                                }
                                if (tsl == TransactionSupport.TransactionSupportLevel.NoTransaction) {
                                    cm = cmf.createNonTransactional(tsl, pool, this.getSubjectFactory((SecurityMetadata)security), securityDomain, useCCM.booleanValue(), this.getCachedConnectionManager(), sharable.booleanValue(), enlistment.booleanValue(), connectable.booleanValue(), tracking, flushStrategy, allocationRetry, allocationRetryWaitMillis);
                                } else {
                                    Boolean interleaving = Defaults.INTERLEAVING;
                                    Integer xaResourceTimeout = null;
                                    Boolean isSameRMOverride = Defaults.IS_SAME_RM_OVERRIDE;
                                    Boolean wrapXAResource = Defaults.WRAP_XA_RESOURCE;
                                    Boolean padXid = Defaults.PAD_XID;
                                    Recovery recoveryMD = null;
                                    Boolean enlistmentTrace = Defaults.ENLISTMENT_TRACE;
                                    if (connectionDefinition != null && connectionDefinition.isXa().booleanValue()) {
                                        TimeOut timeout;
                                        XaPool xaPool2 = (XaPool)connectionDefinition.getPool();
                                        if (xaPool2 != null) {
                                            interleaving = xaPool2.isInterleaving();
                                            isSameRMOverride = xaPool2.isSameRmOverride();
                                            wrapXAResource = xaPool2.isWrapXaResource();
                                            padXid = xaPool2.isPadXid();
                                        }
                                        if ((timeout = connectionDefinition.getTimeOut()) != null) {
                                            xaResourceTimeout = timeout.getXaResourceTimeout();
                                        }
                                        recoveryMD = connectionDefinition.getRecovery();
                                    }
                                    pool.setInterleaving(interleaving.booleanValue());
                                    if (connectionDefinition != null) {
                                        enlistmentTrace = connectionDefinition.isEnlistmentTrace();
                                    }
                                    org.jboss.jca.core.api.management.ConnectionManager mgtCM = new org.jboss.jca.core.api.management.ConnectionManager(connectionDefinition.getJndiName());
                                    mgtCM.setEnlistmentTrace(enlistmentTrace);
                                    mgtConnector.getConnectionManagers().add(mgtCM);
                                    cm = cmf.createTransactional(tsl, pool, this.getSubjectFactory((SecurityMetadata)security), securityDomain, useCCM.booleanValue(), this.getCachedConnectionManager(), sharable.booleanValue(), enlistment.booleanValue(), connectable.booleanValue(), tracking, (ManagedEnlistmentTrace)mgtCM, flushStrategy, allocationRetry, allocationRetryWaitMillis, this.getTransactionIntegration(), interleaving, xaResourceTimeout, isSameRMOverride, wrapXAResource, padXid);
                                    if (tsl == TransactionSupport.TransactionSupportLevel.XATransaction) {
                                        isXA = true;
                                        Security recoverSecurityMetadata = security;
                                        String recoverUser = null;
                                        String recoverPassword = null;
                                        String recoverSecurityDomain = securityDomain;
                                        if (recoveryMD == null || recoveryMD.getNoRecovery() == null || !recoveryMD.getNoRecovery().booleanValue()) {
                                            Credential credential;
                                            enableRecovery = true;
                                            Credential credential2 = credential = recoveryMD != null ? recoveryMD.getCredential() : null;
                                            if (credential != null) {
                                                if (credential.getSecurityDomain() != null) {
                                                    recoverSecurityMetadata = credential;
                                                    recoverSecurityDomain = credential.getSecurityDomain();
                                                }
                                                recoverUser = credential.getUserName();
                                                recoverPassword = credential.getPassword();
                                            }
                                            if (this.log.isDebugEnabled()) {
                                                this.log.debug("RecoverUser=" + recoverUser);
                                                this.log.debug("RecoverSecurityDomain=" + recoverSecurityDomain);
                                            }
                                            if (recoverUser != null && !recoverUser.trim().equals("") && recoverPassword != null && !recoverPassword.trim().equals("") || recoverSecurityDomain != null && !recoverSecurityDomain.trim().equals("")) {
                                                DefaultRecoveryPlugin plugin = null;
                                                if (recoveryMD != null && recoveryMD.getRecoverPlugin() != null && recoveryMD.getRecoverPlugin().getClassName() != null) {
                                                    ArrayList<ConfigPropertyImpl> configProperties = new ArrayList<ConfigPropertyImpl>(recoveryMD.getRecoverPlugin().getConfigPropertiesMap().size());
                                                    for (Map.Entry property : recoveryMD.getRecoverPlugin().getConfigPropertiesMap().entrySet()) {
                                                        ConfigPropertyImpl c = new ConfigPropertyImpl(null, new XsdString((String)property.getKey(), null), XsdString.NULL_XSDSTRING, new XsdString((String)property.getValue(), null), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, false, null, null, null, null);
                                                        configProperties.add(c);
                                                    }
                                                    plugin = (RecoveryPlugin)this.initAndInject(recoveryMD.getRecoverPlugin().getClassName(), configProperties, cl);
                                                } else {
                                                    plugin = new DefaultRecoveryPlugin();
                                                }
                                                XAResourceStatistics xastat = null;
                                                if (pool.getStatistics() != null && pool.getStatistics() instanceof XAResourceStatistics) {
                                                    xastat = (XAResourceStatistics)pool.getStatistics();
                                                }
                                                recoveryImpl = this.getTransactionIntegration().createXAResourceRecovery(mcf, padXid, isSameRMOverride, wrapXAResource, recoverUser, recoverPassword, recoverSecurityDomain, this.getSubjectFactory((SecurityMetadata)recoverSecurityMetadata), (RecoveryPlugin)plugin, xastat);
                                            }
                                        }
                                    }
                                }
                                Object cf = mcf.createConnectionFactory((javax.resource.spi.ConnectionManager)cm);
                                if (cf == null) {
                                    this.log.nullConnectionFactory();
                                } else if (this.log.isTraceEnabled()) {
                                    this.log.tracef("ConnectionFactory: %s", cf.getClass().getName());
                                    this.log.tracef("ConnectionFactory defined in classloader: %s", SecurityActions.getClassLoader(cf.getClass()));
                                }
                                archiveValidationObjects.add((Validate)new ValidateObject(Key.CONNECTION_FACTORY, cf));
                                if (cf != null && cf instanceof Serializable && cf instanceof javax.resource.Referenceable) {
                                    String jndiName;
                                    if (connectionDefinition != null) {
                                        jndiName = this.buildJndiName(connectionDefinition.getJndiName(), connectionDefinition.isUseJavaContext());
                                        this.bindConnectionFactory(url, deploymentName, cf, jndiName);
                                        cfs.add(cf);
                                        cfJndiNames.add(jndiName);
                                        cm.setJndiName(jndiName);
                                        cfCMs.add(cm);
                                        String poolName = null;
                                        if (connectionDefinition != null) {
                                            poolName = connectionDefinition.getPoolName();
                                        }
                                        if (poolName == null) {
                                            poolName = jndiName;
                                        }
                                        pool.setName(poolName);
                                    } else {
                                        String[] bindCfJndiNames = this.bindConnectionFactory(url, deploymentName, cf);
                                        cfs.add(cf);
                                        cfJndiNames.addAll(Arrays.asList(bindCfJndiNames));
                                        cm.setJndiName(bindCfJndiNames[0]);
                                        cfCMs.add(cm);
                                        String poolName = null;
                                        if (connectionDefinition != null) {
                                            poolName = connectionDefinition.getPoolName();
                                        }
                                        if (poolName == null) {
                                            poolName = (String)cfJndiNames.get(0);
                                        }
                                        jndiName = poolName;
                                        pool.setName(poolName);
                                    }
                                    if (enableRecovery && this.getTransactionIntegration().getRecoveryRegistry() != null) {
                                        if (recoveryImpl != null) {
                                            recoveryImpl.setJndiName(cm.getJndiName());
                                            recoveryImpl.initialize();
                                            this.getTransactionIntegration().getRecoveryRegistry().addXAResourceRecovery(recoveryImpl);
                                        } else {
                                            this.log.missingRecovery(cm.getJndiName());
                                        }
                                    }
                                    recoveryModules.add(recoveryImpl);
                                    if (!activateDeployment) continue;
                                    ConnectionFactory mgtCf = new ConnectionFactory(cf, mcf);
                                    mgtCf.setPoolConfiguration(pc);
                                    mgtCf.setPool((org.jboss.jca.core.api.connectionmanager.pool.Pool)pool);
                                    mgtCf.setJndiName(jndiName);
                                    mgtCf.getManagedConnectionFactory().getConfigProperties().addAll(this.createManagementView(cdMeta.getConfigProperties()));
                                    mgtConnector.getConnectionFactories().add(mgtCf);
                                    if (!(pool instanceof PrefillPool)) continue;
                                    PrefillPool pp = (PrefillPool)pool;
                                    SubjectFactory subjectFactory = this.getSubjectFactory((SecurityMetadata)security);
                                    Subject subject = null;
                                    if (subjectFactory != null) {
                                        subject = this.createSubject(subjectFactory, securityDomain, mcf);
                                    }
                                    pp.prefill(subject, null, noTxSeparatePool.booleanValue());
                                    continue;
                                }
                                this.log.connectionFactoryNotBound(mcf.getClass().getName());
                                if (cf != null) {
                                    this.log.connectionFactoryNotSpecCompliant(cf.getClass().getName());
                                    continue;
                                }
                                this.log.connectionFactoryNotSpecCompliant(mcf.getClass().getName());
                            }
                            continue;
                        }
                        this.log.debugf("No activation: %s", mcfClz);
                    }
                }
                failures = this.initActivationSpec(cl, cmd, (javax.resource.spi.ResourceAdapter)resourceAdapter, (List<Validate>)archiveValidationObjects, (List<Object>)beanValidationObjects, failures, url, activateDeployment);
                failures = this.initAdminObject(cmd, cl, (List<Validate>)archiveValidationObjects, (List<Object>)beanValidationObjects, failures, url, deploymentName, activateDeployment, (javax.resource.spi.ResourceAdapter)resourceAdapter, activation != null ? activation.getAdminObjects() : null, (List<Object>)aos, (List<String>)aoJndiNames, (org.jboss.jca.core.api.management.Connector)(activateDeployment ? mgtConnector : null));
            }
            failures = this.validateArchive(url, archiveValidationObjects, failures);
            if (this.getConfiguration().getArchiveValidationFailOnWarn() && (this.hasFailuresLevel(failures, 0) || this.hasFailuresLevel(failures, 1)) || this.getConfiguration().getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1)) {
                throw new ValidatorException(this.printFailuresLog(url.getPath(), new Validator(), failures, null, new FailureHelper[0]), failures);
            }
            if (failures != null && failures.size() > 0) {
                this.log.validationInvalidArchive(url.toExternalForm());
            }
            this.printFailuresLog(url.getPath(), new Validator(), failures, null, new FailureHelper[0]);
            if (cmd != null) {
                try {
                    this.registerResourceAdapterToMDR(url, root, cmd, activation);
                }
                catch (AlreadyExistsException e) {
                    // empty catch block
                }
            }
            if (activateDeployment) {
                if (this.getConfiguration().getBeanValidation() && (cmd.getVersion() == Connector.Version.V_16 || cmd.getVersion() == Connector.Version.V_17)) {
                    ArrayList<Class> groupsClasses = null;
                    if (activation != null && activation.getBeanValidationGroups() != null && activation.getBeanValidationGroups().size() > 0) {
                        groupsClasses = new ArrayList<Class>();
                        for (String group : activation.getBeanValidationGroups()) {
                            groupsClasses.add(Class.forName(group, true, cl));
                        }
                    }
                    if (beanValidationObjects.size() > 0) {
                        BeanValidation beanValidator = this.getBeanValidation();
                        for (Object e : beanValidationObjects) {
                            beanValidator.validate(e, groupsClasses);
                        }
                    }
                }
                if (resourceAdapter != null) {
                    String bootstrapContextName = null;
                    if (activation != null && activation.getBootstrapContext() != null && !activation.getBootstrapContext().trim().equals("")) {
                        bootstrapContextName = activation.getBootstrapContext();
                    }
                    bootstrapContextIdentifier = BootstrapContextCoordinator.getInstance().createIdentifier(resourceAdapter.getClass().getName(), raConfigProperties, bootstrapContextName);
                    this.startContext((javax.resource.spi.ResourceAdapter)resourceAdapter, bootstrapContextIdentifier, bootstrapContextName, callback);
                    resourceAdapterKey = this.registerResourceAdapterToResourceAdapterRepository((javax.resource.spi.ResourceAdapter)resourceAdapter);
                    this.setRecoveryForResourceAdapterInResourceAdapterRepository(resourceAdapterKey, isXA);
                }
            }
            if (activateDeployment) {
                this.log.deployed(url.toExternalForm());
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Activated: " + url.toExternalForm());
            }
            Object[] cfObjs = cfs.size() > 0 ? cfs.toArray(new Object[cfs.size()]) : null;
            String[] cfJndis = cfJndiNames.size() > 0 ? cfJndiNames.toArray(new String[cfJndiNames.size()]) : null;
            ConnectionManager[] cfCM = cfCMs.size() > 0 ? cfCMs.toArray(new ConnectionManager[cfCMs.size()]) : null;
            Object[] objectArray = aos.size() > 0 ? aos.toArray(new Object[aos.size()]) : null;
            String[] aoJndis = aoJndiNames.size() > 0 ? aoJndiNames.toArray(new String[aoJndiNames.size()]) : null;
            return new CommonDeployment(url, deploymentName, activateDeployment, (javax.resource.spi.ResourceAdapter)resourceAdapter, resourceAdapterKey, bootstrapContextIdentifier, cfObjs, cfJndis, cfCM, objectArray, aoJndis, recoveryModules.toArray(new XAResourceRecovery[recoveryModules.size()]), mgtConnector, null, cl, this.log);
        }
        catch (DeployException de) {
            throw de;
        }
        catch (Throwable t) {
            if (this.getConfiguration().getArchiveValidationFailOnWarn() && (this.hasFailuresLevel(failures, 0) || this.hasFailuresLevel(failures, 1)) || this.getConfiguration().getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1)) {
                throw new DeployException(bundle.deploymentFailed(url.toExternalForm()), (Throwable)new ValidatorException(this.printFailuresLog(url.getPath(), new Validator(), failures, null, new FailureHelper[0]), failures));
            }
            this.printFailuresLog(url.getPath(), new Validator(), failures, null, new FailureHelper[0]);
            throw new DeployException(bundle.deploymentFailed(url.toExternalForm()), t);
        }
    }

    protected String buildJndiName(String jndiName, Boolean javaContext) {
        if (javaContext != null) {
            if (javaContext.booleanValue() && !jndiName.startsWith("java:")) {
                jndiName = "java:" + jndiName;
            } else if (!javaContext.booleanValue() && jndiName.startsWith("java:")) {
                jndiName = jndiName.substring(6);
            }
        }
        return jndiName;
    }

    protected boolean requireExplicitJndiBindings() {
        return true;
    }

    protected abstract SubjectFactory getSubjectFactory(SecurityMetadata var1) throws DeployException;

    protected Subject createSubject(final SubjectFactory subjectFactory, final String securityDomain, final ManagedConnectionFactory mcf) {
        if (subjectFactory == null) {
            throw new IllegalArgumentException("SubjectFactory is null");
        }
        if (securityDomain == null) {
            throw new IllegalArgumentException("SecurityDomain is null");
        }
        return AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                try {
                    Subject subject = subjectFactory.createSubject(securityDomain);
                    Set<PasswordCredential> pcs = subject.getPrivateCredentials(PasswordCredential.class);
                    if (pcs.size() > 0) {
                        for (PasswordCredential pc : pcs) {
                            pc.setManagedConnectionFactory(mcf);
                        }
                    }
                    if (AbstractResourceAdapterDeployer.this.log.isDebugEnabled()) {
                        AbstractResourceAdapterDeployer.this.log.debug("Subject=" + subject);
                    }
                    return subject;
                }
                catch (Throwable t) {
                    AbstractResourceAdapterDeployer.this.log.subjectCreationError(t.getMessage(), t);
                    return null;
                }
            }
        });
    }

    protected BeanValidation getBeanValidation() {
        return new BeanValidation();
    }

    protected abstract CachedConnectionManager getCachedConnectionManager();

    private List<ConfigProperty> createManagementView(List<? extends org.jboss.jca.common.api.metadata.spec.ConfigProperty> cps) {
        ArrayList<ConfigProperty> result = new ArrayList<ConfigProperty>();
        if (cps != null) {
            for (org.jboss.jca.common.api.metadata.spec.ConfigProperty configProperty : cps) {
                Boolean confidential;
                ConfigProperty mgtCp = null;
                Boolean dynamic = configProperty.getConfigPropertySupportsDynamicUpdates();
                if (dynamic == null) {
                    dynamic = Boolean.FALSE;
                }
                if ((confidential = configProperty.getConfigPropertyConfidential()) == null) {
                    confidential = Boolean.FALSE;
                }
                mgtCp = new ConfigProperty(configProperty.getConfigPropertyName().getValue(), dynamic.booleanValue(), confidential.booleanValue());
                result.add(mgtCp);
            }
        }
        return result;
    }

    protected Callback createCallback(WorkManagerSecurity ws) {
        if (ws != null) {
            boolean mr = ws.isMappingRequired();
            String d = ws.getDomain();
            String dp = ws.getDefaultPrincipal();
            String[] dgs = ws.getDefaultGroups() != null ? ws.getDefaultGroups().toArray(new String[ws.getDefaultGroups().size()]) : null;
            Map ps = ws.getUserMappings();
            Map gs = ws.getGroupMappings();
            return new CallbackImpl(mr, d, dp, dgs, ps, gs);
        }
        return null;
    }

    private String stripPassword(String str) {
        if (str.indexOf("<password>") == -1) {
            return str;
        }
        Pattern pattern = Pattern.compile("<password>[^<]*</password>");
        String[] strs = pattern.split(str);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strs.length; ++i) {
            String s = strs[i];
            sb.append(s);
            if (i >= strs.length - 1) continue;
            sb.append("<password>****</password>");
        }
        return sb.toString();
    }

    protected void applyCapacity(org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition connectionDefinition, Pool pool, boolean isCRI) {
        org.jboss.jca.common.api.metadata.common.Pool cdp;
        if (connectionDefinition != null && connectionDefinition.getPool() != null && (cdp = connectionDefinition.getPool()).getCapacity() != null) {
            pool.setCapacity(CapacityFactory.create((Capacity)cdp.getCapacity(), (boolean)isCRI));
        }
    }

    protected boolean scanArchive(Connector cmd) {
        if (cmd == null) {
            return true;
        }
        return (cmd.getVersion() == Connector.Version.V_16 || cmd.getVersion() == Connector.Version.V_17) && !cmd.isMetadataComplete();
    }

    protected abstract File getReportDirectory();

    protected abstract void registerResourceAdapterToMDR(URL var1, File var2, Connector var3, Activation var4) throws AlreadyExistsException;

    protected abstract String registerResourceAdapterToResourceAdapterRepository(javax.resource.spi.ResourceAdapter var1);

    protected abstract void setRecoveryForResourceAdapterInResourceAdapterRepository(String var1, boolean var2);

    protected abstract TransactionManager getTransactionManager();

    protected abstract TransactionIntegration getTransactionIntegration();

    protected abstract PrintWriter getLogPrintWriter();

    protected abstract String[] bindConnectionFactory(URL var1, String var2, Object var3) throws Throwable;

    protected abstract String[] bindConnectionFactory(URL var1, String var2, Object var3, String var4) throws Throwable;

    protected abstract String[] bindAdminObject(URL var1, String var2, Object var3) throws Throwable;

    protected abstract String[] bindAdminObject(URL var1, String var2, Object var3, String var4) throws Throwable;

    protected abstract boolean checkConfigurationIsValid();

    protected abstract boolean checkActivation(Connector var1, Activation var2);

    protected abstract Object initAndInject(String var1, List<? extends org.jboss.jca.common.api.metadata.spec.ConfigProperty> var2, ClassLoader var3) throws DeployException;

    protected abstract DeployersLogger getLogger();
}

