/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.validation.ConstraintViolationException;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.groups.Default;
import org.jboss.jca.deployers.fungal.JCATraversableResolver;
import org.jboss.logging.Logger;

public class BeanValidation {
    private static Logger log = Logger.getLogger(BeanValidation.class);
    private static boolean trace = log.isTraceEnabled();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(Object object, List<Class> groupsClasses) throws ConstraintViolationException {
        if (object == null) {
            throw new IllegalArgumentException("Object is null");
        }
        InitialContext context = null;
        try {
            context = new InitialContext();
            ValidatorFactory vf = (ValidatorFactory)context.lookup("java:/ValidatorFactory");
            Validator v = vf.usingContext().traversableResolver((TraversableResolver)new JCATraversableResolver()).getValidator();
            Set errors = null;
            if (groupsClasses == null || groupsClasses.size() == 0) {
                if (trace) {
                    log.trace((Object)("Validating: " + object + " against groups " + Default.class.getName()));
                }
                errors = v.validate(object, new Class[]{Default.class});
            } else {
                Object[] vargs = groupsClasses.toArray(new Class[groupsClasses.size()]);
                if (trace) {
                    log.trace((Object)("Validating: " + object + " against groups " + Arrays.toString(vargs)));
                }
                errors = v.validate(object, (Class[])vargs);
            }
            if (errors != null && errors.size() > 0) {
                throw new ConstraintViolationException(errors);
            }
        }
        catch (NamingException ne) {
            log.error((Object)ne.getMessage(), (Throwable)ne);
        }
        finally {
            try {
                if (context != null) {
                    context.close();
                }
            }
            catch (NamingException ne) {}
        }
    }
}

