/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import com.github.fungal.api.Kernel;
import com.github.fungal.api.classloading.ClassLoaderFactory;
import com.github.fungal.api.classloading.KernelClassLoader;
import com.github.fungal.api.util.FileUtil;
import com.github.fungal.spi.deployers.DeployException;
import com.github.fungal.spi.deployers.DeployerPhases;
import com.github.fungal.spi.deployers.Deployment;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.resource.Referenceable;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.TransactionSupport;
import org.jboss.jca.common.api.metadata.common.CommonConnDef;
import org.jboss.jca.common.api.metadata.common.CommonIronJacamar;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.AdminObject;
import org.jboss.jca.common.api.metadata.ra.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.ra.MessageListener;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter1516;
import org.jboss.jca.common.api.metadata.ra.ra10.ResourceAdapter10;
import org.jboss.jca.common.metadata.merge.Merger;
import org.jboss.jca.core.connectionmanager.ConnectionManagerFactory;
import org.jboss.jca.core.connectionmanager.NoTxConnectionManager;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.api.PoolConfiguration;
import org.jboss.jca.core.connectionmanager.pool.api.PoolFactory;
import org.jboss.jca.core.connectionmanager.pool.api.PoolStrategy;
import org.jboss.jca.deployers.fungal.AbstractResourceAdapterDeployer;
import org.jboss.jca.deployers.fungal.BeanValidation;
import org.jboss.jca.deployers.fungal.RAActivatorDeployment;
import org.jboss.jca.deployers.fungal.SecurityActions;
import org.jboss.jca.validator.Failure;
import org.jboss.jca.validator.FailureHelper;
import org.jboss.jca.validator.Key;
import org.jboss.jca.validator.Validate;
import org.jboss.jca.validator.ValidateObject;
import org.jboss.jca.validator.Validator;
import org.jboss.jca.validator.ValidatorException;
import org.jboss.logging.Logger;

public final class RAActivator
extends AbstractResourceAdapterDeployer
implements DeployerPhases {
    private static Logger log = Logger.getLogger(RAActivator.class);
    private static boolean trace = log.isTraceEnabled();
    private Kernel kernel = null;
    private boolean enabled = true;
    private Set<String> excludeArchives = null;
    private List<Deployment> deployments = null;

    public Kernel getKernel() {
        return this.kernel;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public Set<String> getExcludeArchives() {
        return this.excludeArchives;
    }

    public void setExcludeArchives(Set<String> archives) {
        this.excludeArchives = archives;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public void preDeploy() throws Throwable {
    }

    public void postDeploy() throws Throwable {
        if (this.enabled) {
            Set rarDeployments = this.getConfiguration().getMetadataRepository().getResourceAdapters();
            for (URL deployment : rarDeployments) {
                Deployment raDeployment;
                Map jndiMappings;
                if (trace) {
                    log.trace((Object)("Processing: " + deployment.toExternalForm()));
                }
                boolean include = true;
                if (this.excludeArchives != null) {
                    for (String excludedArchive : this.excludeArchives) {
                        if (!deployment.toExternalForm().endsWith(excludedArchive)) continue;
                        include = false;
                    }
                }
                if (!include || (jndiMappings = this.getConfiguration().getMetadataRepository().getJndiMappings(deployment)) != null || (raDeployment = this.deploy(deployment, (ClassLoader)this.kernel.getKernelClassLoader())) == null) continue;
                if (this.deployments == null) {
                    this.deployments = new ArrayList<Deployment>(1);
                }
                this.deployments.add(raDeployment);
                this.kernel.getMainDeployer().registerDeployment(raDeployment);
            }
        }
    }

    public void preUndeploy() throws Throwable {
        if (this.deployments != null) {
            for (Deployment raDeployment : this.deployments) {
                try {
                    this.kernel.getMainDeployer().unregisterDeployment(raDeployment);
                }
                catch (Throwable t) {
                    log.warn((Object)("Error during undeployment of " + raDeployment.getURL()));
                }
            }
            this.deployments = null;
        }
    }

    public void postUndeploy() throws Throwable {
    }

    /*
     * WARNING - void declaration
     */
    private Deployment deploy(URL url, ClassLoader parent) throws DeployException {
        HashSet<Failure> failures = null;
        log.debug((Object)("Deploying: " + url.toExternalForm()));
        ClassLoader oldTCCL = SecurityActions.getThreadContextClassLoader();
        try {
            File f = new File(url.toURI());
            if (!f.exists()) {
                Deployment deployment = null;
                return deployment;
            }
            File root = null;
            File destination = null;
            if (f.isFile()) {
                FileUtil fileUtil = new FileUtil();
                destination = new File(SecurityActions.getSystemProperty("iron.jacamar.home"), "/tmp/");
                root = fileUtil.extract(f, destination);
            } else {
                root = f;
            }
            URL[] urls = this.getUrls(root);
            KernelClassLoader cl = null;
            cl = this.getConfiguration().getScopeDeployment() ? ClassLoaderFactory.create((int)1, (URL[])urls, (ClassLoader)parent) : ClassLoaderFactory.create((int)0, (URL[])urls, (ClassLoader)parent);
            SecurityActions.setThreadContextClassLoader((ClassLoader)cl);
            Connector cmd = this.getConfiguration().getMetadataRepository().getResourceAdapter(url);
            IronJacamar ijmd = this.getConfiguration().getMetadataRepository().getIronJacamar(url);
            cmd = new Merger().mergeConnectorWithCommonIronJacamar((CommonIronJacamar)ijmd, cmd);
            ResourceAdapter resourceAdapter = null;
            ArrayList<Validate> archiveValidationObjects = new ArrayList<Validate>();
            List<Failure> partialFailures = null;
            ArrayList<Object> beanValidationObjects = new ArrayList<Object>();
            String deploymentName = f.getName().substring(0, f.getName().indexOf(".rar"));
            Object[] cfs = null;
            String[] jndis = null;
            if (cmd != null) {
                List aoMetas;
                List mlMetas;
                ResourceAdapter1516 ra1516;
                if (cmd.getVersion() != Connector.Version.V_10 && (ra1516 = (ResourceAdapter1516)cmd.getResourceadapter()) != null && ra1516.getResourceadapterClass() != null) {
                    resourceAdapter = (ResourceAdapter)this.initAndInject(ra1516.getResourceadapterClass(), ra1516.getConfigProperties(), (ClassLoader)cl);
                    if (trace) {
                        log.trace((Object)("ResourceAdapter: " + resourceAdapter.getClass().getName()));
                        log.trace((Object)("ResourceAdapter defined in classloader: " + resourceAdapter.getClass().getClassLoader()));
                    }
                    archiveValidationObjects.add((Validate)new ValidateObject(Key.RESOURCE_ADAPTER, (Object)resourceAdapter, ra1516.getConfigProperties()));
                    beanValidationObjects.add(resourceAdapter);
                }
                if (cmd.getVersion() == Connector.Version.V_10) {
                    CommonConnDef ijCD = null;
                    if (ijmd != null) {
                        ijCD = this.findConnectionDefinition(((ResourceAdapter10)cmd.getResourceadapter()).getManagedConnectionFactoryClass().getValue(), ijmd.getConnectionDefinitions());
                    }
                    if (ijmd == null || ijCD == null || ijCD.isEnabled().booleanValue()) {
                        CommonXaPool ijXaPool;
                        ManagedConnectionFactory mcf = (ManagedConnectionFactory)this.initAndInject(((ResourceAdapter10)cmd.getResourceadapter()).getManagedConnectionFactoryClass().getValue(), ((ResourceAdapter10)cmd.getResourceadapter()).getConfigProperties(), (ClassLoader)cl);
                        if (trace) {
                            log.trace((Object)("ManagedConnectionFactory: " + mcf.getClass().getName()));
                            log.trace((Object)("ManagedConnectionFactory defined in classloader: " + mcf.getClass().getClassLoader()));
                        }
                        mcf.setLogWriter(new PrintWriter(this.getConfiguration().getPrintStream()));
                        archiveValidationObjects.add((Validate)new ValidateObject(Key.MANAGED_CONNECTION_FACTORY, (Object)mcf, ((ResourceAdapter10)cmd.getResourceadapter()).getConfigProperties()));
                        beanValidationObjects.add(mcf);
                        this.associateResourceAdapter(resourceAdapter, mcf);
                        PoolConfiguration pc = this.createPoolConfiguration(ijCD != null ? ijCD.getPool() : null, ijCD != null ? ijCD.getTimeOut() : null, ijCD != null ? ijCD.getValidation() : null);
                        PoolFactory poolFactory = new PoolFactory();
                        Boolean noTxSeparatePool = Boolean.FALSE;
                        if (ijCD != null && ijCD.getPool() != null && ijCD.isXa().booleanValue() && (ijXaPool = (CommonXaPool)ijCD.getPool()) != null) {
                            noTxSeparatePool = ijXaPool.isNoTxSeparatePool();
                        }
                        Pool pool = poolFactory.create(PoolStrategy.ONE_POOL, mcf, pc, noTxSeparatePool.booleanValue());
                        ConnectionManagerFactory cmf = new ConnectionManagerFactory();
                        NoTxConnectionManager cm = null;
                        TransactionSupport.TransactionSupportLevel tsl = TransactionSupport.TransactionSupportLevel.NoTransaction;
                        TransactionSupportEnum tsmd = TransactionSupportEnum.NoTransaction;
                        tsmd = ((ResourceAdapter10)cmd.getResourceadapter()).getTransactionSupport();
                        if (tsmd == TransactionSupportEnum.NoTransaction) {
                            tsl = TransactionSupport.TransactionSupportLevel.NoTransaction;
                        } else if (tsmd == TransactionSupportEnum.LocalTransaction) {
                            tsl = TransactionSupport.TransactionSupportLevel.LocalTransaction;
                        } else if (tsmd == TransactionSupportEnum.XATransaction) {
                            tsl = TransactionSupport.TransactionSupportLevel.XATransaction;
                        }
                        if (mcf instanceof TransactionSupport) {
                            tsl = ((TransactionSupport)mcf).getTransactionSupport();
                        }
                        Integer allocationRetry = null;
                        Long allocationRetryWaitMillis = null;
                        if (ijCD != null && ijCD.getTimeOut() != null) {
                            allocationRetry = ijCD.getTimeOut().getAllocationRetry();
                            allocationRetryWaitMillis = ijCD.getTimeOut().getAllocationRetryWaitMillis();
                        }
                        if (tsl == TransactionSupport.TransactionSupportLevel.NoTransaction) {
                            cm = cmf.createNonTransactional(tsl, pool, allocationRetry, allocationRetryWaitMillis);
                        } else {
                            CommonXaPool ijXaPool2;
                            Boolean interleaving = null;
                            Integer xaResourceTimeout = null;
                            Boolean isSameRMOverride = null;
                            Boolean wrapXAResource = null;
                            Boolean padXid = null;
                            if (ijCD != null && ijCD.getPool() != null && ijCD.isXa().booleanValue() && (ijXaPool2 = (CommonXaPool)ijCD.getPool()) != null) {
                                interleaving = ijXaPool2.isInterleaving();
                                isSameRMOverride = ijXaPool2.isSameRmOverride();
                                wrapXAResource = ijXaPool2.isWrapXaDataSource();
                                padXid = ijXaPool2.isPadXid();
                            }
                            cm = cmf.createTransactional(tsl, pool, allocationRetry, allocationRetryWaitMillis, this.getConfiguration().getTransactionManager(), interleaving, xaResourceTimeout, isSameRMOverride, wrapXAResource, padXid);
                        }
                        Object cf = mcf.createConnectionFactory((ConnectionManager)cm);
                        if (cf == null) {
                            log.error((Object)"ConnectionFactory is null");
                        } else if (trace) {
                            log.trace((Object)("ConnectionFactory: " + cf.getClass().getName()));
                            log.trace((Object)("ConnectionFactory defined in classloader: " + cf.getClass().getClassLoader()));
                        }
                        archiveValidationObjects.add((Validate)new ValidateObject(Key.CONNECTION_FACTORY, cf));
                        if (cf != null && cf instanceof Serializable && cf instanceof Referenceable) {
                            String[] jndiNames = this.bindConnectionFactory(url, deploymentName, cf);
                            cfs = new Object[]{cf};
                            jndis = new String[]{jndiNames[0]};
                            cm.setJndiName(jndiNames[0]);
                        }
                    }
                } else {
                    List cdMetas;
                    ResourceAdapter1516 ra = (ResourceAdapter1516)cmd.getResourceadapter();
                    if (ra != null && ra.getOutboundResourceadapter() != null && ra.getOutboundResourceadapter().getConnectionDefinitions() != null && (cdMetas = ra.getOutboundResourceadapter().getConnectionDefinitions()).size() > 0 && cdMetas.size() == 1) {
                        void var22_28;
                        ConnectionDefinition cdMeta = (ConnectionDefinition)cdMetas.get(0);
                        Object var22_26 = null;
                        if (ijmd != null) {
                            CommonConnDef commonConnDef = this.findConnectionDefinition(cdMeta.getManagedConnectionFactoryClass().getValue(), ijmd.getConnectionDefinitions());
                        }
                        if (ijmd == null || var22_28 == null || var22_28.isEnabled().booleanValue()) {
                            CommonXaPool ijXaPool;
                            ManagedConnectionFactory mcf = (ManagedConnectionFactory)this.initAndInject(cdMeta.getManagedConnectionFactoryClass().getValue(), cdMeta.getConfigProperties(), (ClassLoader)cl);
                            if (trace) {
                                log.trace((Object)("ManagedConnectionFactory: " + mcf.getClass().getName()));
                                log.trace((Object)("ManagedConnectionFactory defined in classloader: " + mcf.getClass().getClassLoader()));
                            }
                            mcf.setLogWriter(new PrintWriter(this.getConfiguration().getPrintStream()));
                            archiveValidationObjects.add((Validate)new ValidateObject(Key.MANAGED_CONNECTION_FACTORY, (Object)mcf, cdMeta.getConfigProperties()));
                            beanValidationObjects.add(mcf);
                            this.associateResourceAdapter(resourceAdapter, mcf);
                            PoolConfiguration pc = this.createPoolConfiguration(var22_28 != null ? var22_28.getPool() : null, var22_28 != null ? var22_28.getTimeOut() : null, var22_28 != null ? var22_28.getValidation() : null);
                            PoolFactory pf = new PoolFactory();
                            Boolean noTxSeparatePool = Boolean.FALSE;
                            if (var22_28 != null && var22_28.getPool() != null && var22_28.isXa().booleanValue() && (ijXaPool = (CommonXaPool)var22_28.getPool()) != null) {
                                noTxSeparatePool = ijXaPool.isNoTxSeparatePool();
                            }
                            Pool pool = pf.create(PoolStrategy.ONE_POOL, mcf, pc, noTxSeparatePool.booleanValue());
                            ConnectionManagerFactory cmf = new ConnectionManagerFactory();
                            NoTxConnectionManager cm = null;
                            TransactionSupport.TransactionSupportLevel tsl = TransactionSupport.TransactionSupportLevel.NoTransaction;
                            TransactionSupportEnum tsmd = TransactionSupportEnum.NoTransaction;
                            tsmd = ra.getOutboundResourceadapter().getTransactionSupport();
                            if (tsmd == TransactionSupportEnum.NoTransaction) {
                                tsl = TransactionSupport.TransactionSupportLevel.NoTransaction;
                            } else if (tsmd == TransactionSupportEnum.LocalTransaction) {
                                tsl = TransactionSupport.TransactionSupportLevel.LocalTransaction;
                            } else if (tsmd == TransactionSupportEnum.XATransaction) {
                                tsl = TransactionSupport.TransactionSupportLevel.XATransaction;
                            }
                            if (mcf instanceof TransactionSupport) {
                                tsl = ((TransactionSupport)mcf).getTransactionSupport();
                            }
                            Integer allocationRetry = null;
                            Long allocationRetryWaitMillis = null;
                            if (var22_28 != null && var22_28.getTimeOut() != null) {
                                allocationRetry = var22_28.getTimeOut().getAllocationRetry();
                                allocationRetryWaitMillis = var22_28.getTimeOut().getAllocationRetryWaitMillis();
                            }
                            if (tsl == TransactionSupport.TransactionSupportLevel.NoTransaction) {
                                cm = cmf.createNonTransactional(tsl, pool, allocationRetry, allocationRetryWaitMillis);
                            } else {
                                Boolean interleaving = null;
                                Integer xaResourceTimeout = null;
                                Boolean isSameRMOverride = null;
                                Boolean wrapXAResource = null;
                                Boolean padXid = null;
                                if (var22_28 != null && var22_28.isXa().booleanValue()) {
                                    CommonXaPool ijXaPool3 = (CommonXaPool)var22_28.getPool();
                                    interleaving = ijXaPool3.isInterleaving();
                                    isSameRMOverride = ijXaPool3.isSameRmOverride();
                                    wrapXAResource = ijXaPool3.isWrapXaDataSource();
                                    padXid = ijXaPool3.isPadXid();
                                }
                                cm = cmf.createTransactional(tsl, pool, allocationRetry, allocationRetryWaitMillis, this.getConfiguration().getTransactionManager(), interleaving, xaResourceTimeout, isSameRMOverride, wrapXAResource, padXid);
                            }
                            Object cf = mcf.createConnectionFactory((ConnectionManager)cm);
                            if (cf == null) {
                                log.error((Object)"ConnectionFactory is null");
                            } else if (trace) {
                                log.trace((Object)("ConnectionFactory: " + cf.getClass().getName()));
                                log.trace((Object)("ConnectionFactory defined in classloader: " + cf.getClass().getClassLoader()));
                            }
                            archiveValidationObjects.add((Validate)new ValidateObject(Key.CONNECTION_FACTORY, cf));
                            if (cf != null && cf instanceof Serializable && cf instanceof Referenceable) {
                                deploymentName = f.getName().substring(0, f.getName().indexOf(".rar"));
                                String[] jndiNames = this.bindConnectionFactory(url, deploymentName, cf);
                                cfs = new Object[]{cf};
                                jndis = new String[]{jndiNames[0]};
                                cm.setJndiName(jndiNames[0]);
                            }
                        } else {
                            log.warn((Object)("There are multiple connection factories for: " + f.getName()));
                            log.warn((Object)"Use an ironjacamar.xml or a -ra.xml to activate the deployment");
                        }
                    }
                }
                if (cmd.getVersion() != Connector.Version.V_10 && (ra1516 = (ResourceAdapter1516)cmd.getResourceadapter()) != null && ra1516.getInboundResourceadapter() != null && ra1516.getInboundResourceadapter().getMessageadapter() != null && ra1516.getInboundResourceadapter().getMessageadapter().getMessagelisteners() != null && (mlMetas = ra1516.getInboundResourceadapter().getMessageadapter().getMessagelisteners()).size() > 0) {
                    for (MessageListener messageListener : mlMetas) {
                        if (messageListener.getActivationspec() == null || messageListener.getActivationspec().getActivationspecClass().getValue() == null) continue;
                        List cpm = messageListener.getActivationspec().getConfigProperties();
                        Object o = this.initAndInject(messageListener.getActivationspec().getActivationspecClass().getValue(), cpm, (ClassLoader)cl);
                        if (trace) {
                            log.trace((Object)("ActivationSpec: " + o.getClass().getName()));
                            log.trace((Object)("ActivationSpec defined in classloader: " + o.getClass().getClassLoader()));
                        }
                        archiveValidationObjects.add((Validate)new ValidateObject(Key.ACTIVATION_SPEC, o, cpm));
                        beanValidationObjects.add(o);
                        this.associateResourceAdapter(resourceAdapter, o);
                    }
                }
                if (cmd.getVersion() != Connector.Version.V_10 && (ra1516 = (ResourceAdapter1516)cmd.getResourceadapter()) != null && ra1516.getAdminObjects() != null && (aoMetas = ((ResourceAdapter1516)cmd.getResourceadapter()).getAdminObjects()).size() > 0) {
                    for (AdminObject adminObject : aoMetas) {
                        if (adminObject.getAdminobjectClass() == null || adminObject.getAdminobjectClass().getValue() == null) continue;
                        Object o = this.initAndInject(adminObject.getAdminobjectClass().getValue(), adminObject.getConfigProperties(), (ClassLoader)cl);
                        if (trace) {
                            log.trace((Object)("AdminObject: " + o.getClass().getName()));
                            log.trace((Object)("AdminObject defined in classloader: " + o.getClass().getClassLoader()));
                        }
                        archiveValidationObjects.add((Validate)new ValidateObject(Key.ADMIN_OBJECT, o, adminObject.getConfigProperties()));
                        beanValidationObjects.add(o);
                    }
                }
            }
            if ((partialFailures = this.validateArchive(url, archiveValidationObjects)) != null) {
                if (failures == null) {
                    failures = new HashSet<Failure>();
                }
                failures.addAll(partialFailures);
            }
            if (this.getConfiguration().getArchiveValidationFailOnWarn() && this.hasFailuresLevel(failures, 0) || this.getConfiguration().getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1)) {
                throw new ValidatorException(this.printFailuresLog(url.getPath(), new Validator(), failures, null, new FailureHelper[0]), failures);
            }
            this.printFailuresLog(url.getPath(), new Validator(), failures, null, new FailureHelper[0]);
            if (this.getConfiguration().getBeanValidation()) {
                ArrayList<Class> groupsClasses = null;
                if (ijmd != null && ijmd.getBeanValidationGroups() != null && ijmd.getBeanValidationGroups().size() > 0) {
                    groupsClasses = new ArrayList<Class>();
                    for (String group : ijmd.getBeanValidationGroups()) {
                        groupsClasses.add(Class.forName(group, true, (ClassLoader)cl));
                    }
                }
                if (beanValidationObjects.size() > 0) {
                    BeanValidation beanValidator = new BeanValidation();
                    for (Object e : beanValidationObjects) {
                        beanValidator.validate(e, groupsClasses);
                    }
                }
            }
            if (resourceAdapter != null) {
                String bootstrapIdentifier = null;
                if (ijmd != null) {
                    bootstrapIdentifier = ijmd.getBootstrapContext();
                }
                this.startContext(resourceAdapter, bootstrapIdentifier);
            }
            log.info((Object)("Deployed: " + url.toExternalForm()));
            RAActivatorDeployment rAActivatorDeployment = new RAActivatorDeployment(url, deploymentName, resourceAdapter, this.getConfiguration().getJndiStrategy(), this.getConfiguration().getMetadataRepository(), cfs, jndis, (ClassLoader)cl, log);
            return rAActivatorDeployment;
        }
        catch (DeployException de) {
            throw de;
        }
        catch (Throwable t) {
            if (this.getConfiguration().getArchiveValidationFailOnWarn() && this.hasFailuresLevel(failures, 0) || this.getConfiguration().getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1)) {
                throw new DeployException("Deployment " + url.toExternalForm() + " failed", (Throwable)new ValidatorException(this.printFailuresLog(url.getPath(), new Validator(), failures, null, new FailureHelper[0]), failures));
            }
            this.printFailuresLog(url.getPath(), new Validator(), failures, null, new FailureHelper[0]);
            throw new DeployException("Deployment " + url.toExternalForm() + " failed", t);
        }
        finally {
            SecurityActions.setThreadContextClassLoader(oldTCCL);
        }
    }

    @Override
    public void start() {
        super.start();
        if (this.kernel == null) {
            throw new IllegalStateException("Kernel not defined");
        }
    }
}

