/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import com.github.fungal.api.Kernel;
import com.github.fungal.api.classloading.ClassLoaderFactory;
import com.github.fungal.api.classloading.KernelClassLoader;
import com.github.fungal.spi.deployers.DeployException;
import com.github.fungal.spi.deployers.Deployer;
import com.github.fungal.spi.deployers.DeployerOrder;
import com.github.fungal.spi.deployers.DeployerPhases;
import com.github.fungal.spi.deployers.Deployment;
import com.github.fungal.spi.deployers.MultiStageDeployer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.resource.Referenceable;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.TransactionSupport;
import org.jboss.jca.common.api.metadata.common.CommonConnDef;
import org.jboss.jca.common.api.metadata.common.CommonIronJacamar;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.AdminObject;
import org.jboss.jca.common.api.metadata.ra.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.ra.MessageListener;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter1516;
import org.jboss.jca.common.api.metadata.ra.ra10.ResourceAdapter10;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapters;
import org.jboss.jca.common.metadata.merge.Merger;
import org.jboss.jca.common.metadata.resourceadapter.ResourceAdapterParser;
import org.jboss.jca.core.connectionmanager.ConnectionManagerFactory;
import org.jboss.jca.core.connectionmanager.NoTxConnectionManager;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.api.PoolConfiguration;
import org.jboss.jca.core.connectionmanager.pool.api.PoolFactory;
import org.jboss.jca.core.connectionmanager.pool.api.PoolStrategy;
import org.jboss.jca.deployers.fungal.AbstractResourceAdapterDeployer;
import org.jboss.jca.deployers.fungal.BeanValidation;
import org.jboss.jca.deployers.fungal.RaXmlDeployment;
import org.jboss.jca.deployers.fungal.SecurityActions;
import org.jboss.jca.validator.Failure;
import org.jboss.jca.validator.FailureHelper;
import org.jboss.jca.validator.Key;
import org.jboss.jca.validator.Validate;
import org.jboss.jca.validator.ValidateObject;
import org.jboss.jca.validator.Validator;
import org.jboss.jca.validator.ValidatorException;
import org.jboss.logging.Logger;

public final class RaXmlDeployer
extends AbstractResourceAdapterDeployer
implements Deployer,
MultiStageDeployer,
DeployerOrder,
DeployerPhases {
    private static Logger log = Logger.getLogger(RaXmlDeployer.class);
    private static boolean trace = log.isTraceEnabled();
    private Kernel kernel;
    private List<Deployment> deployments;

    public int getOrder() {
        return 0;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public void preDeploy() throws Throwable {
    }

    public void postDeploy() throws Throwable {
    }

    public void preUndeploy() throws Throwable {
        if (this.deployments != null) {
            for (Deployment raDeployment : this.deployments) {
                try {
                    this.kernel.getMainDeployer().unregisterDeployment(raDeployment);
                }
                catch (Throwable t) {
                    log.warn((Object)("Error during undeployment of " + raDeployment.getURL()));
                }
            }
            this.deployments = null;
        }
    }

    public void postUndeploy() throws Throwable {
    }

    public synchronized Deployment deploy(URL url, ClassLoader parent) throws DeployException {
        if (url == null || !url.toExternalForm().endsWith("-ra.xml")) {
            return null;
        }
        log.debug((Object)("Deploying: " + url.toExternalForm()));
        ClassLoader oldTCCL = SecurityActions.getThreadContextClassLoader();
        InputStream is = null;
        try {
            File f = new File(url.toURI());
            if (!f.exists()) {
                throw new IOException("Archive " + url.toExternalForm() + " doesnt exists");
            }
            ResourceAdapterParser parser = new ResourceAdapterParser();
            is = new FileInputStream(f);
            ResourceAdapters raXmlDeployment = parser.parse(is);
            int size = raXmlDeployment.getResourceAdapters().size();
            if (size == 1) {
                Deployment deployment = this.doDeploy(url, (org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter)raXmlDeployment.getResourceAdapters().get(0), parent);
                return deployment;
            }
            this.deployments = new ArrayList<Deployment>(size);
            for (org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter raxml : raXmlDeployment.getResourceAdapters()) {
                Deployment raDeployment = this.doDeploy(url, raxml, parent);
                if (raDeployment == null) continue;
                this.deployments.add(raDeployment);
                this.kernel.getMainDeployer().registerDeployment(raDeployment);
            }
            Deployment deployment = null;
            return deployment;
        }
        catch (DeployException de) {
            throw de;
        }
        catch (Throwable t) {
            throw new DeployException("Exception during deployment of " + url.toExternalForm(), t);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
            SecurityActions.setThreadContextClassLoader(oldTCCL);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Deployment doDeploy(URL url, org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter raxml, ClassLoader parent) throws DeployException {
        HashSet<Failure> failures = null;
        ClassLoader oldTCCL = SecurityActions.getThreadContextClassLoader();
        try {
            String[] jndiNames;
            Object[] cfs;
            String deploymentName;
            ArrayList<Object> beanValidationObjects;
            List<Failure> partialFailures;
            ArrayList<Validate> archiveValidationObjects;
            ResourceAdapter resourceAdapter;
            KernelClassLoader cl;
            IronJacamar ijmd;
            URL deployment;
            block90: {
                List aoMetas;
                List mlMetas;
                ResourceAdapter1516 ra1516;
                Connector cmd;
                block92: {
                    List cdMetas;
                    block91: {
                        void var24_36;
                        CommonXaPool ijXaPool;
                        String archive = raxml.getArchive();
                        deployment = null;
                        Set deployments = this.getConfiguration().getMetadataRepository().getResourceAdapters();
                        for (URL u : deployments) {
                            if (!u.toExternalForm().endsWith(archive)) continue;
                            deployment = u;
                        }
                        if (deployment == null) {
                            throw new DeployException("Archive " + archive + " couldn't be resolved in " + url.toExternalForm());
                        }
                        cmd = this.getConfiguration().getMetadataRepository().getResourceAdapter(deployment);
                        ijmd = this.getConfiguration().getMetadataRepository().getIronJacamar(deployment);
                        File root = this.getConfiguration().getMetadataRepository().getRoot(deployment);
                        cmd = new Merger().mergeConnectorWithCommonIronJacamar((CommonIronJacamar)raxml, cmd);
                        URL[] urls = this.getUrls(root);
                        cl = null;
                        cl = this.getConfiguration().getScopeDeployment() ? ClassLoaderFactory.create((int)1, (URL[])urls, (ClassLoader)parent) : ClassLoaderFactory.create((int)0, (URL[])urls, (ClassLoader)parent);
                        SecurityActions.setThreadContextClassLoader((ClassLoader)cl);
                        resourceAdapter = null;
                        archiveValidationObjects = new ArrayList<Validate>();
                        partialFailures = null;
                        beanValidationObjects = new ArrayList<Object>();
                        deploymentName = archive.substring(0, archive.indexOf(".rar"));
                        cfs = null;
                        jndiNames = null;
                        if (cmd == null) break block90;
                        if (cmd.getVersion() != Connector.Version.V_10 && (ra1516 = (ResourceAdapter1516)cmd.getResourceadapter()) != null && ra1516.getResourceadapterClass() != null) {
                            resourceAdapter = (ResourceAdapter)this.initAndInject(ra1516.getResourceadapterClass(), ra1516.getConfigProperties(), (ClassLoader)cl);
                            if (trace) {
                                log.trace((Object)("ResourceAdapter: " + resourceAdapter.getClass().getName()));
                                log.trace((Object)("ResourceAdapter defined in classloader: " + resourceAdapter.getClass().getClassLoader()));
                            }
                            archiveValidationObjects.add((Validate)new ValidateObject(Key.RESOURCE_ADAPTER, (Object)resourceAdapter, ra1516.getConfigProperties()));
                            beanValidationObjects.add(resourceAdapter);
                        }
                        if (cmd.getVersion() != Connector.Version.V_10) break block91;
                        CommonConnDef cdRaXml = this.findConnectionDefinition(((ResourceAdapter10)cmd.getResourceadapter()).getManagedConnectionFactoryClass().getValue(), raxml.getConnectionDefinitions());
                        if (cdRaXml == null || !cdRaXml.isEnabled().booleanValue()) break block92;
                        ManagedConnectionFactory mcf = (ManagedConnectionFactory)this.initAndInject(((ResourceAdapter10)cmd.getResourceadapter()).getManagedConnectionFactoryClass().getValue(), ((ResourceAdapter10)cmd.getResourceadapter()).getConfigProperties(), (ClassLoader)cl);
                        if (trace) {
                            log.trace((Object)("ManagedConnectionFactory: " + mcf.getClass().getName()));
                            log.trace((Object)("ManagedConnectionFactory defined in classloader: " + mcf.getClass().getClassLoader()));
                        }
                        CommonConnDef ijCD = null;
                        if (ijmd != null) {
                            ijCD = this.findConnectionDefinition(mcf.getClass().getName(), ijmd.getConnectionDefinitions());
                        }
                        mcf.setLogWriter(new PrintWriter(this.getConfiguration().getPrintStream()));
                        archiveValidationObjects.add((Validate)new ValidateObject(Key.MANAGED_CONNECTION_FACTORY, (Object)mcf, ((ResourceAdapter10)cmd.getResourceadapter()).getConfigProperties()));
                        beanValidationObjects.add(mcf);
                        this.associateResourceAdapter(resourceAdapter, mcf);
                        Object var24_32 = null;
                        if (cdRaXml.getPool() != null || cdRaXml.getPool() != null || cdRaXml.getPool() != null) {
                            PoolConfiguration poolConfiguration = this.createPoolConfiguration(cdRaXml.getPool(), cdRaXml.getTimeOut(), cdRaXml.getValidation());
                        } else if (ijCD != null) {
                            PoolConfiguration poolConfiguration = this.createPoolConfiguration(ijCD.getPool(), ijCD.getTimeOut(), ijCD.getValidation());
                        } else {
                            PoolConfiguration poolConfiguration = this.createPoolConfiguration(null, null, null);
                        }
                        PoolFactory pf = new PoolFactory();
                        Boolean noTxSeparatePool = Boolean.FALSE;
                        if (cdRaXml.getPool() != null && cdRaXml.isXa().booleanValue()) {
                            ijXaPool = (CommonXaPool)cdRaXml.getPool();
                            if (ijXaPool != null) {
                                noTxSeparatePool = ijXaPool.isNoTxSeparatePool();
                            }
                        } else if (ijCD != null && ijCD.getPool() != null && ijCD.isXa().booleanValue() && (ijXaPool = (CommonXaPool)ijCD.getPool()) != null) {
                            noTxSeparatePool = ijXaPool.isNoTxSeparatePool();
                        }
                        Pool pool = pf.create(PoolStrategy.ONE_POOL, mcf, (PoolConfiguration)var24_36, noTxSeparatePool.booleanValue());
                        ConnectionManagerFactory cmf = new ConnectionManagerFactory();
                        NoTxConnectionManager cm = null;
                        TransactionSupport.TransactionSupportLevel tsl = TransactionSupport.TransactionSupportLevel.NoTransaction;
                        TransactionSupportEnum tsmd = TransactionSupportEnum.NoTransaction;
                        tsmd = raxml.getTransactionSupport() != null ? raxml.getTransactionSupport() : (ijmd != null && ijmd.getTransactionSupport() != null ? ijmd.getTransactionSupport() : ((ResourceAdapter10)cmd.getResourceadapter()).getTransactionSupport());
                        if (tsmd == TransactionSupportEnum.NoTransaction) {
                            tsl = TransactionSupport.TransactionSupportLevel.NoTransaction;
                        } else if (tsmd == TransactionSupportEnum.LocalTransaction) {
                            tsl = TransactionSupport.TransactionSupportLevel.LocalTransaction;
                        } else if (tsmd == TransactionSupportEnum.XATransaction) {
                            tsl = TransactionSupport.TransactionSupportLevel.XATransaction;
                        }
                        if (mcf instanceof TransactionSupport) {
                            tsl = ((TransactionSupport)mcf).getTransactionSupport();
                        }
                        Integer allocationRetry = null;
                        Long allocationRetryWaitMillis = null;
                        if (cdRaXml.getTimeOut() != null) {
                            allocationRetry = cdRaXml.getTimeOut().getAllocationRetry();
                            allocationRetryWaitMillis = cdRaXml.getTimeOut().getAllocationRetryWaitMillis();
                        }
                        if (ijCD != null && ijCD.getTimeOut() != null) {
                            if (allocationRetry == null) {
                                allocationRetry = ijCD.getTimeOut().getAllocationRetry();
                            }
                            if (allocationRetryWaitMillis == null) {
                                allocationRetryWaitMillis = ijCD.getTimeOut().getAllocationRetryWaitMillis();
                            }
                        }
                        if (tsl == TransactionSupport.TransactionSupportLevel.NoTransaction) {
                            cm = cmf.createNonTransactional(tsl, pool, allocationRetry, allocationRetryWaitMillis);
                        } else {
                            CommonXaPool ijXaPool2;
                            Boolean interleaving = null;
                            Integer xaResourceTimeout = null;
                            Boolean isSameRMOverride = null;
                            Boolean wrapXAResource = null;
                            Boolean padXid = null;
                            if (cdRaXml.isXa().booleanValue()) {
                                CommonXaPool ijXaPool22 = (CommonXaPool)cdRaXml.getPool();
                                interleaving = ijXaPool22.isInterleaving();
                                isSameRMOverride = ijXaPool22.isSameRmOverride();
                                wrapXAResource = ijXaPool22.isWrapXaDataSource();
                                padXid = ijXaPool22.isPadXid();
                            }
                            if (ijCD != null && ijCD.getPool() != null && ijCD.isXa().booleanValue() && (ijXaPool2 = (CommonXaPool)ijCD.getPool()) != null) {
                                if (interleaving == null) {
                                    interleaving = ijXaPool2.isInterleaving();
                                }
                                if (isSameRMOverride == null) {
                                    isSameRMOverride = ijXaPool2.isSameRmOverride();
                                }
                                if (wrapXAResource == null) {
                                    wrapXAResource = ijXaPool2.isWrapXaDataSource();
                                }
                                if (padXid == null) {
                                    padXid = ijXaPool2.isPadXid();
                                }
                            }
                            cm = cmf.createTransactional(tsl, pool, allocationRetry, allocationRetryWaitMillis, this.getConfiguration().getTransactionManager(), interleaving, xaResourceTimeout, isSameRMOverride, wrapXAResource, padXid);
                        }
                        Object cf = mcf.createConnectionFactory((ConnectionManager)cm);
                        if (cf == null) {
                            log.error((Object)"ConnectionFactory is null");
                        } else if (trace) {
                            log.trace((Object)("ConnectionFactory: " + cf.getClass().getName()));
                            log.trace((Object)("ConnectionFactory defined in classloader: " + cf.getClass().getClassLoader()));
                        }
                        archiveValidationObjects.add((Validate)new ValidateObject(Key.CONNECTION_FACTORY, cf));
                        if (cf == null || !(cf instanceof Serializable) || !(cf instanceof Referenceable)) break block92;
                        CommonConnDef cd = this.findConnectionDefinition(mcf.getClass().getName(), raxml.getConnectionDefinitions());
                        String jndiName = cd.getJndiName();
                        this.bindConnectionFactory(deployment, deploymentName, cf, jndiName);
                        cfs = new Object[]{cf};
                        jndiNames = new String[]{jndiName};
                        cm.setJndiName(jndiName);
                        break block92;
                    }
                    ResourceAdapter1516 ra = (ResourceAdapter1516)cmd.getResourceadapter();
                    if (ra != null && ra.getOutboundResourceadapter() != null && ra.getOutboundResourceadapter().getConnectionDefinitions() != null && (cdMetas = ra.getOutboundResourceadapter().getConnectionDefinitions()).size() > 0) {
                        cfs = new Object[cdMetas.size()];
                        jndiNames = new String[cdMetas.size()];
                        for (int cdIndex = 0; cdIndex < cdMetas.size(); ++cdIndex) {
                            CommonXaPool ijXaPool;
                            ConnectionDefinition connectionDefinition = (ConnectionDefinition)cdMetas.get(cdIndex);
                            CommonConnDef cdRaXml = this.findConnectionDefinition(connectionDefinition.getManagedConnectionFactoryClass().getValue(), raxml.getConnectionDefinitions());
                            if (cdRaXml == null || !cdRaXml.isEnabled().booleanValue()) continue;
                            ManagedConnectionFactory mcf = (ManagedConnectionFactory)this.initAndInject(connectionDefinition.getManagedConnectionFactoryClass().getValue(), connectionDefinition.getConfigProperties(), (ClassLoader)cl);
                            if (trace) {
                                log.trace((Object)("ManagedConnectionFactory: " + mcf.getClass().getName()));
                                log.trace((Object)("ManagedConnectionFactory defined in classloader: " + mcf.getClass().getClassLoader()));
                            }
                            CommonConnDef ijCD = null;
                            if (ijmd != null) {
                                ijCD = this.findConnectionDefinition(mcf.getClass().getName(), ijmd.getConnectionDefinitions());
                            }
                            mcf.setLogWriter(new PrintWriter(this.getConfiguration().getPrintStream()));
                            archiveValidationObjects.add((Validate)new ValidateObject(Key.MANAGED_CONNECTION_FACTORY, (Object)mcf, connectionDefinition.getConfigProperties()));
                            beanValidationObjects.add(mcf);
                            this.associateResourceAdapter(resourceAdapter, mcf);
                            PoolConfiguration pc = null;
                            pc = cdRaXml.getPool() != null || cdRaXml.getPool() != null || cdRaXml.getPool() != null ? this.createPoolConfiguration(cdRaXml.getPool(), cdRaXml.getTimeOut(), cdRaXml.getValidation()) : (ijCD != null ? this.createPoolConfiguration(ijCD.getPool(), ijCD.getTimeOut(), ijCD.getValidation()) : this.createPoolConfiguration(null, null, null));
                            PoolFactory pf = new PoolFactory();
                            Boolean noTxSeparatePool = Boolean.FALSE;
                            if (cdRaXml.getPool() != null && cdRaXml.isXa().booleanValue()) {
                                ijXaPool = (CommonXaPool)cdRaXml.getPool();
                                if (ijXaPool != null) {
                                    noTxSeparatePool = ijXaPool.isNoTxSeparatePool();
                                }
                            } else if (ijCD != null && ijCD.getPool() != null && ijCD.isXa().booleanValue() && (ijXaPool = (CommonXaPool)ijCD.getPool()) != null) {
                                noTxSeparatePool = ijXaPool.isNoTxSeparatePool();
                            }
                            Pool pool = pf.create(PoolStrategy.ONE_POOL, mcf, pc, noTxSeparatePool.booleanValue());
                            ConnectionManagerFactory cmf = new ConnectionManagerFactory();
                            NoTxConnectionManager cm = null;
                            TransactionSupport.TransactionSupportLevel tsl = TransactionSupport.TransactionSupportLevel.NoTransaction;
                            TransactionSupportEnum tsmd = TransactionSupportEnum.NoTransaction;
                            tsmd = raxml.getTransactionSupport() != null ? raxml.getTransactionSupport() : (ijmd != null && ijmd.getTransactionSupport() != null ? ijmd.getTransactionSupport() : ra.getOutboundResourceadapter().getTransactionSupport());
                            if (tsmd == TransactionSupportEnum.NoTransaction) {
                                tsl = TransactionSupport.TransactionSupportLevel.NoTransaction;
                            } else if (tsmd == TransactionSupportEnum.LocalTransaction) {
                                tsl = TransactionSupport.TransactionSupportLevel.LocalTransaction;
                            } else if (tsmd == TransactionSupportEnum.XATransaction) {
                                tsl = TransactionSupport.TransactionSupportLevel.XATransaction;
                            }
                            if (mcf instanceof TransactionSupport) {
                                tsl = ((TransactionSupport)mcf).getTransactionSupport();
                            }
                            Integer allocationRetry = null;
                            Long allocationRetryWaitMillis = null;
                            if (cdRaXml.getTimeOut() != null) {
                                allocationRetry = cdRaXml.getTimeOut().getAllocationRetry();
                                allocationRetryWaitMillis = cdRaXml.getTimeOut().getAllocationRetryWaitMillis();
                            }
                            if (ijCD != null && ijCD.getTimeOut() != null) {
                                if (allocationRetry == null) {
                                    allocationRetry = ijCD.getTimeOut().getAllocationRetry();
                                }
                                if (allocationRetryWaitMillis == null) {
                                    allocationRetryWaitMillis = ijCD.getTimeOut().getAllocationRetryWaitMillis();
                                }
                            }
                            if (tsl == TransactionSupport.TransactionSupportLevel.NoTransaction) {
                                cm = cmf.createNonTransactional(tsl, pool, allocationRetry, allocationRetryWaitMillis);
                            } else {
                                Boolean interleaving = null;
                                Integer xaResourceTimeout = null;
                                Boolean isSameRMOverride = null;
                                Boolean wrapXAResource = null;
                                Boolean padXid = null;
                                if (cdRaXml.isXa().booleanValue()) {
                                    CommonXaPool ijXaPool3 = (CommonXaPool)cdRaXml.getPool();
                                    interleaving = ijXaPool3.isInterleaving();
                                    isSameRMOverride = ijXaPool3.isSameRmOverride();
                                    wrapXAResource = ijXaPool3.isWrapXaDataSource();
                                    padXid = ijXaPool3.isPadXid();
                                }
                                if (ijCD != null && ijCD.isXa().booleanValue()) {
                                    CommonXaPool ijXaPool3 = (CommonXaPool)ijCD.getPool();
                                    if (interleaving == null) {
                                        interleaving = ijXaPool3.isInterleaving();
                                    }
                                    if (isSameRMOverride == null) {
                                        isSameRMOverride = ijXaPool3.isSameRmOverride();
                                    }
                                    if (wrapXAResource == null) {
                                        wrapXAResource = ijXaPool3.isWrapXaDataSource();
                                    }
                                    if (padXid == null) {
                                        padXid = ijXaPool3.isPadXid();
                                    }
                                }
                                cm = cmf.createTransactional(tsl, pool, allocationRetry, allocationRetryWaitMillis, this.getConfiguration().getTransactionManager(), interleaving, xaResourceTimeout, isSameRMOverride, wrapXAResource, padXid);
                            }
                            Object cf = mcf.createConnectionFactory((ConnectionManager)cm);
                            if (cf == null) {
                                log.error((Object)"ConnectionFactory is null");
                            } else if (trace) {
                                log.trace((Object)("ConnectionFactory: " + cf.getClass().getName()));
                                log.trace((Object)("ConnectionFactory defined in classloader: " + cf.getClass().getClassLoader()));
                            }
                            archiveValidationObjects.add((Validate)new ValidateObject(Key.CONNECTION_FACTORY, cf));
                            if (cf == null || !(cf instanceof Serializable) || !(cf instanceof Referenceable)) continue;
                            String jndiName = cdRaXml.getJndiName();
                            this.bindConnectionFactory(deployment, deploymentName, cf, jndiName);
                            cfs[cdIndex] = cf;
                            jndiNames[cdIndex] = jndiName;
                            cm.setJndiName(jndiName);
                        }
                    }
                }
                if (cmd.getVersion() != Connector.Version.V_10 && (ra1516 = (ResourceAdapter1516)cmd.getResourceadapter()) != null && ra1516.getInboundResourceadapter() != null && ra1516.getInboundResourceadapter().getMessageadapter() != null && ra1516.getInboundResourceadapter().getMessageadapter().getMessagelisteners() != null && (mlMetas = ra1516.getInboundResourceadapter().getMessageadapter().getMessagelisteners()).size() > 0) {
                    for (MessageListener messageListener : mlMetas) {
                        if (messageListener.getActivationspec() == null || messageListener.getActivationspec().getActivationspecClass().getValue() == null) continue;
                        List cpm = messageListener.getActivationspec().getConfigProperties();
                        Object o = this.initAndInject(messageListener.getActivationspec().getActivationspecClass().getValue(), cpm, (ClassLoader)cl);
                        if (trace) {
                            log.trace((Object)("ActivationSpec: " + o.getClass().getName()));
                            log.trace((Object)("ActivationSpec defined in classloader: " + o.getClass().getClassLoader()));
                        }
                        archiveValidationObjects.add((Validate)new ValidateObject(Key.ACTIVATION_SPEC, o, cpm));
                        beanValidationObjects.add(o);
                        this.associateResourceAdapter(resourceAdapter, o);
                    }
                }
                if (cmd.getVersion() != Connector.Version.V_10 && (ra1516 = (ResourceAdapter1516)cmd.getResourceadapter()) != null && ra1516.getAdminObjects() != null && (aoMetas = ((ResourceAdapter1516)cmd.getResourceadapter()).getAdminObjects()).size() > 0) {
                    for (AdminObject adminObject : aoMetas) {
                        if (adminObject.getAdminobjectClass() == null || adminObject.getAdminobjectClass().getValue() == null) continue;
                        Object o = this.initAndInject(adminObject.getAdminobjectClass().getValue(), adminObject.getConfigProperties(), (ClassLoader)cl);
                        if (trace) {
                            log.trace((Object)("AdminObject: " + o.getClass().getName()));
                            log.trace((Object)("AdminObject defined in classloader: " + o.getClass().getClassLoader()));
                        }
                        archiveValidationObjects.add((Validate)new ValidateObject(Key.ADMIN_OBJECT, o, adminObject.getConfigProperties()));
                        beanValidationObjects.add(o);
                    }
                }
            }
            if ((partialFailures = this.validateArchive(url, archiveValidationObjects)) != null) {
                if (failures == null) {
                    failures = new HashSet<Failure>();
                }
                failures.addAll(partialFailures);
            }
            if (this.getConfiguration().getArchiveValidationFailOnWarn() && this.hasFailuresLevel(failures, 0) || this.getConfiguration().getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1)) {
                throw new ValidatorException(this.printFailuresLog(url.getPath(), new Validator(), failures, null, new FailureHelper[0]), failures);
            }
            this.printFailuresLog(url.getPath(), new Validator(), failures, null, new FailureHelper[0]);
            if (this.getConfiguration().getBeanValidation()) {
                List groups;
                ArrayList<Class> groupsClasses = null;
                if (raxml.getBeanValidationGroups() != null && raxml.getBeanValidationGroups().size() > 0) {
                    groups = raxml.getBeanValidationGroups();
                    groupsClasses = new ArrayList<Class>(groups.size());
                    for (String string : groups) {
                        groupsClasses.add(Class.forName(string, true, (ClassLoader)cl));
                    }
                }
                if (groupsClasses == null && ijmd != null && ijmd.getBeanValidationGroups() != null && ijmd.getBeanValidationGroups().size() > 0) {
                    groups = ijmd.getBeanValidationGroups();
                    groupsClasses = new ArrayList(groups.size());
                    for (String string : groups) {
                        groupsClasses.add(Class.forName(string, true, (ClassLoader)cl));
                    }
                }
                if (beanValidationObjects.size() > 0) {
                    BeanValidation beanValidator = new BeanValidation();
                    for (Object e : beanValidationObjects) {
                        beanValidator.validate(e, groupsClasses);
                    }
                }
            }
            if (resourceAdapter != null) {
                String bootstrapIdentifier = null;
                if (raxml.getBootstrapContext() != null && !raxml.getBootstrapContext().trim().equals("")) {
                    bootstrapIdentifier = raxml.getBootstrapContext();
                }
                if (bootstrapIdentifier == null && ijmd != null && ijmd.getBootstrapContext() != null && !ijmd.getBootstrapContext().trim().equals("")) {
                    bootstrapIdentifier = ijmd.getBootstrapContext();
                }
                this.startContext(resourceAdapter, bootstrapIdentifier);
            }
            log.info((Object)("Deployed: " + url.toExternalForm()));
            RaXmlDeployment raXmlDeployment = new RaXmlDeployment(url, deployment, deploymentName, resourceAdapter, this.getConfiguration().getJndiStrategy(), this.getConfiguration().getMetadataRepository(), cfs, jndiNames, (ClassLoader)cl, log);
            return raXmlDeployment;
        }
        catch (DeployException de) {
            throw de;
        }
        catch (Throwable t) {
            if (this.getConfiguration().getArchiveValidationFailOnWarn() && this.hasFailuresLevel(failures, 0) || this.getConfiguration().getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1)) {
                throw new DeployException("Deployment " + url.toExternalForm() + " failed", (Throwable)new ValidatorException(this.printFailuresLog(url.getPath(), new Validator(), failures, null, new FailureHelper[0]), failures));
            }
            this.printFailuresLog(url.getPath(), new Validator(), failures, null, new FailureHelper[0]);
            throw new DeployException("Deployment " + url.toExternalForm() + " failed", t);
        }
        finally {
            SecurityActions.setThreadContextClassLoader(oldTCCL);
        }
    }

    @Override
    public void start() {
        super.start();
        if (this.kernel == null) {
            throw new IllegalStateException("Kernel not defined");
        }
    }
}

