/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import java.net.URL;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.resource.spi.ResourceAdapter;
import org.jboss.jca.core.api.management.Connector;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.mdr.NotFoundException;
import org.jboss.jca.core.spi.naming.JndiStrategy;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.deployers.fungal.AbstractFungalDeployment;
import org.jboss.logging.Logger;

public class RaXmlDeployment
extends AbstractFungalDeployment {
    private URL raDeployment;

    public RaXmlDeployment(URL deployment, URL raDeployment, String deploymentName, ResourceAdapter ra, String raKey, JndiStrategy jndiStrategy, MetadataRepository mdr, ResourceAdapterRepository resourceAdapterRepository, Object[] cfs, String[] cfJndis, Object[] aos, String[] aoJndis, ManagementRepository managementRepository, Connector connector, MBeanServer server, List<ObjectName> objectNames, ClassLoader cl, Logger log) {
        super(deployment, deploymentName, true, ra, raKey, jndiStrategy, mdr, resourceAdapterRepository, cfs, cfJndis, aos, aoJndis, managementRepository, connector, server, objectNames, cl, log);
        this.raDeployment = raDeployment;
    }

    @Override
    public void stop() {
        String jndi;
        int i;
        super.stop();
        this.log.debug((Object)("Undeploying: " + this.deployment.toExternalForm()));
        if (this.mdr != null && this.cfs != null && this.cfJndis != null) {
            for (i = 0; i < this.cfs.length; ++i) {
                try {
                    String cf = this.cfs[i].getClass().getName();
                    jndi = this.cfJndis[i];
                    this.mdr.unregisterJndiMapping(this.raDeployment.toExternalForm(), cf, jndi);
                    continue;
                }
                catch (NotFoundException nfe) {
                    this.log.warn((Object)"Exception during unregistering deployment", (Throwable)nfe);
                }
            }
        }
        if (this.mdr != null && this.aos != null && this.aoJndis != null) {
            for (i = 0; i < this.aos.length; ++i) {
                try {
                    String ao = this.aos[i].getClass().getName();
                    jndi = this.aoJndis[i];
                    this.mdr.unregisterJndiMapping(this.raDeployment.toExternalForm(), ao, jndi);
                    continue;
                }
                catch (NotFoundException nfe) {
                    this.log.warn((Object)"Exception during unregistering deployment", (Throwable)nfe);
                }
            }
        }
    }
}

