/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import com.github.fungal.api.classloading.ClassLoaderFactory;
import com.github.fungal.api.classloading.KernelClassLoader;
import com.github.fungal.api.util.FileUtil;
import com.github.fungal.spi.deployers.DeployerPhases;
import com.github.fungal.spi.deployers.Deployment;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import org.jboss.jca.common.api.metadata.common.CommonIronJacamar;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.metadata.merge.Merger;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.naming.JndiStrategy;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.deployers.DeployersLogger;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.DeployException;
import org.jboss.jca.deployers.fungal.AbstractFungalRADeployer;
import org.jboss.jca.deployers.fungal.RAActivatorDeployment;
import org.jboss.jca.deployers.fungal.RAConfiguration;
import org.jboss.jca.deployers.fungal.SecurityActions;
import org.jboss.logging.Logger;

public final class RAActivator
extends AbstractFungalRADeployer
implements DeployerPhases {
    private static DeployersLogger log = (DeployersLogger)Logger.getMessageLogger(DeployersLogger.class, (String)RAActivator.class.getName());
    private static boolean trace = log.isTraceEnabled();
    private boolean enabled = true;
    private Set<String> excludeArchives = null;
    private List<Deployment> deployments = null;

    public RAActivator() {
        super(false);
    }

    protected DeployersLogger getLogger() {
        return log;
    }

    public Set<String> getExcludeArchives() {
        return this.excludeArchives;
    }

    public void setExcludeArchives(Set<String> archives) {
        this.excludeArchives = archives;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public void preDeploy() throws Throwable {
    }

    public void postDeploy() throws Throwable {
        if (this.enabled) {
            MetadataRepository mdr = ((RAConfiguration)this.getConfiguration()).getMetadataRepository();
            Set rarDeployments = mdr.getResourceAdapters();
            for (String deployment : rarDeployments) {
                Deployment raDeployment;
                if (trace) {
                    log.trace((Object)("Processing: " + deployment));
                }
                boolean include = true;
                if (this.excludeArchives != null) {
                    for (String excludedArchive : this.excludeArchives) {
                        if (!deployment.endsWith(excludedArchive)) continue;
                        include = false;
                    }
                }
                if (!include || mdr.hasJndiMappings(deployment) || (raDeployment = this.deploy(new URL(deployment), (ClassLoader)this.kernel.getKernelClassLoader())) == null) continue;
                if (this.deployments == null) {
                    this.deployments = new ArrayList<Deployment>(1);
                }
                this.deployments.add(raDeployment);
                this.kernel.getMainDeployer().registerDeployment(raDeployment);
            }
        }
    }

    public void preUndeploy() throws Throwable {
        if (this.deployments != null) {
            for (Deployment raDeployment : this.deployments) {
                try {
                    this.kernel.getMainDeployer().unregisterDeployment(raDeployment);
                }
                catch (Throwable t) {
                    log.warn((Object)("Error during undeployment of " + raDeployment.getURL()));
                }
            }
            this.deployments = null;
        }
    }

    public void postUndeploy() throws Throwable {
    }

    private Deployment deploy(URL url, ClassLoader parent) throws com.github.fungal.spi.deployers.DeployException {
        log.debug((Object)("Deploying: " + url.toExternalForm()));
        ClassLoader oldTCCL = SecurityActions.getThreadContextClassLoader();
        try {
            File f = new File(url.toURI());
            if (!f.exists()) {
                Deployment deployment = null;
                return deployment;
            }
            File root = null;
            File destination = null;
            if (f.isFile()) {
                FileUtil fileUtil = new FileUtil();
                destination = new File(SecurityActions.getSystemProperty("iron.jacamar.home"), "/tmp/");
                root = fileUtil.extract(f, destination);
            } else {
                root = f;
            }
            String deploymentName = f.getName().substring(0, f.getName().indexOf(".rar"));
            URL[] urls = this.getUrls(root);
            KernelClassLoader cl = null;
            cl = ((RAConfiguration)this.getConfiguration()).getScopeDeployment() ? ClassLoaderFactory.create((int)1, (URL[])urls, (ClassLoader)parent) : ClassLoaderFactory.create((int)0, (URL[])urls, (ClassLoader)parent);
            SecurityActions.setThreadContextClassLoader((ClassLoader)cl);
            MetadataRepository metadataRepository = ((RAConfiguration)this.getConfiguration()).getMetadataRepository();
            Connector cmd = metadataRepository.getResourceAdapter(url.toExternalForm());
            IronJacamar ijmd = metadataRepository.getIronJacamar(url.toExternalForm());
            cmd = new Merger().mergeConnectorWithCommonIronJacamar((CommonIronJacamar)ijmd, cmd);
            CommonDeployment c = this.createObjectsAndInjectValue(url, deploymentName, root, (ClassLoader)cl, cmd, ijmd);
            List<ObjectName> ons = this.registerManagementView(c.getConnector(), this.kernel.getMBeanServer(), this.kernel.getName());
            JndiStrategy jndiStrategy = ((RAConfiguration)this.getConfiguration()).getJndiStrategy();
            ResourceAdapterRepository resourceAdapterRepository = ((RAConfiguration)this.getConfiguration()).getResourceAdapterRepository();
            RAActivatorDeployment rAActivatorDeployment = new RAActivatorDeployment(c.getURL(), c.getDeploymentName(), c.getResourceAdapter(), c.getResourceAdapterKey(), jndiStrategy, metadataRepository, resourceAdapterRepository, c.getCfs(), c.getCfJndiNames(), c.getAos(), c.getAoJndiNames(), c.getRecovery(), this.getTransactionIntegration().getRecoveryRegistry(), ((RAConfiguration)this.getConfiguration()).getManagementRepository(), c.getConnector(), this.kernel.getMBeanServer(), ons, c.getCl(), c.getLog());
            return rAActivatorDeployment;
        }
        catch (com.github.fungal.spi.deployers.DeployException de) {
            throw de;
        }
        catch (DeployException cde) {
            throw new com.github.fungal.spi.deployers.DeployException(cde.getMessage(), cde.getCause());
        }
        catch (Throwable t) {
            throw new com.github.fungal.spi.deployers.DeployException("Deployment " + url.toExternalForm() + " failed", t);
        }
        finally {
            SecurityActions.setThreadContextClassLoader(oldTCCL);
        }
    }

    protected boolean checkActivation(Connector cmd, IronJacamar ijmd) {
        return true;
    }
}

