/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import com.github.fungal.api.classloading.ClassLoaderFactory;
import com.github.fungal.api.classloading.KernelClassLoader;
import com.github.fungal.api.util.FileUtil;
import com.github.fungal.spi.deployers.Deployer;
import com.github.fungal.spi.deployers.DeployerOrder;
import com.github.fungal.spi.deployers.Deployment;
import com.github.fungal.spi.deployers.MultiStageDeployer;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;
import org.jboss.jca.common.annotations.Annotations;
import org.jboss.jca.common.api.metadata.common.CommonConnDef;
import org.jboss.jca.common.api.metadata.common.CommonIronJacamar;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.AdminObject;
import org.jboss.jca.common.api.metadata.ra.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter1516;
import org.jboss.jca.common.api.metadata.ra.ra10.ResourceAdapter10;
import org.jboss.jca.common.metadata.MetadataFactory;
import org.jboss.jca.common.metadata.merge.Merger;
import org.jboss.jca.common.spi.annotations.repository.AnnotationRepository;
import org.jboss.jca.common.spi.annotations.repository.AnnotationScanner;
import org.jboss.jca.common.spi.annotations.repository.AnnotationScannerFactory;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.naming.JndiStrategy;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.deployers.DeployersLogger;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.DeployException;
import org.jboss.jca.deployers.fungal.AbstractFungalRADeployer;
import org.jboss.jca.deployers.fungal.RAConfiguration;
import org.jboss.jca.deployers.fungal.RADeployment;
import org.jboss.jca.deployers.fungal.SecurityActions;
import org.jboss.logging.Logger;

public final class RADeployer
extends AbstractFungalRADeployer
implements Deployer,
MultiStageDeployer,
DeployerOrder {
    private static DeployersLogger log = (DeployersLogger)Logger.getMessageLogger(DeployersLogger.class, (String)RADeployer.class.getName());

    public RADeployer() {
        super(true);
    }

    protected DeployersLogger getLogger() {
        return log;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public synchronized Deployment deploy(URL url, ClassLoader parent) throws com.github.fungal.spi.deployers.DeployException {
        if (url == null || !url.toExternalForm().endsWith(".rar") && !url.toExternalForm().endsWith(".rar/")) {
            return null;
        }
        log.debug((Object)("Deploying: " + url.toExternalForm()));
        ClassLoader oldTCCL = SecurityActions.getThreadContextClassLoader();
        try {
            File f = new File(url.toURI());
            if (!f.exists()) {
                throw new IOException("Archive " + url.toExternalForm() + " doesnt exists");
            }
            File root = null;
            File destination = null;
            if (f.isFile()) {
                FileUtil fileUtil = new FileUtil();
                destination = new File(SecurityActions.getSystemProperty("iron.jacamar.home"), "/tmp/");
                root = fileUtil.extract(f, destination);
            } else {
                root = f;
            }
            String deploymentName = f.getName().substring(0, f.getName().indexOf(".rar"));
            URL[] urls = this.getUrls(root);
            KernelClassLoader cl = null;
            cl = ((RAConfiguration)this.getConfiguration()).getScopeDeployment() ? ClassLoaderFactory.create((int)1, (URL[])urls, (ClassLoader)parent) : ClassLoaderFactory.create((int)0, (URL[])urls, (ClassLoader)parent);
            SecurityActions.setThreadContextClassLoader((ClassLoader)cl);
            MetadataFactory metadataFactory = new MetadataFactory();
            Connector cmd = metadataFactory.getStandardMetaData(root);
            IronJacamar ijmd = metadataFactory.getIronJacamarMetaData(root);
            Annotations annotator = new Annotations();
            AnnotationScanner scanner = AnnotationScannerFactory.getAnnotationScanner();
            AnnotationRepository repository = scanner.scan(cl.getURLs(), (ClassLoader)cl);
            cmd = annotator.merge(cmd, repository, (ClassLoader)cl);
            cmd.validate();
            cmd = new Merger().mergeConnectorWithCommonIronJacamar((CommonIronJacamar)ijmd, cmd);
            CommonDeployment c = this.createObjectsAndInjectValue(url, deploymentName, root, (ClassLoader)cl, cmd, ijmd);
            List<ObjectName> ons = null;
            if (c.isActivateDeployment()) {
                ons = this.registerManagementView(c.getConnector(), this.kernel.getMBeanServer(), this.kernel.getName());
            }
            JndiStrategy jndiStrategy = ((RAConfiguration)this.getConfiguration()).getJndiStrategy();
            MetadataRepository metadataRepository = ((RAConfiguration)this.getConfiguration()).getMetadataRepository();
            ResourceAdapterRepository resourceAdapterRepository = ((RAConfiguration)this.getConfiguration()).getResourceAdapterRepository();
            RADeployment rADeployment = new RADeployment(c.getURL(), c.getDeploymentName(), c.isActivateDeployment(), c.getResourceAdapter(), c.getResourceAdapterKey(), jndiStrategy, metadataRepository, resourceAdapterRepository, c.getCfs(), c.getCfJndiNames(), c.getAos(), c.getAoJndiNames(), c.getRecovery(), this.getTransactionIntegration().getRecoveryRegistry(), destination, ((RAConfiguration)this.getConfiguration()).getManagementRepository(), c.getConnector(), this.kernel.getMBeanServer(), ons, c.getCl(), c.getLog());
            return rADeployment;
        }
        catch (com.github.fungal.spi.deployers.DeployException de) {
            throw de;
        }
        catch (DeployException cde) {
            throw new com.github.fungal.spi.deployers.DeployException(cde.getMessage(), cde.getCause());
        }
        catch (Throwable t) {
            throw new com.github.fungal.spi.deployers.DeployException("Deployment " + url.toExternalForm() + " failed", t);
        }
        finally {
            SecurityActions.setThreadContextClassLoader(oldTCCL);
        }
    }

    protected boolean checkActivation(Connector cmd, IronJacamar ijmd) {
        if (cmd != null) {
            HashSet<String> raMcfClasses = new HashSet<String>();
            HashSet<String> raAoClasses = new HashSet<String>();
            if (cmd.getVersion() == Connector.Version.V_10) {
                ResourceAdapter10 ra10 = (ResourceAdapter10)cmd.getResourceadapter();
                raMcfClasses.add(ra10.getManagedConnectionFactoryClass().getValue());
            } else {
                List aoMetas;
                List cdMetas;
                ResourceAdapter1516 ra = (ResourceAdapter1516)cmd.getResourceadapter();
                if (ra != null && ra.getOutboundResourceadapter() != null && ra.getOutboundResourceadapter().getConnectionDefinitions() != null && (cdMetas = ra.getOutboundResourceadapter().getConnectionDefinitions()).size() > 0) {
                    for (ConnectionDefinition cdMeta : cdMetas) {
                        raMcfClasses.add(cdMeta.getManagedConnectionFactoryClass().getValue());
                    }
                }
                if (ra != null && ra.getAdminObjects() != null && (aoMetas = ra.getAdminObjects()).size() > 0) {
                    for (AdminObject aoMeta : aoMetas) {
                        raAoClasses.add(aoMeta.getAdminobjectClass().getValue());
                    }
                }
                if (raMcfClasses.size() == 0 && raAoClasses.size() == 0) {
                    return true;
                }
            }
            if (ijmd != null) {
                String clz;
                Iterator it;
                String clz2;
                HashSet<String> ijMcfClasses = new HashSet<String>();
                HashSet<String> ijAoClasses = new HashSet<String>();
                boolean mcfSingle = false;
                boolean aoSingle = false;
                boolean mcfOk = true;
                boolean aoOk = true;
                if (ijmd.getConnectionDefinitions() != null) {
                    for (CommonConnDef def : ijmd.getConnectionDefinitions()) {
                        clz2 = def.getClassName();
                        if (clz2 == null) {
                            if (raMcfClasses.size() != 1) continue;
                            mcfSingle = true;
                            continue;
                        }
                        ijMcfClasses.add(clz2);
                    }
                }
                if (!mcfSingle) {
                    it = raMcfClasses.iterator();
                    while (mcfOk && it.hasNext()) {
                        clz = (String)it.next();
                        if (ijMcfClasses.contains(clz)) continue;
                        mcfOk = false;
                    }
                }
                if (ijmd.getAdminObjects() != null) {
                    for (CommonConnDef def : ijmd.getAdminObjects()) {
                        clz2 = def.getClassName();
                        if (clz2 == null) {
                            if (raAoClasses.size() != 1) continue;
                            aoSingle = true;
                            continue;
                        }
                        ijAoClasses.add(clz2);
                    }
                }
                if (!aoSingle) {
                    it = raAoClasses.iterator();
                    while (aoOk && it.hasNext()) {
                        clz = (String)it.next();
                        if (ijAoClasses.contains(clz)) continue;
                        aoOk = false;
                    }
                }
                return mcfOk && aoOk;
            }
        }
        return false;
    }
}

