/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import com.github.fungal.api.Kernel;
import com.github.fungal.api.util.Injection;
import com.github.fungal.api.util.JMX;
import com.github.fungal.api.util.JarFilter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.management.DynamicMBean;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.resource.spi.ResourceAdapter;
import javax.transaction.TransactionManager;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.ConfigProperty;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.ra.XsdString;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.management.AdminObject;
import org.jboss.jca.core.api.management.ConnectionFactory;
import org.jboss.jca.core.api.management.ManagedConnectionFactory;
import org.jboss.jca.core.spi.mdr.AlreadyExistsException;
import org.jboss.jca.core.spi.naming.JndiStrategy;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.deployers.common.AbstractResourceAdapterDeployer;
import org.jboss.jca.deployers.common.DeployException;
import org.jboss.jca.deployers.fungal.RAConfiguration;
import org.jboss.jca.deployers.fungal.SecurityActions;
import org.jboss.security.SubjectFactory;

public abstract class AbstractFungalRADeployer
extends AbstractResourceAdapterDeployer {
    protected Kernel kernel = null;

    public AbstractFungalRADeployer(boolean validateClasses) {
        super(validateClasses);
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public void start() {
        super.start();
        if (this.kernel == null) {
            throw new IllegalStateException("Kernel not defined");
        }
    }

    public Object initAndInject(String className, List<? extends ConfigProperty> configs, ClassLoader cl) throws DeployException {
        try {
            Class<?> clz = Class.forName(className, true, cl);
            Object o = clz.newInstance();
            if (configs != null) {
                Injection injector = new Injection();
                for (ConfigProperty configProperty : configs) {
                    if (!configProperty.isValueSet()) continue;
                    try {
                        if (XsdString.isNull((XsdString)configProperty.getConfigPropertyType())) {
                            injector.inject(o, configProperty.getConfigPropertyName().getValue(), (Object)configProperty.getConfigPropertyValue().getValue());
                            continue;
                        }
                        injector.inject(o, configProperty.getConfigPropertyName().getValue(), (Object)configProperty.getConfigPropertyValue().getValue(), configProperty.getConfigPropertyType().getValue());
                    }
                    catch (Throwable t) {
                        String newPropertyType = this.convertType(configProperty.getConfigPropertyType().getValue());
                        if (newPropertyType != null) {
                            injector.inject(o, configProperty.getConfigPropertyName().getValue(), (Object)configProperty.getConfigPropertyValue().getValue(), newPropertyType);
                            continue;
                        }
                        throw t;
                    }
                }
            }
            return o;
        }
        catch (Throwable t) {
            throw new DeployException("Deployment " + className + " failed", t);
        }
    }

    private String convertType(String old) {
        if (Boolean.class.getName().equals(old)) {
            return Boolean.TYPE.getName();
        }
        if (Boolean.TYPE.getName().equals(old)) {
            return Boolean.class.getName();
        }
        if (Byte.class.getName().equals(old)) {
            return Byte.TYPE.getName();
        }
        if (Byte.TYPE.getName().equals(old)) {
            return Byte.class.getName();
        }
        if (Short.class.getName().equals(old)) {
            return Short.TYPE.getName();
        }
        if (Short.TYPE.getName().equals(old)) {
            return Short.class.getName();
        }
        if (Integer.class.getName().equals(old)) {
            return Integer.TYPE.getName();
        }
        if (Integer.TYPE.getName().equals(old)) {
            return Integer.class.getName();
        }
        if (Long.class.getName().equals(old)) {
            return Long.TYPE.getName();
        }
        if (Long.TYPE.getName().equals(old)) {
            return Long.class.getName();
        }
        if (Float.class.getName().equals(old)) {
            return Float.TYPE.getName();
        }
        if (Float.TYPE.getName().equals(old)) {
            return Float.class.getName();
        }
        if (Double.class.getName().equals(old)) {
            return Double.TYPE.getName();
        }
        if (Double.TYPE.getName().equals(old)) {
            return Double.class.getName();
        }
        if (Character.class.getName().equals(old)) {
            return Character.TYPE.getName();
        }
        if (Character.TYPE.getName().equals(old)) {
            return Character.class.getName();
        }
        return null;
    }

    protected URL[] getUrls(File directory) throws MalformedURLException, IOException {
        LinkedList<URL> list = new LinkedList<URL>();
        if (directory.exists() && directory.isDirectory()) {
            list.add(directory.toURI().toURL());
            File[] jars = directory.listFiles((FilenameFilter)new JarFilter());
            if (jars != null) {
                for (int j = 0; j < jars.length; ++j) {
                    list.add(jars[j].getCanonicalFile().toURI().toURL());
                }
            }
        }
        return list.toArray(new URL[list.size()]);
    }

    public String[] bindConnectionFactory(URL url, String deployment, Object cf) throws Throwable {
        JndiStrategy js = ((RAConfiguration)this.getConfiguration()).getJndiStrategy().clone();
        String[] result = js.bindConnectionFactories(deployment, new Object[]{cf});
        ((RAConfiguration)this.getConfiguration()).getMetadataRepository().registerJndiMapping(url.toExternalForm(), cf.getClass().getName(), result[0]);
        this.log.infof("Bound connection factory under: %s", (Object)result[0]);
        return result;
    }

    public String[] bindConnectionFactory(URL url, String deployment, Object cf, String jndi) throws Throwable {
        JndiStrategy js = ((RAConfiguration)this.getConfiguration()).getJndiStrategy().clone();
        String[] result = js.bindConnectionFactories(deployment, new Object[]{cf}, new String[]{jndi});
        ((RAConfiguration)this.getConfiguration()).getMetadataRepository().registerJndiMapping(url.toExternalForm(), cf.getClass().getName(), jndi);
        this.log.infof("Bound connection factory under: %s", (Object)jndi);
        return result;
    }

    public String[] bindAdminObject(URL url, String deployment, Object ao) throws Throwable {
        JndiStrategy js = ((RAConfiguration)this.getConfiguration()).getJndiStrategy().clone();
        String[] result = js.bindAdminObjects(deployment, new Object[]{ao});
        ((RAConfiguration)this.getConfiguration()).getMetadataRepository().registerJndiMapping(url.toExternalForm(), ao.getClass().getName(), result[0]);
        this.log.infof("Bound admin object under: %s", (Object)result[0]);
        return result;
    }

    public String[] bindAdminObject(URL url, String deployment, Object ao, String jndi) throws Throwable {
        JndiStrategy js = ((RAConfiguration)this.getConfiguration()).getJndiStrategy().clone();
        String[] result = js.bindAdminObjects(deployment, new Object[]{ao}, new String[]{jndi});
        ((RAConfiguration)this.getConfiguration()).getMetadataRepository().registerJndiMapping(url.toExternalForm(), ao.getClass().getName(), jndi);
        this.log.infof("Bound admin object under: %s", (Object)jndi);
        return result;
    }

    protected File getReportDirectory() {
        return new File(SecurityActions.getSystemProperty("iron.jacamar.home"), "/log/");
    }

    protected boolean checkConfigurationIsValid() {
        return this.getConfiguration() != null && this.getConfiguration() instanceof RAConfiguration;
    }

    protected PrintWriter getLogPrintWriter() {
        return new PrintWriter(((RAConfiguration)this.getConfiguration()).getPrintStream());
    }

    protected TransactionManager getTransactionManager() {
        return ((RAConfiguration)this.getConfiguration()).getTransactionIntegration().getTransactionManager();
    }

    protected TransactionIntegration getTransactionIntegration() {
        return ((RAConfiguration)this.getConfiguration()).getTransactionIntegration();
    }

    protected void registerResourceAdapterToMDR(URL url, File root, Connector cmd, IronJacamar ijmd) throws AlreadyExistsException {
        ((RAConfiguration)this.getConfiguration()).getMetadataRepository().registerResourceAdapter(url.toExternalForm(), root, cmd, ijmd);
    }

    protected String registerResourceAdapterToResourceAdapterRepository(ResourceAdapter instance) {
        return ((RAConfiguration)this.getConfiguration()).getResourceAdapterRepository().registerResourceAdapter(instance);
    }

    protected List<ObjectName> registerManagementView(org.jboss.jca.core.api.management.Connector mgtConnector, MBeanServer server, String domain) throws JMException {
        ArrayList<ObjectName> ons = null;
        if (mgtConnector != null) {
            if (server != null) {
                HashSet<String> excludeStatOperations;
                HashSet<String> excludeStatAttributes;
                HashSet<String> writeStatAttributes;
                org.jboss.jca.core.api.management.ResourceAdapter mgtRa;
                ons = new ArrayList<ObjectName>();
                String baseName = domain + ":deployment=" + mgtConnector.getUniqueId();
                if (mgtConnector.getResourceAdapter() != null && (mgtRa = mgtConnector.getResourceAdapter()).getResourceAdapter() != null) {
                    HashSet<String> writeable = new HashSet<String>();
                    HashSet<String> excludeAttributes = new HashSet<String>();
                    for (org.jboss.jca.core.api.management.ConfigProperty mgtCp : mgtRa.getConfigProperties()) {
                        String mgtCpName = mgtCp.getName().substring(0, 1).toUpperCase(Locale.US);
                        if (mgtCp.getName().length() > 1) {
                            mgtCpName = mgtCpName + mgtCp.getName().substring(1);
                        }
                        if (mgtCp.isDynamic()) {
                            writeable.add(mgtCpName);
                        }
                        if (!mgtCp.isConfidential()) continue;
                        excludeAttributes.add(mgtCpName);
                    }
                    String raName = baseName + ",type=ResourceAdapter,class=" + this.getClassName(mgtRa.getResourceAdapter().getClass().getName());
                    DynamicMBean raDMB = JMX.createMBean((Object)mgtRa.getResourceAdapter(), (String)"Resource adapter", writeable, null, excludeAttributes, null);
                    ObjectName raON = new ObjectName(raName);
                    server.registerMBean(raDMB, raON);
                    ons.add(raON);
                    if (mgtRa.getStatistics() != null) {
                        String raSName = baseName + ",type=ResourceAdapterStatistics,class=" + this.getClassName(mgtRa.getResourceAdapter().getClass().getName());
                        writeStatAttributes = new HashSet<String>();
                        writeStatAttributes.add("Enabled");
                        excludeStatAttributes = new HashSet<String>();
                        excludeStatAttributes.add("Names");
                        excludeStatOperations = new HashSet<String>();
                        excludeStatOperations.add("delta(.)*");
                        DynamicMBean raSDMB = JMX.createMBean((Object)mgtRa.getStatistics(), (String)"Resource adapter statistics", writeStatAttributes, null, excludeStatAttributes, excludeStatOperations);
                        ObjectName raSON = new ObjectName(raSName);
                        server.registerMBean(raSDMB, raSON);
                        ons.add(raSON);
                    }
                }
                for (ConnectionFactory mgtCf : mgtConnector.getConnectionFactories()) {
                    String jndiName = this.cleanJndiName(mgtCf.getJndiName());
                    if (mgtCf.getManagedConnectionFactory() != null) {
                        ManagedConnectionFactory mgtMcf = mgtCf.getManagedConnectionFactory();
                        HashSet<String> writeable = new HashSet<String>();
                        HashSet<String> excludeAttributes = new HashSet<String>();
                        for (org.jboss.jca.core.api.management.ConfigProperty mgtCp : mgtMcf.getConfigProperties()) {
                            String mgtCpName = mgtCp.getName().substring(0, 1).toUpperCase(Locale.US);
                            if (mgtCp.getName().length() > 1) {
                                mgtCpName = mgtCpName + mgtCp.getName().substring(1);
                            }
                            if (mgtCp.isDynamic()) {
                                writeable.add(mgtCpName);
                            }
                            if (!mgtCp.isConfidential()) continue;
                            excludeAttributes.add(mgtCpName);
                        }
                        String mcfName = baseName + ",jndi=" + jndiName + ",type=ManagedConnectionFactory,class=" + this.getClassName(mgtMcf.getManagedConnectionFactory().getClass().getName());
                        DynamicMBean mcfDMB = JMX.createMBean((Object)mgtMcf.getManagedConnectionFactory(), (String)"Managed connection factory", writeable, null, excludeAttributes, null);
                        ObjectName mcfON = new ObjectName(mcfName);
                        server.registerMBean(mcfDMB, mcfON);
                        ons.add(mcfON);
                        if (mgtMcf.getStatistics() != null) {
                            String mcfSName = baseName + ",jndi=" + jndiName + ",type=ManagedConnectionFactoryStatistics,class=" + this.getClassName(mgtMcf.getManagedConnectionFactory().getClass().getName());
                            HashSet<String> writeStatAttributes2 = new HashSet<String>();
                            writeStatAttributes2.add("Enabled");
                            HashSet<String> excludeStatAttributes2 = new HashSet<String>();
                            excludeStatAttributes2.add("Names");
                            HashSet<String> excludeStatOperations2 = new HashSet<String>();
                            excludeStatOperations2.add("delta(.)*");
                            DynamicMBean mcfSDMB = JMX.createMBean((Object)mgtMcf.getStatistics(), (String)"Managed connection factory statistics", writeStatAttributes2, null, excludeStatAttributes2, excludeStatOperations2);
                            ObjectName mcfSON = new ObjectName(mcfSName);
                            server.registerMBean(mcfSDMB, mcfSON);
                            ons.add(mcfSON);
                        }
                    }
                    if (mgtCf.getPoolConfiguration() != null) {
                        String mcfPCName = baseName + ",jndi=" + jndiName + ",type=ConnectionFactory,class=" + this.getClassName(mgtCf.getConnectionFactory().getClass().getName()) + ",subcategory=PoolConfiguration";
                        DynamicMBean mcfPCDMB = JMX.createMBean((Object)mgtCf.getPoolConfiguration(), (String)"Pool configuration");
                        ObjectName mcfPCON = new ObjectName(mcfPCName);
                        server.registerMBean(mcfPCDMB, mcfPCON);
                        ons.add(mcfPCON);
                    }
                    if (mgtCf.getPool() == null) continue;
                    String cfPName = baseName + ",jndi=" + jndiName + ",type=ConnectionFactory,class=" + this.getClassName(mgtCf.getConnectionFactory().getClass().getName()) + ",subcategory=Pool";
                    DynamicMBean cfPDMB = JMX.createMBean((Object)mgtCf.getPool(), (String)"Pool");
                    ObjectName cfPON = new ObjectName(cfPName);
                    server.registerMBean(cfPDMB, cfPON);
                    ons.add(cfPON);
                    if (mgtCf.getPool().getStatistics() == null) continue;
                    String cfPSName = baseName + ",jndi=" + jndiName + ",type=ConnectionFactory,class=" + this.getClassName(mgtCf.getConnectionFactory().getClass().getName()) + ",subcategory=PoolStatistics";
                    writeStatAttributes = new HashSet();
                    writeStatAttributes.add("Enabled");
                    excludeStatAttributes = new HashSet();
                    excludeStatAttributes.add("Names");
                    excludeStatOperations = new HashSet();
                    excludeStatOperations.add("delta(.)*");
                    DynamicMBean cfPSDMB = JMX.createMBean((Object)mgtCf.getPool().getStatistics(), (String)"Pool statistics", writeStatAttributes, null, excludeStatAttributes, excludeStatOperations);
                    ObjectName cfPSON = new ObjectName(cfPSName);
                    server.registerMBean(cfPSDMB, cfPSON);
                    ons.add(cfPSON);
                }
                for (AdminObject mgtAo : mgtConnector.getAdminObjects()) {
                    if (mgtAo.getAdminObject() == null) continue;
                    HashSet<String> writeable = new HashSet<String>();
                    HashSet<String> excludeAttributes = new HashSet<String>();
                    String jndiName = this.cleanJndiName(mgtAo.getJndiName());
                    for (org.jboss.jca.core.api.management.ConfigProperty mgtCp : mgtAo.getConfigProperties()) {
                        String mgtCpName = mgtCp.getName().substring(0, 1).toUpperCase(Locale.US);
                        if (mgtCp.getName().length() > 1) {
                            mgtCpName = mgtCpName + mgtCp.getName().substring(1);
                        }
                        if (mgtCp.isDynamic()) {
                            writeable.add(mgtCpName);
                        }
                        if (!mgtCp.isConfidential()) continue;
                        excludeAttributes.add(mgtCpName);
                    }
                    String aoName = baseName + ",jndi=" + jndiName + ",type=AdminObject,class=" + this.getClassName(mgtAo.getAdminObject().getClass().getName());
                    DynamicMBean aoDMB = JMX.createMBean((Object)mgtAo.getAdminObject(), (String)"Admin object", writeable, null, excludeAttributes, null);
                    ObjectName aoON = new ObjectName(aoName);
                    server.registerMBean(aoDMB, aoON);
                    ons.add(aoON);
                    if (mgtAo.getStatistics() == null) continue;
                    String aoSName = baseName + ",jndi=" + jndiName + ",type=AdminObjectStatistics,class=" + this.getClassName(mgtAo.getAdminObject().getClass().getName());
                    HashSet<String> writeStatAttributes3 = new HashSet<String>();
                    writeStatAttributes3.add("Enabled");
                    HashSet<String> excludeStatAttributes3 = new HashSet<String>();
                    excludeStatAttributes3.add("Names");
                    HashSet<String> excludeStatOperations3 = new HashSet<String>();
                    excludeStatOperations3.add("delta(.)*");
                    DynamicMBean aoSDMB = JMX.createMBean((Object)mgtAo.getStatistics(), (String)"Admin object statistics", writeStatAttributes3, null, excludeStatAttributes3, excludeStatOperations3);
                    ObjectName aoSON = new ObjectName(aoSName);
                    server.registerMBean(aoSDMB, aoSON);
                    ons.add(aoSON);
                }
            }
            this.log.debugf("Adding management connector: %s", (Object)mgtConnector);
            ((RAConfiguration)this.getConfiguration()).getManagementRepository().getConnectors().add(mgtConnector);
        }
        return ons;
    }

    private String getClassName(String clz) {
        if (clz.indexOf(".") != -1) {
            int lastIndex = clz.lastIndexOf(".");
            return clz.substring(lastIndex + 1);
        }
        return clz;
    }

    private String cleanJndiName(String jndi) {
        jndi = jndi.replace(':', '!');
        return jndi;
    }

    protected SubjectFactory getSubjectFactory(String securityDomain) throws DeployException {
        this.log.tracef("getSubjectFactory(%s)", (Object)securityDomain);
        if (securityDomain == null || securityDomain.trim().equals("")) {
            return null;
        }
        try {
            return (SubjectFactory)this.kernel.getBean(securityDomain, SubjectFactory.class);
        }
        catch (Throwable t) {
            throw new DeployException("Error during loookup of security domain: " + securityDomain, t);
        }
    }

    protected CachedConnectionManager getCachedConnectionManager() {
        return ((RAConfiguration)this.getConfiguration()).getCachedConnectionManager();
    }
}

