/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal.external;

import com.github.fungal.api.deployer.MainDeployer;
import com.github.fungal.api.remote.Command;
import java.io.Serializable;
import java.net.URL;
import org.jboss.jca.deployers.fungal.RAActivator;
import org.jboss.jca.deployers.fungal.external.LocalList;

public class LocalUndeploy
implements Command {
    private MainDeployer mainDeployer;
    private RAActivator activator;
    private LocalList localList;

    public LocalUndeploy(MainDeployer mainDeployer, RAActivator activator, LocalList localList) {
        this.mainDeployer = mainDeployer;
        this.activator = activator;
        this.localList = localList;
    }

    public String getName() {
        return "local-undeploy";
    }

    public Class[] getParameterTypes() {
        return new Class[]{URL.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable invoke(Serializable[] args) {
        boolean activatorEnabled = this.activator.isEnabled();
        try {
            if (args == null || args.length != 1) {
                throw new IllegalArgumentException("Invalid number of arguments");
            }
            if (!(args[0] instanceof URL)) {
                throw new IllegalArgumentException("First parameter isn't an URL");
            }
            this.activator.setEnabled(false);
            URL deployment = (URL)args[0];
            this.localList.removeDeployment(deployment);
            this.mainDeployer.undeploy(deployment);
        }
        catch (Throwable t) {
            Throwable throwable = t;
            return throwable;
        }
        finally {
            this.activator.setEnabled(activatorEnabled);
        }
        return Boolean.TRUE;
    }

    public boolean isPublic() {
        return true;
    }
}

