/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal.external;

import com.github.fungal.api.deployer.MainDeployer;
import com.github.fungal.api.remote.Command;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.jboss.jca.deployers.fungal.RAActivator;

public class RemoteUndeploy
implements Command {
    private MainDeployer mainDeployer;
    private RAActivator activator;
    private File directory;

    public RemoteUndeploy(MainDeployer mainDeployer, RAActivator activator, File directory) {
        this.mainDeployer = mainDeployer;
        this.activator = activator;
        this.directory = directory;
    }

    public String getName() {
        return "remote-undeploy";
    }

    public Class[] getParameterTypes() {
        return new Class[]{String.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable invoke(Serializable[] args) {
        boolean activatorEnabled = this.activator.isEnabled();
        try {
            if (args == null || args.length != 1) {
                throw new IllegalArgumentException("Invalid number of arguments");
            }
            if (!(args[0] instanceof String)) {
                throw new IllegalArgumentException("First parameter isn't a String");
            }
            String name = (String)((Object)args[0]);
            File deployment = new File(this.directory, name);
            this.activator.setEnabled(false);
            if (deployment.exists()) {
                this.mainDeployer.undeploy(deployment.toURI().toURL());
                if (!deployment.delete()) {
                    throw new IOException("Deployment couldn't be deleted");
                }
            }
        }
        catch (Throwable t) {
            Throwable throwable = t;
            return throwable;
        }
        finally {
            this.activator.setEnabled(activatorEnabled);
        }
        return Boolean.TRUE;
    }

    public boolean isPublic() {
        return true;
    }
}

