/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jca.deployers.DeployersLogger;
import org.jboss.logging.Logger;

public class DriverRegistry {
    private static DeployersLogger log = (DeployersLogger)Logger.getMessageLogger(DeployersLogger.class, (String)DriverRegistry.class.getName());
    private ClassLoader cl = null;
    private Map<String, String> driverMap = new HashMap<String, String>();

    public void setScanClassLoader(ClassLoader cl) {
        this.cl = cl;
    }

    public String getDriver(String module) {
        if (module == null) {
            return null;
        }
        return this.driverMap.get(module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Throwable {
        Enumeration<URL> drivers;
        if (this.cl != null && (drivers = this.cl.getResources("META-INF/services/java.sql.Driver")) != null) {
            while (drivers.hasMoreElements()) {
                URL driver = null;
                InputStream is = null;
                try {
                    driver = drivers.nextElement();
                    is = driver.openStream();
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    int i = is.read();
                    while (i != -1) {
                        bos.write((byte)i);
                        i = is.read();
                    }
                    String driverClass = bos.toString();
                    String module = driver.toExternalForm();
                    module = module.substring(0, module.indexOf("!"));
                    module = module.substring(module.lastIndexOf("/") + 1);
                    log.debugf("Driver class: %s Module: %s", (Object)driverClass, (Object)module);
                    this.driverMap.put(module, driverClass);
                }
                catch (Throwable t) {
                    log.debugf(t, "Exception for driver: %s", (Object)driver);
                }
                finally {
                    if (is == null) continue;
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
    }
}

