/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import com.github.fungal.api.classloading.ClassLoaderFactory;
import com.github.fungal.api.classloading.KernelClassLoader;
import com.github.fungal.api.util.FileUtil;
import com.github.fungal.spi.deployers.Context;
import com.github.fungal.spi.deployers.Deployer;
import com.github.fungal.spi.deployers.Deployment;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import javax.management.ObjectName;
import org.jboss.jca.common.annotations.Annotations;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.spec.AdminObject;
import org.jboss.jca.common.api.metadata.spec.Connector;
import org.jboss.jca.common.api.metadata.spec.ResourceAdapter;
import org.jboss.jca.common.metadata.MetadataFactory;
import org.jboss.jca.common.metadata.merge.Merger;
import org.jboss.jca.common.spi.annotations.repository.AnnotationRepository;
import org.jboss.jca.common.spi.annotations.repository.AnnotationScanner;
import org.jboss.jca.common.spi.annotations.repository.AnnotationScannerFactory;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.naming.JndiStrategy;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.deployers.DeployersLogger;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.DeployException;
import org.jboss.jca.deployers.fungal.AbstractFungalRADeployer;
import org.jboss.jca.deployers.fungal.RAConfiguration;
import org.jboss.jca.deployers.fungal.RADeployment;
import org.jboss.jca.deployers.fungal.SecurityActions;
import org.jboss.logging.Logger;

public final class RADeployer
extends AbstractFungalRADeployer
implements Deployer {
    private static DeployersLogger log = (DeployersLogger)Logger.getMessageLogger(DeployersLogger.class, (String)RADeployer.class.getName());

    public RADeployer() {
        super(true);
    }

    protected DeployersLogger getLogger() {
        return log;
    }

    public boolean accepts(URL url) {
        return url != null && (url.toExternalForm().endsWith(".rar") || url.toExternalForm().endsWith(".rar/"));
    }

    public int getOrder() {
        return 0;
    }

    public synchronized Deployment deploy(URL url, Context context, ClassLoader parent) throws com.github.fungal.spi.deployers.DeployException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deploying: " + url.toExternalForm()));
        }
        ClassLoader oldTCCL = SecurityActions.getThreadContextClassLoader();
        try {
            File f = new File(url.toURI());
            if (!f.exists()) {
                throw new IOException("Archive " + url.toExternalForm() + " doesnt exists");
            }
            File root = null;
            File destination = null;
            if (f.isFile()) {
                FileUtil fileUtil = new FileUtil();
                destination = new File(SecurityActions.getSystemProperty("iron.jacamar.home"), "/tmp/");
                root = fileUtil.extract(f, destination);
            } else {
                root = f;
            }
            String deploymentName = f.getName().substring(0, f.getName().indexOf(".rar"));
            URL[] urls = this.getUrls(root);
            KernelClassLoader cl = null;
            cl = ((RAConfiguration)this.getConfiguration()).getScopeDeployment() ? ClassLoaderFactory.create((int)1, (URL[])urls, (ClassLoader)parent) : ClassLoaderFactory.create((int)0, (URL[])urls, (ClassLoader)parent);
            SecurityActions.setThreadContextClassLoader((ClassLoader)cl);
            MetadataFactory metadataFactory = new MetadataFactory();
            Connector cmd = metadataFactory.getStandardMetaData(root);
            Activation activation = metadataFactory.getIronJacamarMetaData(root);
            if (this.scanArchive(cmd)) {
                Annotations annotator = new Annotations();
                AnnotationScanner scanner = AnnotationScannerFactory.getAnnotationScanner();
                AnnotationRepository repository = scanner.scan(cl.getURLs(), (ClassLoader)cl);
                cmd = annotator.merge(cmd, repository, (ClassLoader)cl);
            }
            cmd.validate();
            cmd = new Merger().mergeConnectorWithCommonIronJacamar(activation, cmd);
            CommonDeployment c = this.createObjectsAndInjectValue(url, deploymentName, root, (ClassLoader)cl, cmd, activation);
            List<ObjectName> ons = null;
            if (c.isActivateDeployment()) {
                ons = this.registerManagementView(c.getConnector(), this.kernel.getMBeanServer(), this.kernel.getName());
            }
            JndiStrategy jndiStrategy = ((RAConfiguration)this.getConfiguration()).getJndiStrategy();
            MetadataRepository metadataRepository = ((RAConfiguration)this.getConfiguration()).getMetadataRepository();
            ResourceAdapterRepository resourceAdapterRepository = ((RAConfiguration)this.getConfiguration()).getResourceAdapterRepository();
            RADeployment rADeployment = new RADeployment(c.getURL(), c.getDeploymentName(), c.isActivateDeployment(), c.getResourceAdapter(), c.getResourceAdapterKey(), c.getBootstrapContextIdentifier(), jndiStrategy, metadataRepository, resourceAdapterRepository, c.getCfs(), c.getCfJndiNames(), c.getConnectionManagers(), c.getAos(), c.getAoJndiNames(), c.getRecovery(), this.getTransactionIntegration().getRecoveryRegistry(), destination, ((RAConfiguration)this.getConfiguration()).getManagementRepository(), c.getConnector(), this.kernel.getMBeanServer(), ons, cl, c.getLog());
            return rADeployment;
        }
        catch (com.github.fungal.spi.deployers.DeployException de) {
            throw de;
        }
        catch (DeployException cde) {
            throw new com.github.fungal.spi.deployers.DeployException(cde.getMessage(), cde.getCause());
        }
        catch (Throwable t) {
            throw new com.github.fungal.spi.deployers.DeployException("Deployment " + url.toExternalForm() + " failed", t);
        }
        finally {
            SecurityActions.setThreadContextClassLoader(oldTCCL);
        }
    }

    protected boolean checkActivation(Connector cmd, Activation activation) {
        if (cmd != null) {
            List aoMetas;
            List cdMetas;
            HashSet<String> raMcfClasses = new HashSet<String>();
            HashSet<String> raAoClasses = new HashSet<String>();
            ResourceAdapter ra = cmd.getResourceadapter();
            if (ra != null && ra.getOutboundResourceadapter() != null && ra.getOutboundResourceadapter().getConnectionDefinitions() != null && (cdMetas = ra.getOutboundResourceadapter().getConnectionDefinitions()).size() > 0) {
                for (org.jboss.jca.common.api.metadata.spec.ConnectionDefinition cdMeta : cdMetas) {
                    raMcfClasses.add(cdMeta.getManagedConnectionFactoryClass().getValue());
                }
            }
            if (ra != null && ra.getAdminObjects() != null && (aoMetas = ra.getAdminObjects()).size() > 0) {
                for (AdminObject aoMeta : aoMetas) {
                    raAoClasses.add(aoMeta.getAdminobjectClass().getValue());
                }
            }
            if (raMcfClasses.size() == 0 && raAoClasses.size() == 0) {
                return true;
            }
            if (activation != null) {
                String clz;
                if (activation.getConnectionDefinitions() != null) {
                    for (ConnectionDefinition def : activation.getConnectionDefinitions()) {
                        clz = def.getClassName();
                        if (!raMcfClasses.contains(clz)) continue;
                        return true;
                    }
                    if (raMcfClasses.size() == 1 && activation.getConnectionDefinitions().size() == 1) {
                        return true;
                    }
                }
                if (activation.getAdminObjects() != null) {
                    for (ConnectionDefinition def : activation.getAdminObjects()) {
                        clz = def.getClassName();
                        if (!raAoClasses.contains(clz)) continue;
                        return true;
                    }
                    if (raAoClasses.size() == 1 && activation.getAdminObjects().size() == 1) {
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

