/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal.external;

import com.github.fungal.api.Kernel;
import com.github.fungal.api.deployer.MainDeployer;
import com.github.fungal.api.remote.Command;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import org.jboss.jca.deployers.fungal.RAActivator;
import org.jboss.jca.deployers.fungal.external.LocalList;

public class LocalDeploy
implements Command {
    private Kernel kernel;
    private MainDeployer mainDeployer;
    private RAActivator activator;
    private LocalList localList;

    public LocalDeploy(Kernel kernel, MainDeployer mainDeployer, RAActivator activator, LocalList localList) {
        this.kernel = kernel;
        this.mainDeployer = mainDeployer;
        this.activator = activator;
        this.localList = localList;
    }

    public String getName() {
        return "local-deploy";
    }

    public Class[] getParameterTypes() {
        return new Class[]{URL.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable invoke(Serializable[] args) {
        boolean activatorEnabled = this.activator.isEnabled();
        try {
            if (args == null || args.length != 1) {
                throw new IllegalArgumentException("Invalid number of arguments");
            }
            if (!(args[0] instanceof URL)) {
                throw new IllegalArgumentException("First parameter isn't an URL");
            }
            URL deployment = (URL)args[0];
            this.activator.setEnabled(false);
            List l = this.kernel.getDeployments(deployment);
            if (l != null && l.size() > 0) {
                this.localList.removeDeployment(deployment);
                this.mainDeployer.undeploy(deployment);
            }
            this.mainDeployer.deploy(deployment);
            this.localList.addDeployment(deployment);
        }
        catch (Throwable t) {
            Throwable throwable = t;
            return throwable;
        }
        finally {
            this.activator.setEnabled(activatorEnabled);
        }
        return Boolean.TRUE;
    }

    public boolean isPublic() {
        return true;
    }
}

