/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import com.github.fungal.api.classloading.KernelClassLoader;
import com.github.fungal.spi.deployers.Deployment;
import jakarta.resource.spi.ResourceAdapter;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.jca.core.api.management.Connector;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.bootstrapcontext.BootstrapContextCoordinator;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.mdr.NotFoundException;
import org.jboss.jca.core.spi.naming.JndiStrategy;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.core.spi.transaction.recovery.XAResourceRecovery;
import org.jboss.jca.core.spi.transaction.recovery.XAResourceRecoveryRegistry;
import org.jboss.jca.deployers.DeployersLogger;

public abstract class AbstractFungalDeployment
implements Deployment {
    protected DeployersLogger log;
    protected URL deployment;
    protected String deploymentName;
    protected boolean activator;
    protected ResourceAdapter ra;
    protected String raKey;
    protected String bootstrapContextId;
    protected JndiStrategy jndiStrategy;
    protected MetadataRepository mdr;
    protected ResourceAdapterRepository rar;
    protected Object[] cfs;
    protected String[] cfJndis;
    protected ConnectionManager[] cfCMs;
    protected Object[] aos;
    protected String[] aoJndis;
    protected XAResourceRecovery[] recoveryModules;
    protected XAResourceRecoveryRegistry recoveryRegistry;
    protected ManagementRepository managementRepository;
    protected Connector connector;
    protected MBeanServer server;
    protected List<ObjectName> objectNames;
    protected KernelClassLoader cl;

    public AbstractFungalDeployment(URL deployment, String deploymentName, boolean activator, ResourceAdapter ra, String raKey, String bootstrapContextId, JndiStrategy jndiStrategy, MetadataRepository metadataRepository, ResourceAdapterRepository resourceAdapterRepository, Object[] cfs, String[] cfJndis, ConnectionManager[] cfCMs, Object[] aos, String[] aoJndis, XAResourceRecovery[] recoveryModules, XAResourceRecoveryRegistry recoveryRegistry, ManagementRepository managementRepository, Connector connector, MBeanServer server, List<ObjectName> objectNames, KernelClassLoader cl, DeployersLogger log) {
        this.deployment = deployment;
        this.deploymentName = deploymentName;
        this.activator = activator;
        this.ra = ra;
        this.raKey = raKey;
        this.bootstrapContextId = bootstrapContextId;
        this.jndiStrategy = jndiStrategy;
        this.mdr = metadataRepository;
        this.rar = resourceAdapterRepository;
        this.cfs = cfs;
        this.cfJndis = cfJndis;
        this.cfCMs = cfCMs;
        this.aos = aos;
        this.aoJndis = aoJndis;
        this.recoveryModules = recoveryModules;
        this.recoveryRegistry = recoveryRegistry;
        this.managementRepository = managementRepository;
        this.connector = connector;
        this.server = server;
        this.objectNames = objectNames;
        this.cl = cl;
        this.log = log;
    }

    public URL getURL() {
        return this.deployment;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.activator) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Undeploying: " + this.deployment.toExternalForm()));
            }
            if (this.server != null && this.objectNames != null) {
                for (ObjectName on : this.objectNames) {
                    try {
                        this.server.unregisterMBean(on);
                    }
                    catch (Throwable t) {
                        this.log.warn((Object)"Exception during unregistering deployment", t);
                    }
                }
            }
            if (this.recoveryRegistry != null && this.recoveryModules != null) {
                for (XAResourceRecovery recovery : this.recoveryModules) {
                    if (recovery == null) continue;
                    try {
                        recovery.shutdown();
                    }
                    catch (Exception e) {
                        this.log.error((Object)"Error during recovery shutdown", (Throwable)e);
                    }
                    finally {
                        this.recoveryRegistry.removeXAResourceRecovery(recovery);
                    }
                }
            }
            if (this.managementRepository != null && this.connector != null) {
                this.managementRepository.getConnectors().remove(this.connector);
            }
            if (this.mdr != null && this.cfs != null && this.cfJndis != null) {
                for (int i = 0; i < this.cfs.length; ++i) {
                    try {
                        String cf = this.cfs[i].getClass().getName();
                        String jndi = this.cfJndis[i];
                        this.mdr.unregisterJndiMapping(this.deployment.toExternalForm(), cf, jndi);
                        continue;
                    }
                    catch (NotFoundException nfe) {
                        this.log.warn((Object)"Exception during unregistering deployment", (Throwable)nfe);
                    }
                }
            }
            if (this.mdr != null && this.aos != null && this.aoJndis != null) {
                for (int i = 0; i < this.aos.length; ++i) {
                    try {
                        String ao = this.aos[i].getClass().getName();
                        String jndi = this.aoJndis[i];
                        this.mdr.unregisterJndiMapping(this.deployment.toExternalForm(), ao, jndi);
                        continue;
                    }
                    catch (NotFoundException nfe) {
                        this.log.warn((Object)"Exception during unregistering deployment", (Throwable)nfe);
                    }
                }
            }
            if (this.cfCMs != null) {
                for (ConnectionManager cm : this.cfCMs) {
                    cm.shutdown();
                }
            }
            if (this.cfs != null && this.cfJndis != null) {
                try {
                    this.jndiStrategy.unbindConnectionFactories(this.deploymentName, this.cfs, this.cfJndis);
                    for (String jndi : this.cfJndis) {
                        this.log.infof("Unbound connection factory at: %s", (Object)jndi);
                    }
                }
                catch (Throwable t) {
                    this.log.warn((Object)"Exception during JNDI unbinding", t);
                }
            }
            if (this.aos != null && this.aoJndis != null) {
                try {
                    this.jndiStrategy.unbindAdminObjects(this.deploymentName, this.aos, this.aoJndis);
                    for (String jndi : this.aoJndis) {
                        this.log.infof("Unbound admin object at: %s", (Object)jndi);
                    }
                }
                catch (Throwable t) {
                    this.log.warn((Object)"Exception during JNDI unbinding", t);
                }
            }
            if (this.raKey != null && this.rar != null) {
                try {
                    this.rar.unregisterResourceAdapter(this.raKey);
                }
                catch (org.jboss.jca.core.spi.rar.NotFoundException nfe) {
                    this.log.warn((Object)"Exception during unregistering deployment", (Throwable)nfe);
                }
            }
            if (this.ra != null) {
                this.ra.stop();
                this.ra = null;
                BootstrapContextCoordinator.getInstance().removeBootstrapContext(this.bootstrapContextId);
            }
        }
    }

    public void destroy() {
        if (this.activator) {
            this.log.info((Object)("Undeployed: " + this.deployment.toExternalForm()));
        }
        if (this.cl != null) {
            try {
                this.cl.shutdown();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

