/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.embedded.arquillian;

import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.jca.embedded.Embedded;
import org.jboss.jca.embedded.EmbeddedFactory;
import org.jboss.jca.embedded.arquillian.EmbeddedJCAContainerConfiguration;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public class EmbeddedJCAContainer
implements DeployableContainer<EmbeddedJCAContainerConfiguration> {
    private Embedded embedded = null;
    @Inject
    @ContainerScoped
    private InstanceProducer<Context> contextProducer;
    @Inject
    @ContainerScoped
    private InstanceProducer<Embedded> embeddedProducer;

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Local");
    }

    public Class<EmbeddedJCAContainerConfiguration> getConfigurationClass() {
        return EmbeddedJCAContainerConfiguration.class;
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        if (descriptor == null) {
            throw new DeploymentException("Could not deploy a null descriptor");
        }
        try {
            this.embedded.deploy(descriptor);
        }
        catch (Throwable t) {
            throw new DeploymentException("Could not undeploy the application: " + t.getMessage(), t);
        }
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        if (descriptor == null) {
            throw new DeploymentException("Could not undeploy a null application");
        }
        try {
            this.embedded.undeploy(descriptor);
        }
        catch (Throwable t) {
            throw new DeploymentException("Could not undeploy the application: " + t.getMessage(), t);
        }
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        if (archive == null) {
            throw new DeploymentException("Could not deploy a null application");
        }
        if (!ResourceAdapterArchive.class.isInstance(archive)) {
            throw new DeploymentException("Could not deploy a non resource adapter application");
        }
        try {
            this.embedded.deploy((ResourceAdapterArchive)ResourceAdapterArchive.class.cast(archive));
        }
        catch (Throwable t) {
            throw new DeploymentException("Could not deploy the application: " + t.getMessage(), t);
        }
        return new ProtocolMetaData();
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        if (archive == null) {
            throw new DeploymentException("Could not undeploy a null application");
        }
        if (!ResourceAdapterArchive.class.isInstance(archive)) {
            throw new DeploymentException("Could not undeploy a non resource adapter application");
        }
        try {
            this.embedded.undeploy((ResourceAdapterArchive)ResourceAdapterArchive.class.cast(archive));
        }
        catch (Throwable t) {
            throw new DeploymentException("Could not undeploy the application: " + t.getMessage(), t);
        }
    }

    public void setup(EmbeddedJCAContainerConfiguration configuration) {
    }

    public void start() throws LifecycleException {
        this.embedded = EmbeddedFactory.create((boolean)true);
        try {
            this.embedded.startup();
            this.contextProducer.set((Object)this.createContext());
            this.embeddedProducer.set((Object)this.embedded);
        }
        catch (Throwable t) {
            throw new LifecycleException("Could not start the EmbeddedJCA container: " + t.getMessage(), t);
        }
    }

    public void stop() throws LifecycleException {
        try {
            this.embedded.shutdown();
        }
        catch (Throwable t) {
            throw new LifecycleException("Could not stop the EmbeddedJCA container: " + t.getMessage(), t);
        }
        this.embedded = null;
    }

    protected InitialContext createContext() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("java.naming.factory.initial", "org.jnp.interfaces.LocalOnlyContextFactory");
        properties.setProperty("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
        return new InitialContext(properties);
    }
}

