package org.jboss.jca.embedded.dsl.datasources10.api; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.jca.embedded.dsl.datasources10.api.ExtensionType;
import org.jboss.jca.embedded.dsl.datasources10.api.ExtensionType;
import org.jboss.jca.embedded.dsl.datasources10.api.ExtensionType;
/**
 * This interface defines the contract for the <code> validationType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 * @since Generation date :2012-09-06T10:33:27.493-04:00
 */
public interface ValidationType<T> extends Child<T>
{
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ValidationType ElementName: datasources:extensionType ElementType : valid-connection-checker
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>valid-connection-checker</code> element with the given value will be created.
    * Otherwise, the existing <code>valid-connection-checker</code> element will be returned.
    * @return  a new or existing instance of <code>ExtensionType<ValidationType<T>></code> 
    */
   public ExtensionType<ValidationType<T>> getOrCreateValidConnectionChecker();

   /**
    * Removes the <code>valid-connection-checker</code> element 
    * @return the current instance of <code>ValidationType<T></code> 
    */
   public ValidationType<T> removeValidConnectionChecker();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ValidationType ElementName: xsd:string ElementType : check-valid-connection-sql
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>check-valid-connection-sql</code> element
    * @param checkValidConnectionSql the value for the element <code>check-valid-connection-sql</code> 
    * @return the current instance of <code>ValidationType<T></code> 
    */
   public ValidationType<T> checkValidConnectionSql(String checkValidConnectionSql);

   /**
    * Returns the <code>check-valid-connection-sql</code> element
    * @return the node defined for the element <code>check-valid-connection-sql</code> 
    */
   public String getCheckValidConnectionSql();

   /**
    * Removes the <code>check-valid-connection-sql</code> element 
    * @return the current instance of <code>ValidationType<T></code> 
    */
   public ValidationType<T> removeCheckValidConnectionSql();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ValidationType ElementName: xsd:boolean ElementType : validate-on-match
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>validate-on-match</code> element
    * @param validateOnMatch the value for the element <code>validate-on-match</code> 
    * @return the current instance of <code>ValidationType<T></code> 
    */
   public ValidationType<T> validateOnMatch(Boolean validateOnMatch);

   /**
    * Returns the <code>validate-on-match</code> element
    * @return the node defined for the element <code>validate-on-match</code> 
    */
   public Boolean isValidateOnMatch();

   /**
    * Removes the <code>validate-on-match</code> element 
    * @return the current instance of <code>ValidationType<T></code> 
    */
   public ValidationType<T> removeValidateOnMatch();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ValidationType ElementName: xsd:boolean ElementType : background-validation
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>background-validation</code> element
    * @param backgroundValidation the value for the element <code>background-validation</code> 
    * @return the current instance of <code>ValidationType<T></code> 
    */
   public ValidationType<T> backgroundValidation(Boolean backgroundValidation);

   /**
    * Returns the <code>background-validation</code> element
    * @return the node defined for the element <code>background-validation</code> 
    */
   public Boolean isBackgroundValidation();

   /**
    * Removes the <code>background-validation</code> element 
    * @return the current instance of <code>ValidationType<T></code> 
    */
   public ValidationType<T> removeBackgroundValidation();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ValidationType ElementName: xsd:nonNegativeInteger ElementType : background-validation-millis
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>background-validation-millis</code> element
    * @param backgroundValidationMillis the value for the element <code>background-validation-millis</code> 
    * @return the current instance of <code>ValidationType<T></code> 
    */
   public ValidationType<T> backgroundValidationMillis(Integer backgroundValidationMillis);

   /**
    * Returns the <code>background-validation-millis</code> element
    * @return the node defined for the element <code>background-validation-millis</code> 
    */
   public Integer getBackgroundValidationMillis();

   /**
    * Removes the <code>background-validation-millis</code> element 
    * @return the current instance of <code>ValidationType<T></code> 
    */
   public ValidationType<T> removeBackgroundValidationMillis();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ValidationType ElementName: xsd:boolean ElementType : use-fast-fail
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>use-fast-fail</code> element
    * @param useFastFail the value for the element <code>use-fast-fail</code> 
    * @return the current instance of <code>ValidationType<T></code> 
    */
   public ValidationType<T> useFastFail(Boolean useFastFail);

   /**
    * Returns the <code>use-fast-fail</code> element
    * @return the node defined for the element <code>use-fast-fail</code> 
    */
   public Boolean isUseFastFail();

   /**
    * Removes the <code>use-fast-fail</code> element 
    * @return the current instance of <code>ValidationType<T></code> 
    */
   public ValidationType<T> removeUseFastFail();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ValidationType ElementName: datasources:extensionType ElementType : stale-connection-checker
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>stale-connection-checker</code> element with the given value will be created.
    * Otherwise, the existing <code>stale-connection-checker</code> element will be returned.
    * @return  a new or existing instance of <code>ExtensionType<ValidationType<T>></code> 
    */
   public ExtensionType<ValidationType<T>> getOrCreateStaleConnectionChecker();

   /**
    * Removes the <code>stale-connection-checker</code> element 
    * @return the current instance of <code>ValidationType<T></code> 
    */
   public ValidationType<T> removeStaleConnectionChecker();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ValidationType ElementName: datasources:extensionType ElementType : exception-sorter
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exception-sorter</code> element with the given value will be created.
    * Otherwise, the existing <code>exception-sorter</code> element will be returned.
    * @return  a new or existing instance of <code>ExtensionType<ValidationType<T>></code> 
    */
   public ExtensionType<ValidationType<T>> getOrCreateExceptionSorter();

   /**
    * Removes the <code>exception-sorter</code> element 
    * @return the current instance of <code>ValidationType<T></code> 
    */
   public ValidationType<T> removeExceptionSorter();
}
