package org.jboss.jca.embedded.dsl.resourceadapters11.impl; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.jca.embedded.dsl.resourceadapters11.api.ConnectionDefinitionType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.jca.embedded.dsl.resourceadapters11.api.ConfigPropertyType;
import org.jboss.jca.embedded.dsl.resourceadapters11.impl.ConfigPropertyTypeImpl;
import org.jboss.jca.embedded.dsl.resourceadapters11.api.PoolType;
import org.jboss.jca.embedded.dsl.resourceadapters11.impl.PoolTypeImpl;
import org.jboss.jca.embedded.dsl.resourceadapters11.api.XaPoolType;
import org.jboss.jca.embedded.dsl.resourceadapters11.impl.XaPoolTypeImpl;
import org.jboss.jca.embedded.dsl.resourceadapters11.api.SecurityType;
import org.jboss.jca.embedded.dsl.resourceadapters11.impl.SecurityTypeImpl;
import org.jboss.jca.embedded.dsl.resourceadapters11.api.TimeoutType;
import org.jboss.jca.embedded.dsl.resourceadapters11.impl.TimeoutTypeImpl;
import org.jboss.jca.embedded.dsl.resourceadapters11.api.ValidationType;
import org.jboss.jca.embedded.dsl.resourceadapters11.impl.ValidationTypeImpl;
import org.jboss.jca.embedded.dsl.resourceadapters11.api.RecoverType;
import org.jboss.jca.embedded.dsl.resourceadapters11.impl.RecoverTypeImpl;

/**
 * This class implements the <code> connection-definitionType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 * @since Generation date :2012-09-06T10:33:26.594-04:00
 */
public class ConnectionDefinitionTypeImpl<T> implements Child<T>, ConnectionDefinitionType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public ConnectionDefinitionTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public ConnectionDefinitionTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConnectionDefinitionType ElementName: xsd:token ElementType : class-name
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>class-name</code> attribute
    * @param className the value for the attribute <code>class-name</code> 
    * @return the current instance of <code>ConnectionDefinitionType<T></code> 
    */
   public ConnectionDefinitionType<T> className(String className)
   {
      childNode.attribute("class-name", className);
      return this;
   }

   /**
    * Returns the <code>class-name</code> attribute
    * @return the value defined for the attribute <code>class-name</code> 
    */
      public String getClassName()
   {
      return childNode.getAttribute("class-name");
   }

   /**
    * Removes the <code>class-name</code> attribute 
    * @return the current instance of <code>ConnectionDefinitionType<T></code> 
    */
   public ConnectionDefinitionType<T> removeClassName()
   {
      childNode.removeAttribute("class-name");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConnectionDefinitionType ElementName: xsd:token ElementType : jndi-name
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>jndi-name</code> attribute
    * @param jndiName the value for the attribute <code>jndi-name</code> 
    * @return the current instance of <code>ConnectionDefinitionType<T></code> 
    */
   public ConnectionDefinitionType<T> jndiName(String jndiName)
   {
      childNode.attribute("jndi-name", jndiName);
      return this;
   }

   /**
    * Returns the <code>jndi-name</code> attribute
    * @return the value defined for the attribute <code>jndi-name</code> 
    */
      public String getJndiName()
   {
      return childNode.getAttribute("jndi-name");
   }

   /**
    * Removes the <code>jndi-name</code> attribute 
    * @return the current instance of <code>ConnectionDefinitionType<T></code> 
    */
   public ConnectionDefinitionType<T> removeJndiName()
   {
      childNode.removeAttribute("jndi-name");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConnectionDefinitionType ElementName: xsd:boolean ElementType : enabled
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>enabled</code> attribute
    * @param enabled the value for the attribute <code>enabled</code> 
    * @return the current instance of <code>ConnectionDefinitionType<T></code> 
    */
   public ConnectionDefinitionType<T> enabled(Boolean enabled)
   {
      childNode.attribute("enabled", enabled);
      return this;
   }

   /**
    * Returns the <code>enabled</code> attribute
    * @return the value defined for the attribute <code>enabled</code> 
    */
   public Boolean isEnabled()
   {
      return Strings.isTrue(childNode.getAttribute("enabled"));
   }

   /**
    * Removes the <code>enabled</code> attribute 
    * @return the current instance of <code>ConnectionDefinitionType<T></code> 
    */
   public ConnectionDefinitionType<T> removeEnabled()
   {
      childNode.removeAttribute("enabled");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConnectionDefinitionType ElementName: xsd:boolean ElementType : use-java-context
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>use-java-context</code> attribute
    * @param useJavaContext the value for the attribute <code>use-java-context</code> 
    * @return the current instance of <code>ConnectionDefinitionType<T></code> 
    */
   public ConnectionDefinitionType<T> useJavaContext(Boolean useJavaContext)
   {
      childNode.attribute("use-java-context", useJavaContext);
      return this;
   }

   /**
    * Returns the <code>use-java-context</code> attribute
    * @return the value defined for the attribute <code>use-java-context</code> 
    */
   public Boolean isUseJavaContext()
   {
      return Strings.isTrue(childNode.getAttribute("use-java-context"));
   }

   /**
    * Removes the <code>use-java-context</code> attribute 
    * @return the current instance of <code>ConnectionDefinitionType<T></code> 
    */
   public ConnectionDefinitionType<T> removeUseJavaContext()
   {
      childNode.removeAttribute("use-java-context");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConnectionDefinitionType ElementName: xsd:token ElementType : pool-name
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>pool-name</code> attribute
    * @param poolName the value for the attribute <code>pool-name</code> 
    * @return the current instance of <code>ConnectionDefinitionType<T></code> 
    */
   public ConnectionDefinitionType<T> poolName(String poolName)
   {
      childNode.attribute("pool-name", poolName);
      return this;
   }

   /**
    * Returns the <code>pool-name</code> attribute
    * @return the value defined for the attribute <code>pool-name</code> 
    */
      public String getPoolName()
   {
      return childNode.getAttribute("pool-name");
   }

   /**
    * Removes the <code>pool-name</code> attribute 
    * @return the current instance of <code>ConnectionDefinitionType<T></code> 
    */
   public ConnectionDefinitionType<T> removePoolName()
   {
      childNode.removeAttribute("pool-name");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConnectionDefinitionType ElementName: resource-adapters:config-propertyType ElementType : config-property
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>config-property</code> element will be created and returned.
    * Otherwise, the first existing <code>config-property</code> element will be returned.
    * @return the instance defined for the element <code>config-property</code> 
    */
   public ConfigPropertyType<ConnectionDefinitionType<T>> getOrCreateConfigProperty()
   {
      List<Node> nodeList = childNode.get("config-property");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ConfigPropertyTypeImpl<ConnectionDefinitionType<T>>(this, "config-property", childNode, nodeList.get(0));
      }
      return createConfigProperty();
   }

   /**
    * Creates a new <code>config-property</code> element 
    * @return the new created instance of <code>ConfigPropertyType<ConnectionDefinitionType<T>></code> 
    */
   public ConfigPropertyType<ConnectionDefinitionType<T>> createConfigProperty()
   {
      return new ConfigPropertyTypeImpl<ConnectionDefinitionType<T>>(this, "config-property", childNode);
   }

   /**
    * Returns all <code>config-property</code> elements
    * @return list of <code>config-property</code> 
    */
   public List<ConfigPropertyType<ConnectionDefinitionType<T>>> getAllConfigProperty()
   {
      List<ConfigPropertyType<ConnectionDefinitionType<T>>> list = new ArrayList<ConfigPropertyType<ConnectionDefinitionType<T>>>();
      List<Node> nodeList = childNode.get("config-property");
      for(Node node: nodeList)
      {
         ConfigPropertyType<ConnectionDefinitionType<T>>  type = new ConfigPropertyTypeImpl<ConnectionDefinitionType<T>>(this, "config-property", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>config-property</code> elements 
    * @return the current instance of <code>ConfigPropertyType<ConnectionDefinitionType<T>></code> 
    */
   public ConnectionDefinitionType<T> removeAllConfigProperty()
   {
      childNode.removeChildren("config-property");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConnectionDefinitionType ElementName: resource-adapters:poolType ElementType : pool
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>pool</code> element with the given value will be created.
    * Otherwise, the existing <code>pool</code> element will be returned.
    * @return  a new or existing instance of <code>PoolType<ConnectionDefinitionType<T>></code> 
    */
   public PoolType<ConnectionDefinitionType<T>> getOrCreatePool()
   {
      Node node = childNode.getOrCreate("pool");
      PoolType<ConnectionDefinitionType<T>> pool = new PoolTypeImpl<ConnectionDefinitionType<T>>(this, "pool", childNode, node);
      return pool;
   }

   /**
    * Removes the <code>pool</code> element 
    * @return the current instance of <code>ConnectionDefinitionType<T></code> 
    */
   public ConnectionDefinitionType<T> removePool()
   {
      childNode.removeChildren("pool");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConnectionDefinitionType ElementName: resource-adapters:xa-poolType ElementType : xa-pool
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>xa-pool</code> element with the given value will be created.
    * Otherwise, the existing <code>xa-pool</code> element will be returned.
    * @return  a new or existing instance of <code>XaPoolType<ConnectionDefinitionType<T>></code> 
    */
   public XaPoolType<ConnectionDefinitionType<T>> getOrCreateXaPool()
   {
      Node node = childNode.getOrCreate("xa-pool");
      XaPoolType<ConnectionDefinitionType<T>> xaPool = new XaPoolTypeImpl<ConnectionDefinitionType<T>>(this, "xa-pool", childNode, node);
      return xaPool;
   }

   /**
    * Removes the <code>xa-pool</code> element 
    * @return the current instance of <code>ConnectionDefinitionType<T></code> 
    */
   public ConnectionDefinitionType<T> removeXaPool()
   {
      childNode.removeChildren("xa-pool");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConnectionDefinitionType ElementName: resource-adapters:securityType ElementType : security
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>security</code> element with the given value will be created.
    * Otherwise, the existing <code>security</code> element will be returned.
    * @return  a new or existing instance of <code>SecurityType<ConnectionDefinitionType<T>></code> 
    */
   public SecurityType<ConnectionDefinitionType<T>> getOrCreateSecurity()
   {
      Node node = childNode.getOrCreate("security");
      SecurityType<ConnectionDefinitionType<T>> security = new SecurityTypeImpl<ConnectionDefinitionType<T>>(this, "security", childNode, node);
      return security;
   }

   /**
    * Removes the <code>security</code> element 
    * @return the current instance of <code>ConnectionDefinitionType<T></code> 
    */
   public ConnectionDefinitionType<T> removeSecurity()
   {
      childNode.removeChildren("security");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConnectionDefinitionType ElementName: resource-adapters:timeoutType ElementType : timeout
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>timeout</code> element with the given value will be created.
    * Otherwise, the existing <code>timeout</code> element will be returned.
    * @return  a new or existing instance of <code>TimeoutType<ConnectionDefinitionType<T>></code> 
    */
   public TimeoutType<ConnectionDefinitionType<T>> getOrCreateTimeout()
   {
      Node node = childNode.getOrCreate("timeout");
      TimeoutType<ConnectionDefinitionType<T>> timeout = new TimeoutTypeImpl<ConnectionDefinitionType<T>>(this, "timeout", childNode, node);
      return timeout;
   }

   /**
    * Removes the <code>timeout</code> element 
    * @return the current instance of <code>ConnectionDefinitionType<T></code> 
    */
   public ConnectionDefinitionType<T> removeTimeout()
   {
      childNode.removeChildren("timeout");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConnectionDefinitionType ElementName: resource-adapters:validationType ElementType : validation
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>validation</code> element with the given value will be created.
    * Otherwise, the existing <code>validation</code> element will be returned.
    * @return  a new or existing instance of <code>ValidationType<ConnectionDefinitionType<T>></code> 
    */
   public ValidationType<ConnectionDefinitionType<T>> getOrCreateValidation()
   {
      Node node = childNode.getOrCreate("validation");
      ValidationType<ConnectionDefinitionType<T>> validation = new ValidationTypeImpl<ConnectionDefinitionType<T>>(this, "validation", childNode, node);
      return validation;
   }

   /**
    * Removes the <code>validation</code> element 
    * @return the current instance of <code>ConnectionDefinitionType<T></code> 
    */
   public ConnectionDefinitionType<T> removeValidation()
   {
      childNode.removeChildren("validation");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConnectionDefinitionType ElementName: resource-adapters:recoverType ElementType : recovery
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>recovery</code> element with the given value will be created.
    * Otherwise, the existing <code>recovery</code> element will be returned.
    * @return  a new or existing instance of <code>RecoverType<ConnectionDefinitionType<T>></code> 
    */
   public RecoverType<ConnectionDefinitionType<T>> getOrCreateRecovery()
   {
      Node node = childNode.getOrCreate("recovery");
      RecoverType<ConnectionDefinitionType<T>> recovery = new RecoverTypeImpl<ConnectionDefinitionType<T>>(this, "recovery", childNode, node);
      return recovery;
   }

   /**
    * Removes the <code>recovery</code> element 
    * @return the current instance of <code>ConnectionDefinitionType<T></code> 
    */
   public ConnectionDefinitionType<T> removeRecovery()
   {
      childNode.removeChildren("recovery");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConnectionDefinitionType ElementName: xsd:boolean ElementType : use-ccm
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>use-ccm</code> attribute
    * @param useCcm the value for the attribute <code>use-ccm</code> 
    * @return the current instance of <code>ConnectionDefinitionType<T></code> 
    */
   public ConnectionDefinitionType<T> useCcm(Boolean useCcm)
   {
      childNode.attribute("use-ccm", useCcm);
      return this;
   }

   /**
    * Returns the <code>use-ccm</code> attribute
    * @return the value defined for the attribute <code>use-ccm</code> 
    */
   public Boolean isUseCcm()
   {
      return Strings.isTrue(childNode.getAttribute("use-ccm"));
   }

   /**
    * Removes the <code>use-ccm</code> attribute 
    * @return the current instance of <code>ConnectionDefinitionType<T></code> 
    */
   public ConnectionDefinitionType<T> removeUseCcm()
   {
      childNode.removeAttribute("use-ccm");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConnectionDefinitionType ElementName: xsd:boolean ElementType : sharable
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>sharable</code> attribute
    * @param sharable the value for the attribute <code>sharable</code> 
    * @return the current instance of <code>ConnectionDefinitionType<T></code> 
    */
   public ConnectionDefinitionType<T> sharable(Boolean sharable)
   {
      childNode.attribute("sharable", sharable);
      return this;
   }

   /**
    * Returns the <code>sharable</code> attribute
    * @return the value defined for the attribute <code>sharable</code> 
    */
   public Boolean isSharable()
   {
      return Strings.isTrue(childNode.getAttribute("sharable"));
   }

   /**
    * Removes the <code>sharable</code> attribute 
    * @return the current instance of <code>ConnectionDefinitionType<T></code> 
    */
   public ConnectionDefinitionType<T> removeSharable()
   {
      childNode.removeAttribute("sharable");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConnectionDefinitionType ElementName: xsd:boolean ElementType : enlistment
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>enlistment</code> attribute
    * @param enlistment the value for the attribute <code>enlistment</code> 
    * @return the current instance of <code>ConnectionDefinitionType<T></code> 
    */
   public ConnectionDefinitionType<T> enlistment(Boolean enlistment)
   {
      childNode.attribute("enlistment", enlistment);
      return this;
   }

   /**
    * Returns the <code>enlistment</code> attribute
    * @return the value defined for the attribute <code>enlistment</code> 
    */
   public Boolean isEnlistment()
   {
      return Strings.isTrue(childNode.getAttribute("enlistment"));
   }

   /**
    * Removes the <code>enlistment</code> attribute 
    * @return the current instance of <code>ConnectionDefinitionType<T></code> 
    */
   public ConnectionDefinitionType<T> removeEnlistment()
   {
      childNode.removeAttribute("enlistment");
      return this;
   }
}
