package org.jboss.jca.embedded.dsl.ironjacamar11.impl; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.jca.embedded.dsl.ironjacamar11.api.WorkmanagerSecurityMappingsGroupsType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.jca.embedded.dsl.ironjacamar11.api.WorkmanagerSecurityMappingType;
import org.jboss.jca.embedded.dsl.ironjacamar11.impl.WorkmanagerSecurityMappingTypeImpl;

/**
 * This class implements the <code> workmanagerSecurityMappingsGroupsType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 * @since Generation date :2012-11-28T09:44:14.251-05:00
 */
public class WorkmanagerSecurityMappingsGroupsTypeImpl<T> implements Child<T>, WorkmanagerSecurityMappingsGroupsType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public WorkmanagerSecurityMappingsGroupsTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public WorkmanagerSecurityMappingsGroupsTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WorkmanagerSecurityMappingsGroupsType ElementName: ironjacamar:workmanagerSecurityMappingType ElementType : map
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>map</code> element will be created and returned.
    * Otherwise, the first existing <code>map</code> element will be returned.
    * @return the instance defined for the element <code>map</code> 
    */
   public WorkmanagerSecurityMappingType<WorkmanagerSecurityMappingsGroupsType<T>> getOrCreateMap()
   {
      List<Node> nodeList = childNode.get("map");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new WorkmanagerSecurityMappingTypeImpl<WorkmanagerSecurityMappingsGroupsType<T>>(this, "map", childNode, nodeList.get(0));
      }
      return createMap();
   }

   /**
    * Creates a new <code>map</code> element 
    * @return the new created instance of <code>WorkmanagerSecurityMappingType<WorkmanagerSecurityMappingsGroupsType<T>></code> 
    */
   public WorkmanagerSecurityMappingType<WorkmanagerSecurityMappingsGroupsType<T>> createMap()
   {
      return new WorkmanagerSecurityMappingTypeImpl<WorkmanagerSecurityMappingsGroupsType<T>>(this, "map", childNode);
   }

   /**
    * Returns all <code>map</code> elements
    * @return list of <code>map</code> 
    */
   public List<WorkmanagerSecurityMappingType<WorkmanagerSecurityMappingsGroupsType<T>>> getAllMap()
   {
      List<WorkmanagerSecurityMappingType<WorkmanagerSecurityMappingsGroupsType<T>>> list = new ArrayList<WorkmanagerSecurityMappingType<WorkmanagerSecurityMappingsGroupsType<T>>>();
      List<Node> nodeList = childNode.get("map");
      for(Node node: nodeList)
      {
         WorkmanagerSecurityMappingType<WorkmanagerSecurityMappingsGroupsType<T>>  type = new WorkmanagerSecurityMappingTypeImpl<WorkmanagerSecurityMappingsGroupsType<T>>(this, "map", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>map</code> elements 
    * @return the current instance of <code>WorkmanagerSecurityMappingType<WorkmanagerSecurityMappingsGroupsType<T>></code> 
    */
   public WorkmanagerSecurityMappingsGroupsType<T> removeAllMap()
   {
      childNode.removeChildren("map");
      return this;
   }
}
