package org.jboss.jca.embedded.dsl.ironjacamar12.impl; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.jca.embedded.dsl.ironjacamar12.api.CapacityType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.jca.embedded.dsl.ironjacamar12.api.ExtensionType;
import org.jboss.jca.embedded.dsl.ironjacamar12.impl.ExtensionTypeImpl;
import org.jboss.jca.embedded.dsl.ironjacamar12.api.ExtensionType;
import org.jboss.jca.embedded.dsl.ironjacamar12.impl.ExtensionTypeImpl;

/**
 * This class implements the <code> capacityType </code> xsd type 
 */
public class CapacityTypeImpl<T> implements Child<T>, CapacityType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public CapacityTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public CapacityTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: CapacityType ElementName: ironjacamar:extensionType ElementType : incrementer
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>incrementer</code> element with the given value will be created.
    * Otherwise, the existing <code>incrementer</code> element will be returned.
    * @return  a new or existing instance of <code>ExtensionType<CapacityType<T>></code> 
    */
   public ExtensionType<CapacityType<T>> getOrCreateIncrementer()
   {
      Node node = childNode.getOrCreate("incrementer");
      ExtensionType<CapacityType<T>> incrementer = new ExtensionTypeImpl<CapacityType<T>>(this, "incrementer", childNode, node);
      return incrementer;
   }

   /**
    * Removes the <code>incrementer</code> element 
    * @return the current instance of <code>CapacityType<T></code> 
    */
   public CapacityType<T> removeIncrementer()
   {
      childNode.removeChildren("incrementer");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: CapacityType ElementName: ironjacamar:extensionType ElementType : decrementer
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>decrementer</code> element with the given value will be created.
    * Otherwise, the existing <code>decrementer</code> element will be returned.
    * @return  a new or existing instance of <code>ExtensionType<CapacityType<T>></code> 
    */
   public ExtensionType<CapacityType<T>> getOrCreateDecrementer()
   {
      Node node = childNode.getOrCreate("decrementer");
      ExtensionType<CapacityType<T>> decrementer = new ExtensionTypeImpl<CapacityType<T>>(this, "decrementer", childNode, node);
      return decrementer;
   }

   /**
    * Removes the <code>decrementer</code> element 
    * @return the current instance of <code>CapacityType<T></code> 
    */
   public CapacityType<T> removeDecrementer()
   {
      childNode.removeChildren("decrementer");
      return this;
   }
}
