/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc.xa;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.jboss.jca.adapters.jdbc.BaseWrapperManagedConnectionFactory;
import org.jboss.jca.adapters.jdbc.classloading.TCClassLoaderPlugin;
import org.jboss.jca.adapters.jdbc.spi.URLXASelectorStrategy;
import org.jboss.jca.adapters.jdbc.spi.XAData;
import org.jboss.jca.adapters.jdbc.util.Injection;
import org.jboss.jca.adapters.jdbc.xa.SecurityActions;
import org.jboss.jca.adapters.jdbc.xa.URLXASelector;
import org.jboss.jca.adapters.jdbc.xa.XAManagedConnection;

public class XAManagedConnectionFactory
extends BaseWrapperManagedConnectionFactory {
    private static final long serialVersionUID = 1647927657609573729L;
    private String xaDataSourceClass;
    private String xaDataSourceProperties;
    protected final Map<String, String> xaProps = Collections.synchronizedMap(new HashMap());
    private Boolean isSameRMOverrideValue;
    private transient XADataSource xads = null;
    private String urlProperty;
    private transient URLXASelectorStrategy xadsSelector = null;

    public String getURLProperty() {
        return this.urlProperty;
    }

    public void setURLProperty(String urlProperty) {
        this.urlProperty = urlProperty;
    }

    public String getXADataSourceClass() {
        return this.xaDataSourceClass;
    }

    public void setXADataSourceClass(String xaDataSourceClass) {
        this.xaDataSourceClass = xaDataSourceClass;
    }

    public String getXADataSourceProperties() {
        return this.xaDataSourceProperties;
    }

    public void setXADataSourceProperties(String xaDataSourceProperties) throws ResourceException {
        this.xaDataSourceProperties = xaDataSourceProperties;
        this.xaProps.clear();
        if (xaDataSourceProperties != null) {
            xaDataSourceProperties = xaDataSourceProperties.replaceAll("\\\\", "\\\\\\\\");
            xaDataSourceProperties = xaDataSourceProperties.replace(';', '\n');
            ByteArrayInputStream is = new ByteArrayInputStream(xaDataSourceProperties.getBytes());
            try {
                Properties p = new Properties();
                p.load(is);
                for (Map.Entry<Object, Object> entry : p.entrySet()) {
                    this.xaProps.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            catch (IOException ioe) {
                throw new ResourceException(bundle.unableToLoadConnectionProperties(), (Throwable)ioe);
            }
        }
    }

    public Boolean getIsSameRMOverrideValue() {
        return this.isSameRMOverrideValue;
    }

    public void setIsSameRMOverrideValue(Boolean isSameRMOverrideValue) {
        this.isSameRMOverrideValue = isSameRMOverrideValue;
    }

    private void initSelector() throws ResourceException {
        String urlsStr;
        if (this.urlProperty != null && !this.urlProperty.trim().equals("") && (urlsStr = this.xaProps.get(this.urlProperty)) != null && urlsStr.trim().length() > 0 && this.urlDelimiter != null && this.urlDelimiter.trim().length() > 0) {
            ArrayList<XAData> xaDataList = new ArrayList<XAData>(2);
            Properties xaPropsCopy = new Properties();
            for (Map.Entry<String, String> entry : this.xaProps.entrySet()) {
                xaPropsCopy.put(entry.getKey(), entry.getValue());
            }
            StringTokenizer st = new StringTokenizer(urlsStr, this.urlDelimiter);
            while (st.hasMoreTokens()) {
                String url = st.nextToken();
                xaPropsCopy.setProperty(this.urlProperty, url);
                XADataSource xads = this.createXaDataSource(xaPropsCopy);
                xaDataList.add(new XAData(xads, url));
                this.log.tracef("added XA HA connection url: %s", url);
            }
            if (this.getUrlSelectorStrategyClassName() == null) {
                this.xadsSelector = new URLXASelector();
                this.xadsSelector.init(xaDataList);
                this.log.debugf("Default URLXASelectorStrategy is being used : %s", this.xadsSelector);
            } else {
                this.xadsSelector = this.initUrlSelectorClass(this.getUrlSelectorStrategyClassName(), xaDataList);
                this.log.debugf("Customized URLXASelectorStrategy is being used : %s", this.xadsSelector);
            }
        }
    }

    private URLXASelectorStrategy initUrlSelectorClass(String className, List<XAData> xaDatas) {
        URLXASelectorStrategy result = null;
        if (className == null || className.trim().equals("")) {
            this.log.undefinedURLXASelectStrategy(this.getJndiName());
            return null;
        }
        Class<?> clz = null;
        try {
            clz = Class.forName(className, true, this.getClassLoaderPlugin().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clz == null) {
            try {
                clz = Class.forName(className, true, new TCClassLoaderPlugin().getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clz == null) {
            try {
                clz = Class.forName(className, true, SecurityActions.getClassLoader(XAManagedConnectionFactory.class));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clz == null) {
            this.log.errorURLXASelectStrategy(className, this.getJndiName());
            return null;
        }
        try {
            result = (URLXASelectorStrategy)clz.newInstance();
            Method init = clz.getMethod("init", List.class);
            init.invoke((Object)result, xaDatas);
        }
        catch (Throwable t) {
            this.log.errorURLXASelectStrategyExt(className, this.getJndiName(), t);
        }
        return result;
    }

    private XADataSource createXaDataSource(Properties p) throws ResourceException {
        if (this.getXADataSourceClass() == null) {
            throw new ResourceException(bundle.xaDatasourceClassNull());
        }
        XADataSource xads = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(this.getXADataSourceClass(), true, this.getClassLoaderPlugin().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(this.getXADataSourceClass(), true, new TCClassLoaderPlugin().getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(this.getXADataSourceClass(), true, SecurityActions.getClassLoader(XAManagedConnectionFactory.class));
            }
            catch (ClassNotFoundException cnfe) {
                throw new ResourceException(bundle.failedToLoadXADataSource(this.getXADataSourceClass()), (Throwable)cnfe);
            }
        }
        try {
            Injection injector = new Injection();
            xads = (XADataSource)clazz.newInstance();
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                injector.inject(xads, name, value);
            }
        }
        catch (Throwable t) {
            throw new ResourceException(bundle.failedToLoadXADataSource(this.getXADataSourceClass()), t);
        }
        return xads;
    }

    public ManagedConnection createManagedConnection(Subject subject, final ConnectionRequestInfo cri) throws ResourceException {
        if (this.urlProperty != null && !this.urlProperty.trim().equals("") && this.xadsSelector == null) {
            this.initSelector();
        }
        if (this.xadsSelector == null) {
            Subject copySubject;
            Subject subject2 = copySubject = subject != null ? SecurityActions.createSubject(false, subject) : null;
            if (copySubject != null) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<ManagedConnection>(){

                        @Override
                        public ManagedConnection run() throws PrivilegedActionException {
                            return Subject.doAs(copySubject, new PrivilegedExceptionAction<ManagedConnection>(){

                                @Override
                                public ManagedConnection run() throws ResourceException {
                                    return XAManagedConnectionFactory.this.getXAManagedConnection(copySubject, cri);
                                }
                            });
                        }
                    });
                }
                catch (PrivilegedActionException pe) {
                    if (pe.getException() instanceof PrivilegedActionException && ((PrivilegedActionException)pe.getException()).getException() instanceof ResourceException) {
                        throw (ResourceException)((Object)((PrivilegedActionException)pe.getException()).getException());
                    }
                    throw new ResourceException((Throwable)pe);
                }
            }
            return this.getXAManagedConnection(subject, cri);
        }
        while (this.xadsSelector.hasMore()) {
            Subject copySubject;
            XAData xaData = this.xadsSelector.active();
            this.log.tracef("Trying to create an XA connection to %s", xaData.getUrl());
            Subject subject3 = copySubject = subject != null ? SecurityActions.createSubject(false, subject) : null;
            if (copySubject != null) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<ManagedConnection>(){

                        @Override
                        public ManagedConnection run() throws PrivilegedActionException {
                            return Subject.doAs(copySubject, new PrivilegedExceptionAction<ManagedConnection>(){

                                @Override
                                public ManagedConnection run() throws ResourceException {
                                    return XAManagedConnectionFactory.this.getXAManagedConnection(copySubject, cri);
                                }
                            });
                        }
                    });
                }
                catch (PrivilegedActionException pe) {
                    this.log.errorCreatingXAConnection(xaData.getUrl(), pe.getException() instanceof PrivilegedActionException ? ((PrivilegedActionException)pe.getException()).getException() : pe.getException());
                    this.xadsSelector.fail(xaData);
                    continue;
                }
            }
            try {
                return this.getXAManagedConnection(subject, cri);
            }
            catch (ResourceException e) {
                this.log.errorCreatingXAConnection(xaData.getUrl(), e);
                this.xadsSelector.fail(xaData);
            }
        }
        this.xadsSelector.reset();
        throw new ResourceException(bundle.unableToCreateConnectionFromURL(this.xadsSelector.getData()));
    }

    public ManagedConnection getXAManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        PooledConnection xaConnection = null;
        Properties props = this.getConnectionProperties(null, subject, cri);
        try {
            String user = props.getProperty("user");
            String password = props.getProperty("password");
            xaConnection = user != null ? this.getXADataSource().getXAConnection(user, password) : this.getXADataSource().getXAConnection();
            return this.newXAManagedConnection(props, (XAConnection)xaConnection);
        }
        catch (Throwable e) {
            try {
                if (xaConnection != null) {
                    xaConnection.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new ResourceException(bundle.unableToCreateConnection(), e);
        }
    }

    protected ManagedConnection newXAManagedConnection(Properties props, XAConnection xaConnection) throws SQLException {
        return new XAManagedConnection(this, xaConnection, props, this.transactionIsolation, (int)this.preparedStatementCacheSize);
    }

    public ManagedConnection matchManagedConnections(Set mcs, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        Properties newProps = this.getConnectionProperties(null, subject, cri);
        for (Object o : mcs) {
            if (!(o instanceof XAManagedConnection)) continue;
            XAManagedConnection mc = (XAManagedConnection)o;
            if (Boolean.TRUE.equals(this.getReauthEnabled())) {
                return mc;
            }
            if (!mc.getProperties().equals(newProps)) continue;
            return mc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEqual(Map<String, String> other) {
        Map<String, String> map = this.xaProps;
        synchronized (map) {
            return this.xaProps.equals(other);
        }
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + (this.xaDataSourceClass == null ? 0 : this.xaDataSourceClass.hashCode());
        result = result * 37 + this.xaProps.hashCode();
        result = result * 37 + (this.userName == null ? 0 : this.userName.hashCode());
        result = result * 37 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 37 + this.transactionIsolation;
        return result;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        XAManagedConnectionFactory otherMcf = (XAManagedConnectionFactory)other;
        return this.xaDataSourceClass.equals(otherMcf.xaDataSourceClass) && this.isEqual(otherMcf.xaProps) && (this.userName == null ? otherMcf.userName == null : this.userName.equals(otherMcf.userName)) && (this.password == null ? otherMcf.password == null : this.password.equals(otherMcf.password)) && this.transactionIsolation == otherMcf.transactionIsolation;
    }

    protected synchronized XADataSource getXADataSource() throws ResourceException {
        if (this.xadsSelector != null) {
            XAData xada = this.xadsSelector.active();
            return xada.getXADataSource();
        }
        if (this.xads == null) {
            if (this.xaDataSourceClass == null) {
                throw new ResourceException(bundle.xaDatasourceClassNull());
            }
            try {
                Class<?> clazz = Class.forName(this.xaDataSourceClass, true, this.getClassLoaderPlugin().getClassLoader());
                this.xads = (XADataSource)clazz.newInstance();
                Injection injector = new Injection();
                for (Map.Entry<String, String> entry : this.xaProps.entrySet()) {
                    String name = entry.getKey();
                    String value = entry.getValue();
                    injector.inject(this.xads, name, value);
                }
            }
            catch (Throwable t) {
                throw new ResourceException(bundle.failedToLoadXADataSource(this.getXADataSourceClass()), t);
            }
        }
        return this.xads;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("XAManagedConnectionFactory@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[xaDataSourceClass=").append(this.xaDataSourceClass);
        sb.append(" xaProps=").append(Integer.toHexString(System.identityHashCode(this.xaProps)));
        sb.append(" userName=").append(this.userName);
        sb.append(" password=****");
        sb.append(" transactionIsolation=").append(this.transactionIsolation);
        sb.append("]");
        return sb.toString();
    }
}

