/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.util;

import com.icl.saxon.TransformerFactoryImpl;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.jboss.jdocbook.DocBookSchemaResolutionStrategy;
import org.jboss.jdocbook.JDocBookProcessException;
import org.jboss.jdocbook.util.FileUtils;
import org.jboss.jdocbook.util.NoOpWriter;
import org.jboss.jdocbook.xslt.EntityResolverChain;
import org.jboss.jdocbook.xslt.LocalDocBookSchemaResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XIncludeHelper {
    public static Set<File> locateInclusions(File root) {
        return XIncludeHelper.locateInclusions(root, DocBookSchemaResolutionStrategy.RNG);
    }

    public static Set<File> locateInclusions(File root, DocBookSchemaResolutionStrategy schemaResolutionStrategy) {
        final TreeSet<File> includes = new TreeSet<File>();
        EntityResolver entityResolver = new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (publicId == null && systemId != null && systemId.startsWith("file:/")) {
                    try {
                        includes.add(new File(new URL(systemId).getFile()));
                    }
                    catch (MalformedURLException e) {
                        throw new JDocBookProcessException("Unable to convert reported XInclude href into URL instance [" + systemId + "]");
                    }
                }
                return null;
            }
        };
        EntityResolverChain entityResolverChain = new EntityResolverChain(entityResolver);
        entityResolverChain.addEntityResolver(new LocalDocBookSchemaResolver(schemaResolutionStrategy));
        try {
            SAXParserFactoryImpl parserFactory = new SAXParserFactoryImpl();
            parserFactory.setXIncludeAware(true);
            SAXSource transformationSource = FileUtils.createSAXSource(root, entityResolverChain, null);
            StreamResult transformationResult = new StreamResult(new NoOpWriter());
            TransformerFactoryImpl transformerFactory = new TransformerFactoryImpl();
            transformerFactory.newTransformer().transform(transformationSource, transformationResult);
        }
        catch (TransformerException e) {
            throw new JDocBookProcessException("Problem performing 'transformation'", e);
        }
        return includes;
    }

    public static void findAllInclusionFiles(File masterFile, Set<File> files) {
        XIncludeHelper.findAllInclusionFiles(masterFile, files, DocBookSchemaResolutionStrategy.RNG);
    }

    public static void findAllInclusionFiles(File masterFile, Set<File> files, DocBookSchemaResolutionStrategy schemaResolutionStrategy) {
        if (masterFile == null || !masterFile.exists()) {
            return;
        }
        if (!FileUtils.isXMLFile(masterFile)) {
            return;
        }
        Set<File> inclusions = XIncludeHelper.locateInclusions(masterFile, schemaResolutionStrategy);
        if (inclusions == null || inclusions.isEmpty()) {
            return;
        }
        for (File inclusion : inclusions) {
            if (!inclusion.exists()) continue;
            files.add(inclusion);
            XIncludeHelper.findAllInclusionFiles(inclusion, files, schemaResolutionStrategy);
        }
    }
}

