/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.eis;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ironjacamar.eis.Handler;
import org.ironjacamar.eis.HandlerServer;

public class EISServer {
    private static Map<String, HandlerServer> handlerServers = Collections.synchronizedMap(new HashMap());
    private String handlerClassName = null;
    private ClassLoader classLoader = null;
    private String host = "localhost";
    private int port = 1400;
    private int controlPort = 1401;

    public void setHandlerClassName(String v) {
        this.handlerClassName = v;
    }

    public void setClassLoader(ClassLoader v) {
        this.classLoader = v;
    }

    public void setHost(String v) {
        this.host = v;
    }

    public void setPort(int v) {
        this.port = v;
    }

    public void startup() throws Throwable {
        Class<?> handler;
        if (this.handlerClassName == null || this.handlerClassName.trim().equals("")) {
            throw new IllegalStateException("HandlerClassName isn't defined");
        }
        this.shutdown();
        ClassLoader cl = this.classLoader;
        if (cl == null) {
            cl = EISServer.class.getClassLoader();
        }
        if (!Handler.class.isAssignableFrom(handler = Class.forName(this.handlerClassName, true, cl))) {
            throw new IllegalArgumentException("The specified handler class doesn't implement the interface");
        }
        HandlerServer handlerServer = new HandlerServer(this.host, this.port, handler);
        handlerServer.start();
        handlerServers.put(this.getKey(), handlerServer);
    }

    public void shutdown() throws Throwable {
        HandlerServer handlerServer = handlerServers.remove(this.getKey());
        if (handlerServer != null) {
            handlerServer.stop();
        }
    }

    private String getKey() {
        return this.host + ":" + this.port;
    }
}

