/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.extension.ant.task;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Reference;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataJavaDoc;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataParser;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataParserConfiguration;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataParserPath;

public class MetadataParserTask
extends Task {
    protected boolean verbose = false;
    protected String classpathRef = null;
    protected Path path = null;
    protected Descriptors descriptors = null;
    protected Javadocs javadocs = null;
    protected Classpath classpath = null;

    public void setVerbose(boolean v) {
        this.verbose = v;
    }

    public void setClasspathref(String v) {
        this.classpathRef = v;
    }

    public Path createPath() {
        this.path = new Path();
        return this.path;
    }

    public Javadocs createJavadocs() {
        this.javadocs = new Javadocs();
        return this.javadocs;
    }

    public Descriptors createDescriptors() {
        this.descriptors = new Descriptors();
        return this.descriptors;
    }

    public Classpath createClasspath() {
        this.classpath = new Classpath(this.getProject());
        return this.classpath;
    }

    public void execute() throws BuildException {
        if (this.path == null) {
            throw new BuildException("Path isn't defined");
        }
        if (this.descriptors == null) {
            throw new BuildException("Descriptors isn't defined");
        }
        if (this.descriptors.getData() == null) {
            throw new BuildException("No descriptor defined");
        }
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            if (this.classpathRef != null || this.classpath != null) {
                org.apache.tools.ant.types.Path p = new org.apache.tools.ant.types.Path(this.getProject());
                if (this.classpathRef != null) {
                    Reference reference = new Reference(this.getProject(), this.classpathRef);
                    p.setRefid(reference);
                }
                if (this.classpath != null) {
                    p.append((org.apache.tools.ant.types.Path)this.classpath);
                }
                AntClassLoader cl = this.getProject().createClassLoader(oldCl, p);
                Thread.currentThread().setContextClassLoader((ClassLoader)cl);
            }
            List<Descriptor> data = this.descriptors.getData();
            for (Descriptor d : data) {
                d.applyNamespaces();
            }
            List<Javadoc> javadoc = null;
            if (this.javadocs != null) {
                javadoc = this.javadocs.getData();
            }
            MetadataParser metadataParser = new MetadataParser();
            metadataParser.parse((MetadataParserPath)this.path, data, javadoc, this.verbose);
        }
        catch (Throwable t) {
            throw new BuildException(t.getMessage(), t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public class Property {
        private Project project;
        private String name;
        private String value;

        public Property(Project p) {
            this.project = p;
            this.name = null;
            this.value = null;
        }

        public void setName(String v) {
            this.name = this.project.replaceProperties(v);
        }

        public String getName() {
            return this.name;
        }

        public void setValue(String v) {
            this.value = this.project.replaceProperties(v);
        }

        public String getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Namespaces {
        private Project project;
        private List<Property> properties;

        public Namespaces(Project p) {
            this.project = p;
            this.properties = null;
        }

        public Property createProperty() {
            Property p = new Property(this.project);
            if (this.properties == null) {
                this.properties = new ArrayList<Property>(1);
            }
            this.properties.add(p);
            return p;
        }

        List<Property> getData() {
            return this.properties;
        }
    }

    public class Classpath
    extends org.apache.tools.ant.types.Path {
        public Classpath(Project p) {
            super(p);
        }
    }

    public class Descriptor
    extends MetadataParserConfiguration {
        protected Namespaces namespaces = null;

        public Namespaces createNamespaces() {
            this.namespaces = new Namespaces(MetadataParserTask.this.getProject());
            return this.namespaces;
        }

        public void applyNamespaces() {
            if (this.namespaces != null && this.namespaces.getData() != null) {
                Properties properties = new Properties();
                for (Property p : this.namespaces.getData()) {
                    if (p.getName() == null || p.getValue() == null) continue;
                    properties.put(p.getName(), p.getValue());
                }
                this.setNamespaces(properties);
            }
        }

        public void setNameSpace(String nameSpace) {
            super.setNameSpace(MetadataParserTask.this.getProject().replaceProperties(nameSpace));
        }

        public void setPackageApi(String packageApi) {
            super.setPackageApi(MetadataParserTask.this.getProject().replaceProperties(packageApi));
        }

        public void setPackageImpl(String packageImpl) {
            super.setPackageImpl(MetadataParserTask.this.getProject().replaceProperties(packageImpl));
        }

        public void setPathToXsd(String pathToXsd) {
            super.setPathToXsd(MetadataParserTask.this.getProject().replaceProperties(pathToXsd));
        }

        public void setElementName(String elementName) {
            super.setElementName(MetadataParserTask.this.getProject().replaceProperties(elementName));
        }

        public void setElementType(String elementType) {
            super.setElementType(MetadataParserTask.this.getProject().replaceProperties(elementType));
        }

        public void setDescriptorName(String descriptorName) {
            super.setDescriptorName(MetadataParserTask.this.getProject().replaceProperties(descriptorName));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Javadocs {
        private List<Javadoc> data = null;

        public Javadoc createJavadoc() {
            if (this.data == null) {
                this.data = new ArrayList<Javadoc>(1);
            }
            Javadoc javaDoc = new Javadoc();
            this.data.add(javaDoc);
            return javaDoc;
        }

        List<Javadoc> getData() {
            return this.data;
        }
    }

    public class Javadoc
    extends MetadataJavaDoc {
        public void setTag(String tag) {
            super.setTag(MetadataParserTask.this.getProject().replaceProperties(tag));
        }

        public void setValue(String value) {
            super.setValue(MetadataParserTask.this.getProject().replaceProperties(value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Descriptors {
        private List<Descriptor> data = null;

        public Descriptor createDescriptor() {
            if (this.data == null) {
                this.data = new ArrayList<Descriptor>(1);
            }
            Descriptor descriptor = new Descriptor();
            this.data.add(descriptor);
            return descriptor;
        }

        List<Descriptor> getData() {
            return this.data;
        }
    }

    public class Path
    extends MetadataParserPath {
        public void setPathToApi(String pathToApi) {
            super.setPathToApi(MetadataParserTask.this.getProject().replaceProperties(pathToApi));
        }

        public void setPathToImpl(String pathToImpl) {
            super.setPathToImpl(MetadataParserTask.this.getProject().replaceProperties(pathToImpl));
        }

        public void setPathToTest(String pathToTest) {
            super.setPathToTest(MetadataParserTask.this.getProject().replaceProperties(pathToTest));
        }

        public void setPathToServices(String pathToServices) {
            super.setPathToServices(MetadataParserTask.this.getProject().replaceProperties(pathToServices));
        }
    }
}

