/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.ErrorMessages;
import org.fest.assertions.GenericAssert;
import org.fest.assertions.NumberAssert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntAssert
extends GenericAssert<IntAssert, Integer>
implements NumberAssert {
    private static final int ZERO = 0;

    protected IntAssert(int actual) {
        super(IntAssert.class, actual);
    }

    protected IntAssert(Integer actual) {
        super(IntAssert.class, actual);
    }

    @Override
    public IntAssert isEqualTo(int expected) {
        return (IntAssert)this.isEqualTo(Integer.valueOf(expected));
    }

    @Override
    public IntAssert isNotEqualTo(int other) {
        return (IntAssert)this.isNotEqualTo(Integer.valueOf(other));
    }

    public IntAssert isGreaterThan(int other) {
        if ((Integer)this.actual > other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThanOrEqualTo(this.actual, other));
    }

    public IntAssert isLessThan(int other) {
        if ((Integer)this.actual < other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThanOrEqualTo(this.actual, other));
    }

    public IntAssert isGreaterThanOrEqualTo(int other) {
        if ((Integer)this.actual >= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThan(this.actual, other));
    }

    public IntAssert isLessThanOrEqualTo(int other) {
        if ((Integer)this.actual <= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThan(this.actual, other));
    }

    @Override
    public IntAssert isZero() {
        return this.isEqualTo(0);
    }

    @Override
    public IntAssert isPositive() {
        return this.isGreaterThan(0);
    }

    @Override
    public IntAssert isNegative() {
        return this.isLessThan(0);
    }
}

