/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.api.connectionmanager.pool;

import org.ironjacamar.common.api.metadata.common.FlushStrategy;

public class PoolConfiguration {
    private String id = null;
    private int minSize = 0;
    private Integer initialSize = null;
    private int maxSize = 20;
    private long blockingTimeout = 30000L;
    private int idleTimeoutMinutes = 30;
    private boolean validateOnMatch = false;
    private boolean backgroundValidation = false;
    private long backgroundValidationMillis = 60000L;
    private boolean prefill = false;
    private boolean useFastFail = false;
    private FlushStrategy flushStrategy = null;

    public String getId() {
        return this.id;
    }

    public void setId(String v) {
        this.id = v;
    }

    public int getMinSize() {
        if (this.minSize > this.maxSize) {
            return this.maxSize;
        }
        return this.minSize;
    }

    public void setMinSize(int v) {
        if (v >= 0) {
            this.minSize = v;
        }
    }

    public int getInitialSize() {
        if (this.initialSize == null) {
            return this.getMinSize();
        }
        if (this.initialSize > this.maxSize) {
            return this.maxSize;
        }
        return this.initialSize;
    }

    public void setInitialSize(int v) {
        if (v >= 0) {
            this.initialSize = v;
        }
    }

    public int getMaxSize() {
        if (this.maxSize < this.minSize) {
            return this.minSize;
        }
        return this.maxSize;
    }

    public void setMaxSize(int v) {
        if (v >= 0) {
            this.maxSize = v;
        }
    }

    public long getBlockingTimeout() {
        return this.blockingTimeout;
    }

    public void setBlockingTimeout(long v) {
        if (v >= 0L) {
            this.blockingTimeout = v;
        }
    }

    public int getIdleTimeoutMinutes() {
        return this.idleTimeoutMinutes;
    }

    public void setIdleTimeoutMinutes(int v) {
        if (v >= 0) {
            this.idleTimeoutMinutes = v;
        }
    }

    public boolean isValidateOnMatch() {
        return this.validateOnMatch;
    }

    public void setValidateOnMatch(boolean v) {
        this.validateOnMatch = v;
    }

    public boolean isBackgroundValidation() {
        if (this.isValidateOnMatch()) {
            return false;
        }
        return this.backgroundValidation;
    }

    public void setBackgroundValidation(boolean v) {
        this.backgroundValidation = v;
    }

    public long getBackgroundValidationMillis() {
        return this.backgroundValidationMillis;
    }

    public void setBackgroundValidationMillis(long v) {
        this.backgroundValidationMillis = v;
    }

    public boolean isPrefill() {
        return this.prefill || this.initialSize != null && this.initialSize > 0;
    }

    public void setPrefill(boolean v) {
        this.prefill = v;
    }

    public boolean isUseFastFail() {
        return this.useFastFail;
    }

    public void setUseFastFail(boolean v) {
        this.useFastFail = v;
    }

    public void setFlushStrategy(FlushStrategy f) {
        this.flushStrategy = f;
    }

    public FlushStrategy getFlushStrategy() {
        return this.flushStrategy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PoolConfiguration@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[minSize=").append(this.minSize);
        sb.append(" initialSize=").append(this.initialSize != null ? Integer.valueOf(this.initialSize) : "null");
        sb.append(" maxSize=").append(this.maxSize);
        sb.append(" blockingTimeout=").append(this.blockingTimeout);
        sb.append(" idleTimeoutMinutes=").append(this.idleTimeoutMinutes);
        sb.append(" validateOnMatch=").append(this.validateOnMatch);
        sb.append(" backgroundValidation=").append(this.backgroundValidation);
        sb.append(" backgroundValidationMillis=").append(this.backgroundValidationMillis);
        sb.append(" prefill=").append(this.prefill);
        sb.append(" useFastFail=").append(this.useFastFail);
        sb.append(" flushStrategy=").append(this.flushStrategy);
        sb.append("]");
        return sb.toString();
    }
}

