/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.bootstrapcontext;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.ironjacamar.common.api.metadata.spec.ConfigProperty;
import org.ironjacamar.core.CoreLogger;
import org.ironjacamar.core.api.workmanager.WorkManager;
import org.ironjacamar.core.bootstrapcontext.CloneableBootstrapContext;
import org.ironjacamar.core.workmanager.WorkManagerCoordinator;
import org.jboss.logging.Logger;

public class BootstrapContextCoordinator {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)BootstrapContextCoordinator.class.getName());
    private static boolean trace = log.isTraceEnabled();
    private ConcurrentMap<String, CloneableBootstrapContext> bootstrapContexts = new ConcurrentHashMap<String, CloneableBootstrapContext>();
    private CloneableBootstrapContext defaultBootstrapContext = null;
    private Map<String, CloneableBootstrapContext> activeBootstrapContexts = new HashMap<String, CloneableBootstrapContext>();
    private Map<String, Integer> refCountBootstrapContexts = new HashMap<String, Integer>();
    private WorkManagerCoordinator workManagerCoordinator = null;

    public void registerBootstrapContext(CloneableBootstrapContext bc) {
        if (bc != null) {
            if (bc.getName() == null || bc.getName().trim().equals("")) {
                throw new IllegalArgumentException("The name of BootstrapContext is invalid: " + bc);
            }
            if (!this.bootstrapContexts.keySet().contains(bc.getName())) {
                this.bootstrapContexts.put(bc.getName(), bc);
            }
        }
    }

    public void unregisterBootstrapContext(CloneableBootstrapContext bc) {
        if (bc != null) {
            if (bc.getName() == null || bc.getName().trim().equals("")) {
                throw new IllegalArgumentException("The name of BootstrapContext is invalid: " + bc);
            }
            if (this.bootstrapContexts.keySet().contains(bc.getName())) {
                this.bootstrapContexts.remove(bc.getName());
            }
        }
    }

    public CloneableBootstrapContext getDefaultBootstrapContext() {
        return this.defaultBootstrapContext;
    }

    public void setDefaultBootstrapContext(CloneableBootstrapContext bc) {
        if (trace) {
            log.tracef("Default BootstrapContext: %s", bc);
        }
        String currentName = null;
        if (this.defaultBootstrapContext != null) {
            currentName = this.defaultBootstrapContext.getName();
        }
        this.defaultBootstrapContext = bc;
        if (bc != null) {
            this.bootstrapContexts.put(bc.getName(), bc);
        } else if (currentName != null) {
            this.bootstrapContexts.remove(currentName);
        }
    }

    public void setWorkManagerCoordinator(WorkManagerCoordinator wcc) {
        if (trace) {
            log.tracef("WorkManagerCoordinator: %s", wcc);
        }
        this.workManagerCoordinator = wcc;
    }

    public synchronized CloneableBootstrapContext createBootstrapContext(String id) {
        return this.createBootstrapContext(id, null);
    }

    public synchronized CloneableBootstrapContext createBootstrapContext(String id, String name) {
        if (id == null || id.trim().equals("")) {
            throw new IllegalArgumentException("The id of BootstrapContext is invalid: " + id);
        }
        if (this.activeBootstrapContexts.keySet().contains(id)) {
            Integer i = this.refCountBootstrapContexts.get(id);
            this.refCountBootstrapContexts.put(id, i + 1);
            return this.activeBootstrapContexts.get(id);
        }
        try {
            CloneableBootstrapContext template = null;
            template = name != null ? (CloneableBootstrapContext)this.bootstrapContexts.get(name) : this.defaultBootstrapContext;
            if (template == null) {
                throw new IllegalArgumentException("The BootstrapContext wasn't found: " + name);
            }
            CloneableBootstrapContext bc = template.clone();
            bc.setId(id);
            WorkManager wm = this.workManagerCoordinator.createWorkManager(id, bc.getWorkManagerName());
            bc.setWorkManager(wm);
            this.activeBootstrapContexts.put(id, bc);
            this.refCountBootstrapContexts.put(id, 1);
            if (trace) {
                log.tracef("Created BootstrapContext: %s", bc);
            }
            return bc;
        }
        catch (Throwable t) {
            throw new IllegalStateException("The BootstrapContext couldn't be created: " + name, t);
        }
    }

    public synchronized void removeBootstrapContext(String id) {
        if (id == null || id.trim().equals("")) {
            throw new IllegalArgumentException("The id of BootstrapContext is invalid: " + id);
        }
        Integer i = this.refCountBootstrapContexts.get(id);
        if (i != null) {
            int newValue = i - 1;
            if (newValue == 0) {
                CloneableBootstrapContext cbc = this.activeBootstrapContexts.remove(id);
                this.refCountBootstrapContexts.remove(id);
                cbc.shutdown();
                this.workManagerCoordinator.removeWorkManager(id);
            } else {
                this.refCountBootstrapContexts.put(id, newValue);
            }
        }
    }

    public String createIdentifier(String raClz, Collection<ConfigProperty> configProperties) {
        return this.createIdentifier(raClz, configProperties, null);
    }

    public String createIdentifier(String raClz, Collection<ConfigProperty> configProperties, String bootstrapContextName) {
        if (this.defaultBootstrapContext == null) {
            throw new IllegalArgumentException("No default BootstrapContext defined");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(raClz);
        if (configProperties != null && configProperties.size() > 0) {
            sb.append(";");
            Iterator<ConfigProperty> iterator = configProperties.iterator();
            while (iterator.hasNext()) {
                ConfigProperty entry = iterator.next();
                sb.append(entry.getConfigPropertyName()).append("=").append(entry.getConfigPropertyValue());
                if (!iterator.hasNext()) continue;
                sb.append(":");
            }
        }
        sb.append("-");
        if (bootstrapContextName != null && !bootstrapContextName.trim().equals("")) {
            sb.append(bootstrapContextName);
        } else {
            sb.append(this.defaultBootstrapContext.getName());
        }
        return sb.toString();
    }
}

