/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.bootstrapcontext;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.HintsContext;
import javax.resource.spi.work.SecurityContext;
import javax.resource.spi.work.TransactionContext;
import javax.resource.spi.work.WorkContext;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.validation.ValidatorFactory;
import org.ironjacamar.core.api.workmanager.WorkManager;
import org.ironjacamar.core.bootstrapcontext.CloneableBootstrapContext;

public class BootstrapContextImpl
implements CloneableBootstrapContext {
    private WorkManager workManager;
    private String workManagerName;
    private TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private XATerminator xaTerminator;
    private Set<Class> supportedContexts;
    private List<Timer> timers;
    private String name;
    private String id;
    private ValidatorFactory validatorFactory;

    public BootstrapContextImpl(WorkManager wm, TransactionSynchronizationRegistry tsr, XATerminator terminator, ValidatorFactory validatorFactory) {
        this.workManager = wm;
        this.transactionSynchronizationRegistry = tsr;
        this.xaTerminator = terminator;
        this.supportedContexts = new HashSet<Class>(3);
        this.validatorFactory = validatorFactory;
        this.supportedContexts.add(HintsContext.class);
        this.supportedContexts.add(SecurityContext.class);
        this.supportedContexts.add(TransactionContext.class);
        this.timers = null;
    }

    public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return this.transactionSynchronizationRegistry;
    }

    @Override
    public void setTransactionSynchronizationRegistry(TransactionSynchronizationRegistry tsr) {
        this.transactionSynchronizationRegistry = tsr;
    }

    @Override
    public void setWorkManager(WorkManager wm) {
        this.workManager = wm;
    }

    @Override
    public String getWorkManagerName() {
        return this.workManagerName;
    }

    @Override
    public void setWorkManagerName(String wmn) {
        this.workManagerName = wmn;
    }

    @Override
    public void setXATerminator(XATerminator xt) {
        this.xaTerminator = xt;
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public XATerminator getXATerminator() {
        return this.xaTerminator;
    }

    public Timer createTimer() {
        Timer t = new Timer(true);
        if (this.timers == null) {
            this.timers = new ArrayList<Timer>();
        }
        this.timers.add(t);
        return t;
    }

    public boolean isContextSupported(Class<? extends WorkContext> workContextClass) {
        if (workContextClass == null) {
            return false;
        }
        return this.supportedContexts.contains(workContextClass);
    }

    @Override
    public void shutdown() {
        if (this.timers != null) {
            for (Timer t : this.timers) {
                t.cancel();
                t.purge();
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String v) {
        this.id = v;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setResourceAdapter(ResourceAdapter ra) {
        if (this.workManager != null) {
            this.workManager.setResourceAdapter(ra);
        }
    }

    public void setName(String v) {
        this.name = v;
    }

    @Override
    public ValidatorFactory getValidatorFactory() {
        return this.validatorFactory;
    }

    @Override
    public void setValidatorFactory(ValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
    }

    @Override
    public BootstrapContextImpl clone() throws CloneNotSupportedException {
        BootstrapContextImpl bcbc = (BootstrapContextImpl)super.clone();
        bcbc.setTransactionSynchronizationRegistry(this.getTransactionSynchronizationRegistry());
        bcbc.setXATerminator(this.getXATerminator());
        bcbc.setName(this.getName());
        bcbc.setWorkManagerName(this.getWorkManagerName());
        bcbc.setValidatorFactory(this.getValidatorFactory());
        return bcbc;
    }
}

