/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.bv;

import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.validation.Configuration;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.ironjacamar.core.bv.IronJacamarTraversableResolver;
import org.ironjacamar.core.bv.IronJacamarValidatorFactory;
import org.ironjacamar.core.bv.SerializableValidatorFactory;
import org.ironjacamar.core.spi.bv.BeanValidation;

public class BeanValidationImpl
implements BeanValidation {
    private static final String VALIDATOR_FACTORY = "java:/ValidatorFactory";
    private ValidatorFactory validatorFactory;
    private final int jndiPort;
    private final String jndiProtocol;
    private final String jndiHost;

    public BeanValidationImpl(String jndiProtocol, String jndiHost, int jndiPort) {
        this.jndiProtocol = jndiProtocol;
        this.jndiHost = jndiHost;
        this.jndiPort = jndiPort;
        this.validatorFactory = BeanValidationImpl.createValidatorFactory();
    }

    @Override
    public ValidatorFactory getValidatorFactory() {
        return new IronJacamarValidatorFactory(this.validatorFactory);
    }

    static ValidatorFactory createValidatorFactory() {
        Configuration configuration = Validation.byDefaultProvider().configure();
        Configuration conf = configuration.traversableResolver((TraversableResolver)new IronJacamarTraversableResolver());
        return conf.buildValidatorFactory();
    }

    public void start() throws Throwable {
        Context context = null;
        try {
            Properties properties = new Properties();
            properties.setProperty("java.naming.provider.url", this.jndiProtocol + "://" + this.jndiHost + ":" + this.jndiPort);
            context = new InitialContext(properties);
            context.rebind(VALIDATOR_FACTORY, (Object)new SerializableValidatorFactory(this.validatorFactory));
        }
        finally {
            try {
                if (context != null) {
                    context.close();
                }
            }
            catch (NamingException namingException) {}
        }
    }

    public void stop() throws Throwable {
        if (this.validatorFactory != null) {
            this.validatorFactory.close();
        }
        Context context = null;
        try {
            Properties properties = new Properties();
            properties.setProperty("java.naming.provider.url", this.jndiProtocol + "://" + this.jndiHost + ":" + this.jndiPort);
            context = new InitialContext(properties);
            context.unbind(VALIDATOR_FACTORY);
        }
        finally {
            try {
                if (context != null) {
                    context.close();
                }
            }
            catch (NamingException namingException) {}
        }
    }
}

