/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.connectionmanager;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.DissociatableManagedConnection;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.RetryableException;
import javax.resource.spi.TransactionSupport;
import org.ironjacamar.core.api.connectionmanager.ConnectionManagerConfiguration;
import org.ironjacamar.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.ironjacamar.core.api.connectionmanager.pool.FlushMode;
import org.ironjacamar.core.connectionmanager.ConnectionManager;
import org.ironjacamar.core.connectionmanager.ConnectionManagerShutdown;
import org.ironjacamar.core.connectionmanager.Credential;
import org.ironjacamar.core.connectionmanager.SecurityActions;
import org.ironjacamar.core.connectionmanager.listener.ConnectionListener;
import org.ironjacamar.core.connectionmanager.pool.Pool;
import org.ironjacamar.core.spi.graceful.GracefulCallback;
import org.ironjacamar.core.spi.security.SubjectFactory;
import org.jboss.logging.Logger;

public abstract class AbstractConnectionManager
implements ConnectionManager {
    private static Logger log = Logger.getLogger(AbstractConnectionManager.class);
    protected final AtomicBoolean shutdown = new AtomicBoolean(false);
    protected final ManagedConnectionFactory mcf;
    protected Pool pool;
    protected CachedConnectionManager ccm;
    protected ConnectionManagerConfiguration cmConfiguration;
    protected SubjectFactory subjectFactory;
    private Boolean supportsLazyAssociation;
    private ScheduledExecutorService scheduledExecutorService;
    private ScheduledFuture scheduledGraceful;
    private GracefulCallback gracefulCallback;

    public AbstractConnectionManager(ManagedConnectionFactory mcf, CachedConnectionManager ccm, ConnectionManagerConfiguration cmc) {
        this.mcf = mcf;
        this.ccm = ccm;
        this.cmConfiguration = cmc;
        this.pool = null;
        this.subjectFactory = null;
        this.supportsLazyAssociation = null;
        this.scheduledExecutorService = null;
        this.scheduledGraceful = null;
        this.gracefulCallback = null;
    }

    @Override
    public void setPool(Pool pool) {
        this.pool = pool;
    }

    @Override
    public Pool getPool() {
        return this.pool;
    }

    @Override
    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    @Override
    public CachedConnectionManager getCachedConnectionManager() {
        return this.ccm;
    }

    @Override
    public ConnectionManagerConfiguration getConnectionManagerConfiguration() {
        return this.cmConfiguration;
    }

    @Override
    public void setSubjectFactory(SubjectFactory subjectFactory) {
        this.subjectFactory = subjectFactory;
    }

    @Override
    public SubjectFactory getSubjectFactory() {
        return this.subjectFactory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean cancelShutdown() {
        if (this.scheduledGraceful != null) {
            boolean result = this.scheduledGraceful.cancel(false);
            if (!result) return false;
            this.shutdown.set(false);
            if (this.gracefulCallback != null) {
                this.gracefulCallback.cancel();
            }
            if (this.pool != null) {
                this.pool.prefill();
            }
            this.scheduledGraceful = null;
            this.gracefulCallback = null;
            return true;
        } else {
            if (!this.shutdown.get()) return false;
            this.shutdown.set(false);
            if (this.gracefulCallback != null) {
                this.gracefulCallback.cancel();
            }
            if (this.pool != null) {
                this.pool.prefill();
            }
            this.gracefulCallback = null;
        }
        return true;
    }

    @Override
    public void prepareShutdown() {
        this.prepareShutdown(0, null);
    }

    @Override
    public void prepareShutdown(GracefulCallback cb) {
        this.prepareShutdown(0, cb);
    }

    @Override
    public void prepareShutdown(int seconds) {
        this.prepareShutdown(seconds, null);
    }

    @Override
    public void prepareShutdown(int seconds, GracefulCallback cb) {
        this.shutdown.set(true);
        if (this.gracefulCallback == null) {
            this.gracefulCallback = cb;
        }
        if (this.pool != null) {
            this.pool.flush(FlushMode.GRACEFULLY);
        }
        if (seconds > 0 && this.scheduledGraceful == null) {
            if (this.scheduledExecutorService == null) {
                this.scheduledExecutorService = Executors.newScheduledThreadPool(1);
            }
            this.scheduledGraceful = this.scheduledExecutorService.schedule(new ConnectionManagerShutdown(this), (long)seconds, TimeUnit.SECONDS);
        }
    }

    @Override
    public int getDelay() {
        if (this.scheduledGraceful != null) {
            return (int)this.scheduledGraceful.getDelay(TimeUnit.SECONDS);
        }
        if (this.shutdown.get()) {
            return Integer.MIN_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public synchronized void shutdown() {
        this.shutdown.set(true);
        if (this.pool != null) {
            this.pool.shutdown();
        }
        if (this.scheduledExecutorService != null) {
            if (this.scheduledGraceful != null && !this.scheduledGraceful.isDone()) {
                this.scheduledGraceful.cancel(true);
            }
            this.scheduledGraceful = null;
            this.scheduledExecutorService.shutdownNow();
            this.scheduledExecutorService = null;
        }
        if (this.gracefulCallback != null) {
            this.gracefulCallback.done();
            this.gracefulCallback = null;
        }
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cri) throws ResourceException {
        if (this.shutdown.get()) {
            throw new ResourceException();
        }
        Credential credential = this.subjectFactory == null || this.cmConfiguration.getSecurityDomain() == null ? new Credential(null, cri) : new Credential(SecurityActions.createSubject(this.subjectFactory, this.cmConfiguration.getSecurityDomain(), mcf), cri);
        ConnectionListener cl = this.getConnectionListener(credential);
        Object connection = cl.getConnection();
        if (this.ccm != null) {
            this.ccm.registerConnection(this, cl, connection);
        }
        return connection;
    }

    @Override
    public void returnConnectionListener(org.ironjacamar.core.api.connectionmanager.listener.ConnectionListener cl, boolean kill) {
        try {
            this.pool.returnConnectionListener((ConnectionListener)cl, kill);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConnectionListener getConnectionListener(Credential credential) throws ResourceException {
        ConnectionListener result = null;
        Throwable failure = null;
        boolean isInterrupted = Thread.interrupted();
        boolean innerIsInterrupted = false;
        try {
            result = this.pool.getConnectionListener(credential);
            if (this.supportsLazyAssociation == null) {
                this.supportsLazyAssociation = result.getManagedConnection() instanceof DissociatableManagedConnection ? Boolean.TRUE : Boolean.FALSE;
            }
            ConnectionListener connectionListener = result;
            return connectionListener;
        }
        catch (ResourceException e) {
            failure = e;
            if (this.cmConfiguration.getAllocationRetry() != 0 || e instanceof RetryableException) {
                int to = this.cmConfiguration.getAllocationRetry();
                long sleep = this.cmConfiguration.getAllocationRetryWaitMillis();
                if (to == 0 && e instanceof RetryableException) {
                    to = 1;
                }
                for (int i = 0; i < to; ++i) {
                    if (this.shutdown.get()) {
                        throw new ResourceException();
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        Thread.interrupted();
                        innerIsInterrupted = true;
                    }
                    try {
                        if (sleep > 0L) {
                            Thread.sleep(sleep);
                        }
                        ConnectionListener connectionListener = this.pool.getConnectionListener(credential);
                        return connectionListener;
                    }
                    catch (ResourceException re) {
                        failure = re;
                        continue;
                    }
                    catch (InterruptedException ie) {
                        failure = ie;
                        innerIsInterrupted = true;
                    }
                    {
                        continue;
                    }
                }
            }
        }
        catch (Exception e) {
            failure = e;
            return failure;
        }
        finally {
            if (isInterrupted || innerIsInterrupted) {
                Thread.currentThread().interrupt();
                if (innerIsInterrupted) {
                    throw new ResourceException(failure);
                }
            }
        }
    }

    public void lazyEnlist(ManagedConnection mc) throws ResourceException {
    }

    public void associateConnection(Object connection, ManagedConnectionFactory mcf, ConnectionRequestInfo cri) throws ResourceException {
        this.associateManagedConnection(connection, mcf, cri);
    }

    public void inactiveConnectionClosed(Object connection, ManagedConnectionFactory mcf) {
    }

    @Override
    public ManagedConnection associateManagedConnection(Object connection, ManagedConnectionFactory mcf, ConnectionRequestInfo cri) throws ResourceException {
        log.tracef("associateManagedConnection(%s, %s, %s)", connection, (Object)mcf, (Object)cri);
        if (!this.mcf.equals((Object)mcf)) {
            throw new ResourceException();
        }
        if (connection == null) {
            throw new ResourceException();
        }
        Credential credential = null;
        credential = this.getSubjectFactory() == null || this.cmConfiguration.getSecurityDomain() == null ? new Credential(null, cri) : new Credential(SecurityActions.createSubject(this.subjectFactory, this.cmConfiguration.getSecurityDomain(), mcf), cri);
        return this.associateConnectionListener(credential, connection).getManagedConnection();
    }

    private ConnectionListener associateConnectionListener(Credential credential, Object connection) throws ResourceException {
        log.tracef("associateConnectionListener(%s, %s)", (Object)credential, connection);
        if (this.isShutdown()) {
            throw new ResourceException();
        }
        if (!this.cmConfiguration.isSharable()) {
            throw new ResourceException();
        }
        ConnectionListener cl = this.pool.getActiveConnectionListener(credential);
        if (cl == null) {
            if (!this.pool.isFull()) {
                try {
                    cl = this.pool.getConnectionListener(credential);
                }
                catch (ResourceException resourceException) {
                    // empty catch block
                }
            }
            if (cl == null) {
                ConnectionListener targetCl;
                ConnectionListener removeCl = this.pool.removeConnectionListener(null);
                if (removeCl != null) {
                    try {
                        if (this.ccm != null) {
                            for (Object c : removeCl.getConnections()) {
                                this.ccm.unregisterConnection(this, removeCl, c);
                            }
                        }
                        this.returnConnectionListener(removeCl, true);
                        cl = this.pool.getConnectionListener(credential);
                    }
                    catch (ResourceException resourceException) {}
                } else if (this.getTransactionSupport() == TransactionSupport.TransactionSupportLevel.NoTransaction && (targetCl = this.pool.removeConnectionListener(credential)) != null) {
                    if (targetCl.getManagedConnection() instanceof DissociatableManagedConnection) {
                        DissociatableManagedConnection dmc = (DissociatableManagedConnection)targetCl.getManagedConnection();
                        if (this.ccm != null) {
                            for (Object c : targetCl.getConnections()) {
                                this.ccm.unregisterConnection(this, targetCl, c);
                            }
                        }
                        dmc.dissociateConnections();
                        targetCl.clearConnections();
                        cl = targetCl;
                    } else {
                        try {
                            if (this.ccm != null) {
                                for (Object c : targetCl.getConnections()) {
                                    this.ccm.unregisterConnection(this, targetCl, c);
                                }
                            }
                            this.returnConnectionListener(targetCl, true);
                            cl = this.pool.getConnectionListener(credential);
                        }
                        catch (ResourceException resourceException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        if (cl == null) {
            throw new ResourceException();
        }
        if (connection != null) {
            cl.getManagedConnection().associateConnection(connection);
            cl.addConnection(connection);
            if (this.ccm != null) {
                this.ccm.registerConnection(this, cl, connection);
            }
        }
        return cl;
    }

    @Override
    public boolean dissociateManagedConnection(Object connection, ManagedConnection mc, ManagedConnectionFactory mcf) throws ResourceException {
        log.tracef("dissociateManagedConnection(%s, %s, %s)", connection, (Object)mc, (Object)mcf);
        if (connection == null || mc == null || mcf == null) {
            throw new ResourceException();
        }
        ConnectionListener cl = this.pool.findConnectionListener(mc, connection);
        if (cl != null) {
            if (this.ccm != null) {
                this.ccm.unregisterConnection(this, cl, connection);
            }
            cl.removeConnection(connection);
            if (cl.getConnections().isEmpty()) {
                this.pool.delist(cl);
                this.returnConnectionListener(cl, false);
                return true;
            }
        } else {
            throw new ResourceException();
        }
        return false;
    }
}

