/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.connectionmanager;

import javax.resource.ResourceException;
import javax.resource.spi.LazyEnlistableManagedConnection;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import org.ironjacamar.core.api.connectionmanager.ConnectionManagerConfiguration;
import org.ironjacamar.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.ironjacamar.core.connectionmanager.AbstractConnectionManager;
import org.ironjacamar.core.connectionmanager.Credential;
import org.ironjacamar.core.connectionmanager.TransactionalConnectionManager;
import org.ironjacamar.core.connectionmanager.listener.ConnectionListener;
import org.ironjacamar.core.spi.transaction.TransactionIntegration;
import org.ironjacamar.core.spi.transaction.TxUtils;

public abstract class AbstractTransactionalConnectionManager
extends AbstractConnectionManager
implements TransactionalConnectionManager {
    protected TransactionIntegration ti;

    public AbstractTransactionalConnectionManager(ManagedConnectionFactory mcf, CachedConnectionManager ccm, ConnectionManagerConfiguration cmc, TransactionIntegration ti) {
        super(mcf, ccm, cmc);
        this.ti = ti;
    }

    @Override
    public TransactionIntegration getTransactionIntegration() {
        return this.ti;
    }

    @Override
    public void transactionStarted(ConnectionListener cl) throws ResourceException {
        try {
            if (!cl.isEnlisted() && TxUtils.isUncommitted(this.ti.getTransactionManager().getTransaction()) && this.shouldEnlist(cl)) {
                cl.enlist();
            }
        }
        catch (ResourceException re) {
            throw re;
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    @Override
    public void lazyEnlist(ManagedConnection mc) throws ResourceException {
        if (!this.cmConfiguration.isEnlistment()) {
            throw new ResourceException();
        }
        if (mc == null || !(mc instanceof LazyEnlistableManagedConnection)) {
            throw new ResourceException();
        }
        this.pool.enlist(mc);
    }

    @Override
    protected ConnectionListener getConnectionListener(Credential credential) throws ResourceException {
        ConnectionListener cl = super.getConnectionListener(credential);
        try {
            if (!cl.isEnlisted() && TxUtils.isUncommitted(this.ti.getTransactionManager().getTransaction()) && this.shouldEnlist(cl)) {
                cl.enlist();
            }
            return cl;
        }
        catch (ResourceException re) {
            throw re;
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    private boolean shouldEnlist(ConnectionListener cl) {
        return !this.cmConfiguration.isEnlistment() || !(cl.getManagedConnection() instanceof LazyEnlistableManagedConnection);
    }
}

