/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.connectionmanager;

import javax.resource.spi.ConnectionRequestInfo;
import javax.security.auth.Subject;
import org.ironjacamar.core.connectionmanager.SecurityActions;

public final class Credential {
    private final Subject subject;
    private final ConnectionRequestInfo cri;
    private int hashCode;

    public Credential(Subject subject, ConnectionRequestInfo cri) {
        this.subject = subject;
        this.cri = cri;
        this.hashCode = Integer.MAX_VALUE;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public ConnectionRequestInfo getConnectionRequestInfo() {
        return this.cri;
    }

    public int hashCode() {
        if (this.hashCode == Integer.MAX_VALUE) {
            this.hashCode = SecurityActions.hashCode(this.subject) ^ (this.cri != null ? this.cri.hashCode() : 1);
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Credential)) {
            return false;
        }
        Credential other = (Credential)obj;
        boolean result = SecurityActions.equals(this.subject, other.subject);
        if (result) {
            result = this.cri != null ? this.cri.equals((Object)other.cri) : other.cri == null;
        }
        return result;
    }
}

