/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.connectionmanager.ccm;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.ResourceException;
import javax.resource.spi.TransactionSupport;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.ironjacamar.core.CoreBundle;
import org.ironjacamar.core.CoreLogger;
import org.ironjacamar.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.ironjacamar.core.connectionmanager.ConnectionManager;
import org.ironjacamar.core.connectionmanager.Credential;
import org.ironjacamar.core.connectionmanager.ccm.Context;
import org.ironjacamar.core.connectionmanager.ccm.SecurityActions;
import org.ironjacamar.core.connectionmanager.listener.ConnectionListener;
import org.ironjacamar.core.spi.transaction.TransactionIntegration;
import org.ironjacamar.core.spi.transaction.TxUtils;
import org.ironjacamar.core.tracer.Tracer;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public class CachedConnectionManagerImpl
implements CachedConnectionManager {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)CachedConnectionManager.class.getName());
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private static final String CLOSE_CONNECTION_SYNCHRONIZATION = "CLOSE_CONNECTION_SYNCHRONIZATION";
    private boolean debug = false;
    private boolean error = false;
    private boolean ignoreConnections = false;
    private TransactionIntegration transactionIntegration;
    private ThreadLocal<LinkedList<Context>> threadContexts = new ThreadLocal();
    private Map<Object, Throwable> connectionStackTraces = new WeakHashMap<Object, Throwable>();

    public CachedConnectionManagerImpl(TransactionIntegration transactionIntegration) {
        this.transactionIntegration = transactionIntegration;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean v) {
        this.debug = v;
    }

    @Override
    public boolean isError() {
        return this.error;
    }

    @Override
    public void setError(boolean v) {
        this.error = v;
    }

    @Override
    public boolean isIgnoreUnknownConnections() {
        return this.ignoreConnections;
    }

    @Override
    public void setIgnoreUnknownConnections(boolean v) {
        this.ignoreConnections = v;
    }

    @Override
    public void userTransactionStarted() throws SystemException {
        Context context = this.currentContext();
        log.tracef("user tx started, context: %s", context);
        if (context != null) {
            for (ConnectionManager cm : context.getConnectionManagers()) {
                List<ConnectionListener> cls;
                if (cm.getTransactionSupport() == TransactionSupport.TransactionSupportLevel.NoTransaction || (cls = context.getConnectionListeners(cm)).isEmpty()) continue;
                HashMap<Credential, ConnectionListener> enlistmentMap = new HashMap<Credential, ConnectionListener>();
                ArrayList<ConnectionListener> cleanup = new ArrayList<ConnectionListener>();
                try {
                    for (ConnectionListener cl : cls) {
                        if (enlistmentMap.get(cl.getCredential()) == null) {
                            enlistmentMap.put(cl.getCredential(), cl);
                            continue;
                        }
                        ConnectionListener existing = (ConnectionListener)enlistmentMap.get(cl.getCredential());
                        for (Object c : cl.getConnections()) {
                            existing.getManagedConnection().associateConnection(c);
                            existing.addConnection(c);
                            context.switchConnectionListener(c, cl, existing);
                        }
                        cl.clearConnections();
                        cleanup.add(cl);
                    }
                    for (ConnectionListener cl : enlistmentMap.values()) {
                        if (Tracer.isEnabled()) {
                            for (Object c : cl.getConnections()) {
                                Tracer.ccmUserTransaction(cl.getManagedConnectionPool().getPool().getConfiguration().getId(), cl.getManagedConnectionPool(), cl, c, context.toString());
                            }
                        }
                        cm.transactionStarted(cl);
                    }
                    for (ConnectionListener cl : cleanup) {
                        context.removeConnectionListener(cm, cl);
                        cm.returnConnectionListener(cl, false);
                    }
                }
                catch (Exception e) {
                    SystemException se = new SystemException();
                    se.initCause((Throwable)e);
                    throw se;
                }
            }
        }
    }

    @Override
    public void pushContext(Object contextKey, Set unsharableResources) throws ResourceException {
        LinkedList<Context> stack = this.threadContexts.get();
        Context context = new Context(contextKey);
        if (stack == null) {
            log.tracef("push: new stack for context: %s", context);
            stack = new LinkedList();
            this.threadContexts.set(stack);
        } else if (stack.isEmpty()) {
            log.tracef("push: new stack for context: %s", context);
        } else {
            log.tracef("push: old stack for context: %s", stack.getLast());
            log.tracef("push: new stack for context: %s", context);
        }
        if (Tracer.isEnabled()) {
            Tracer.pushCCMContext(context.toString(), new Throwable("CALLSTACK"));
        }
        stack.addLast(context);
    }

    @Override
    public void popContext(Set unsharableResources) throws ResourceException {
        LinkedList<Context> stack = this.threadContexts.get();
        if (stack == null || stack.isEmpty()) {
            return;
        }
        Context context = stack.removeLast();
        if (log.isTraceEnabled()) {
            if (!stack.isEmpty()) {
                log.tracef("pop: old stack for context: %s", context);
                log.tracef("pop: new stack for context: %s", stack.getLast());
            } else {
                log.tracef("pop: old stack for context: %s", context);
            }
        }
        if (Tracer.isEnabled()) {
            Tracer.popCCMContext(context.toString(), new Throwable("CALLSTACK"));
        }
        if (this.debug && this.closeAll(context) && this.error) {
            throw new ResourceException(bundle.someConnectionsWereNotClosed());
        }
        context.clear();
    }

    private Context currentContext() {
        LinkedList<Context> stack = this.threadContexts.get();
        if (stack != null && !stack.isEmpty()) {
            return stack.getLast();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConnection(org.ironjacamar.core.api.connectionmanager.ConnectionManager cm, org.ironjacamar.core.api.connectionmanager.listener.ConnectionListener cl, Object connection) {
        if (this.debug) {
            Map<Object, Throwable> map = this.connectionStackTraces;
            synchronized (map) {
                this.connectionStackTraces.put(connection, new Throwable("STACKTRACE"));
            }
        }
        Context context = this.currentContext();
        log.tracef("registering connection from connection manager: %s, connection : %s, context: %s", cm, connection, context);
        if (context != null) {
            ConnectionManager iCm = (ConnectionManager)cm;
            ConnectionListener iCl = (ConnectionListener)cl;
            if (Tracer.isEnabled()) {
                Tracer.registerCCMConnection(iCl.getManagedConnectionPool().getPool().getConfiguration().getId(), iCl.getManagedConnectionPool(), iCl, connection, context.toString());
            }
            context.registerConnection(iCm, iCl, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterConnection(org.ironjacamar.core.api.connectionmanager.ConnectionManager cm, org.ironjacamar.core.api.connectionmanager.listener.ConnectionListener cl, Object connection) {
        if (this.debug) {
            CloseConnectionSynchronization ccs = this.getCloseConnectionSynchronization(false);
            if (ccs != null) {
                ccs.remove(connection);
            }
            Map<Object, Throwable> map = this.connectionStackTraces;
            synchronized (map) {
                this.connectionStackTraces.remove(connection);
            }
        }
        Context context = this.currentContext();
        log.tracef("unregistering connection from connection manager: %s, connection: %s, context: %s", cm, connection, context);
        if (context == null) {
            return;
        }
        ConnectionManager iCm = (ConnectionManager)cm;
        ConnectionListener iCl = (ConnectionListener)cl;
        if (context.unregisterConnection(iCm, iCl, connection)) {
            if (Tracer.isEnabled()) {
                Tracer.unregisterCCMConnection(iCl.getManagedConnectionPool().getPool().getConfiguration().getId(), iCl.getManagedConnectionPool(), iCl, connection, context.toString());
            }
        } else {
            if (Tracer.isEnabled()) {
                Tracer.unknownCCMConnection(iCl.getManagedConnectionPool().getPool().getConfiguration().getId(), iCl.getManagedConnectionPool(), iCl, connection, context.toString());
            }
            if (!this.ignoreConnections) {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfConnections() {
        if (!this.debug) {
            return 0;
        }
        Map<Object, Throwable> map = this.connectionStackTraces;
        synchronized (map) {
            return this.connectionStackTraces.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> listConnections() {
        if (!this.debug) {
            return Collections.unmodifiableMap(Collections.EMPTY_MAP);
        }
        Map<Object, Throwable> map = this.connectionStackTraces;
        synchronized (map) {
            HashMap<String, String> result = new HashMap<String, String>();
            for (Map.Entry<Object, Throwable> entry : this.connectionStackTraces.entrySet()) {
                Object key = entry.getKey();
                Throwable stackTrace = entry.getValue();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(baos, true);
                stackTrace.printStackTrace(ps);
                result.put(key.toString(), baos.toString());
            }
            return Collections.unmodifiableMap(result);
        }
    }

    @Override
    public void start() {
        if (this.transactionIntegration != null && this.transactionIntegration.getUserTransactionRegistry() != null) {
            this.transactionIntegration.getUserTransactionRegistry().addListener(this);
        }
        log.debugf("start: %s", this.toString());
    }

    @Override
    public void stop() {
        log.debugf("stop: %s", this.toString());
        if (this.transactionIntegration != null && this.transactionIntegration.getUserTransactionRegistry() != null) {
            this.transactionIntegration.getUserTransactionRegistry().removeListener(this);
        }
    }

    private boolean closeAll(Context context) {
        boolean unclosed = false;
        CloseConnectionSynchronization ccs = this.getCloseConnectionSynchronization(true);
        for (ConnectionManager cm : context.getConnectionManagers()) {
            for (ConnectionListener cl : context.getConnectionListeners(cm)) {
                for (Object c : context.getConnections(cl)) {
                    if (ccs == null) {
                        unclosed = true;
                        if (Tracer.isEnabled()) {
                            Tracer.closeCCMConnection(cl.getManagedConnectionPool().getPool().getConfiguration().getId(), cl.getManagedConnectionPool(), cl, c, context.toString());
                        }
                        this.closeConnection(c);
                        continue;
                    }
                    ccs.add(c);
                }
            }
        }
        return unclosed;
    }

    private CloseConnectionSynchronization getCloseConnectionSynchronization(boolean createIfNotFound) {
        try {
            Transaction tx = null;
            if (this.transactionIntegration != null) {
                tx = this.transactionIntegration.getTransactionManager().getTransaction();
            }
            if (tx != null && TxUtils.isActive(tx)) {
                CloseConnectionSynchronization ccs = (CloseConnectionSynchronization)this.transactionIntegration.getTransactionSynchronizationRegistry().getResource((Object)CLOSE_CONNECTION_SYNCHRONIZATION);
                if (ccs == null && createIfNotFound) {
                    ccs = new CloseConnectionSynchronization();
                    this.transactionIntegration.getTransactionSynchronizationRegistry().putResource((Object)CLOSE_CONNECTION_SYNCHRONIZATION, (Object)ccs);
                    this.transactionIntegration.getTransactionSynchronizationRegistry().registerInterposedSynchronization((Synchronization)ccs);
                }
                return ccs;
            }
        }
        catch (Throwable t) {
            log.debug("Unable to synchronize with transaction", t);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(Object connectionHandle) {
        try {
            Throwable exception = null;
            Map<Object, Throwable> map = this.connectionStackTraces;
            synchronized (map) {
                exception = this.connectionStackTraces.remove(connectionHandle);
            }
            Method m = SecurityActions.getMethod(connectionHandle.getClass(), "close", new Class[0]);
            try {
                if (exception != null) {
                    log.closingConnection(connectionHandle, exception);
                } else {
                    log.closingConnection(connectionHandle);
                }
                m.invoke(connectionHandle, new Object[0]);
            }
            catch (Throwable t) {
                log.closingConnectionThrowable(t);
            }
        }
        catch (NoSuchMethodException nsme) {
            log.closingConnectionNoClose(connectionHandle.getClass().getName());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CachedConnectionManagerImpl@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[debug=").append(this.debug);
        sb.append(" error=").append(this.error);
        sb.append(" ignoreConnections=").append(this.ignoreConnections);
        sb.append(" transactionIntegration=").append(this.transactionIntegration);
        sb.append(" threadContexts=").append(this.threadContexts.get());
        sb.append(" connectionStackTraces=").append(this.connectionStackTraces);
        sb.append("]");
        return sb.toString();
    }

    private class CloseConnectionSynchronization
    implements Synchronization {
        private List<Object> connections = new ArrayList<Object>();
        private AtomicBoolean closing = new AtomicBoolean(false);

        public void add(Object c) {
            if (!this.closing.get()) {
                this.connections.add(c);
            }
        }

        public void remove(Object c) {
            if (!this.closing.get()) {
                this.connections.remove(c);
            }
        }

        public void beforeCompletion() {
            this.closeAll();
        }

        public void afterCompletion(int status) {
            this.closeAll();
        }

        private void closeAll() {
            this.closing.set(true);
            if (!this.connections.isEmpty()) {
                for (Object c : this.connections) {
                    CachedConnectionManagerImpl.this.closeConnection(c);
                }
                this.connections.clear();
            }
        }
    }
}

