/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.connectionmanager.ccm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ironjacamar.core.connectionmanager.ConnectionManager;
import org.ironjacamar.core.connectionmanager.listener.ConnectionListener;

class Context {
    private final Object contextKey;
    private Map<ConnectionManager, List<ConnectionListener>> cmToCl;
    private Map<ConnectionListener, List<Object>> clToC;

    Context(Object contextKey) {
        this.contextKey = contextKey;
        this.cmToCl = null;
        this.clToC = null;
    }

    void registerConnection(ConnectionManager cm, ConnectionListener cl, Object c) {
        List<Object> connections;
        List<ConnectionListener> l;
        if (this.cmToCl == null) {
            this.cmToCl = new HashMap<ConnectionManager, List<ConnectionListener>>();
        }
        if ((l = this.cmToCl.get(cm)) == null) {
            l = new ArrayList<ConnectionListener>(1);
        }
        l.add(cl);
        this.cmToCl.put(cm, l);
        if (this.clToC == null) {
            this.clToC = new HashMap<ConnectionListener, List<Object>>();
        }
        if ((connections = this.clToC.get(cl)) == null) {
            connections = new ArrayList<Object>(1);
        }
        connections.add(c);
        this.clToC.put(cl, connections);
    }

    boolean unregisterConnection(ConnectionManager cm, ConnectionListener cl, Object c) {
        if (this.clToC != null && this.clToC.get(cl) != null) {
            List<Object> l = this.clToC.get(cl);
            return l.remove(c);
        }
        return false;
    }

    Set<ConnectionManager> getConnectionManagers() {
        if (this.cmToCl == null) {
            return Collections.unmodifiableSet(Collections.emptySet());
        }
        return Collections.unmodifiableSet(this.cmToCl.keySet());
    }

    List<ConnectionListener> getConnectionListeners(ConnectionManager cm) {
        if (this.cmToCl == null) {
            return Collections.unmodifiableList(Collections.emptyList());
        }
        List<ConnectionListener> l = this.cmToCl.get(cm);
        if (l == null) {
            l = Collections.emptyList();
        }
        return Collections.unmodifiableList(l);
    }

    List<Object> getConnections(ConnectionListener cl) {
        List<Object> l = null;
        if (this.clToC != null) {
            l = this.clToC.get(cl);
        }
        if (l == null) {
            l = Collections.emptyList();
        }
        return Collections.unmodifiableList(l);
    }

    void switchConnectionListener(Object c, ConnectionListener from, ConnectionListener to) {
        if (this.clToC != null && this.clToC.get(from) != null && this.clToC.get(to) != null) {
            this.clToC.get(from).remove(c);
            this.clToC.get(to).add(c);
        }
    }

    void removeConnectionListener(ConnectionManager cm, ConnectionListener cl) {
        if (this.cmToCl != null && this.cmToCl.get(cm) != null) {
            this.cmToCl.get(cm).remove(cl);
            this.clToC.remove(cl);
        }
    }

    void clear() {
        if (this.cmToCl != null) {
            this.cmToCl.clear();
        }
        if (this.clToC != null) {
            this.clToC.clear();
        }
    }

    public int hashCode() {
        return System.identityHashCode(this.contextKey);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof Context)) {
            return false;
        }
        Context c = (Context)other;
        return this.contextKey.equals(c.contextKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Context[").append(Integer.toHexString(System.identityHashCode(this.contextKey)));
        sb.append("]");
        return sb.toString();
    }
}

