/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.connectionmanager.listener;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ManagedConnection;
import org.ironjacamar.common.api.metadata.common.FlushStrategy;
import org.ironjacamar.core.CoreBundle;
import org.ironjacamar.core.CoreLogger;
import org.ironjacamar.core.api.connectionmanager.pool.FlushMode;
import org.ironjacamar.core.connectionmanager.ConnectionManager;
import org.ironjacamar.core.connectionmanager.Credential;
import org.ironjacamar.core.connectionmanager.listener.ConnectionListener;
import org.ironjacamar.core.connectionmanager.pool.ManagedConnectionPool;
import org.ironjacamar.core.spi.transaction.ConnectableResourceListener;
import org.ironjacamar.core.tracer.Tracer;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public abstract class AbstractConnectionListener
implements ConnectionListener,
ConnectableResourceListener {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)AbstractConnectionListener.class.getName());
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    protected ConnectionManager cm;
    private ManagedConnection mc;
    private ManagedConnectionPool mcp;
    private Credential credential;
    private AtomicInteger state;
    protected CopyOnWriteArraySet<Object> connectionHandles;
    protected Map<Object, Exception> connectionTraces;
    private long validated;
    private long fromPool;
    private long toPool;
    private FlushStrategy flushStrategy;

    public AbstractConnectionListener(ConnectionManager cm, ManagedConnection mc, Credential credential, ManagedConnectionPool mcp, FlushStrategy flushStrategy) {
        long timestamp;
        this.cm = cm;
        this.mc = mc;
        this.mcp = mcp;
        this.flushStrategy = flushStrategy;
        this.credential = credential;
        this.state = new AtomicInteger(1);
        this.connectionHandles = new CopyOnWriteArraySet();
        if (cm.getConnectionManagerConfiguration().isTracking() != null && cm.getConnectionManagerConfiguration().isTracking().booleanValue()) {
            this.connectionTraces = new HashMap<Object, Exception>();
        }
        this.validated = timestamp = System.currentTimeMillis();
        this.fromPool = timestamp;
        this.toPool = timestamp;
        mc.addConnectionEventListener((ConnectionEventListener)this);
    }

    @Override
    public boolean changeState(int currentState, int newState) {
        return this.state.compareAndSet(currentState, newState);
    }

    @Override
    public int getState() {
        return this.state.get();
    }

    @Override
    public void setState(int state) {
        this.state.set(state);
    }

    @Override
    public Credential getCredential() {
        return this.credential;
    }

    public void connectionClosed(ConnectionEvent event) {
        Object connection = event.getConnectionHandle();
        this.removeConnection(connection);
        if (this.cm.getCachedConnectionManager() != null) {
            this.cm.getCachedConnectionManager().unregisterConnection(this.cm, this, connection);
        }
        if (this.connectionHandles.isEmpty() && !this.isEnlisted()) {
            this.cm.returnConnectionListener(this, false);
        }
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        if (this.getState() == 2) {
            Exception cause;
            if (event != null) {
                cause = event.getException();
                if (cause == null) {
                    cause = new Exception(bundle.noExceptionWasReported());
                }
                log.connectionErrorOccurred(this, cause);
            } else {
                cause = new Exception(bundle.noExceptionWasReported());
                log.unknownConnectionErrorOccurred(this, cause);
            }
        }
        Object connection = event.getConnectionHandle();
        this.removeConnection(connection);
        if (this.cm.getCachedConnectionManager() != null) {
            this.cm.getCachedConnectionManager().unregisterConnection(this.cm, this, connection);
        }
        if (this.cm.getCachedConnectionManager() != null) {
            for (Object c : this.connectionHandles) {
                this.cm.getCachedConnectionManager().unregisterConnection(this.cm, this, c);
            }
        }
        this.clearConnections();
        if (event != null && event.getSource() != this.getManagedConnection()) {
            log.notifiedErrorDifferentManagedConnection();
        }
        this.haltCatchFire();
        this.cm.returnConnectionListener(this, true);
        if (this.flushStrategy == FlushStrategy.FAILING_CONNECTION_ONLY) {
            this.mcp.prefill();
        } else if (this.flushStrategy == FlushStrategy.INVALID_IDLE_CONNECTIONS) {
            this.mcp.flush(FlushMode.INVALID);
        } else if (this.flushStrategy == FlushStrategy.IDLE_CONNECTIONS) {
            this.mcp.flush(FlushMode.IDLE);
        } else if (this.flushStrategy == FlushStrategy.GRACEFULLY) {
            this.mcp.flush(FlushMode.GRACEFULLY);
        } else if (this.flushStrategy == FlushStrategy.ENTIRE_POOL) {
            this.mcp.flush(FlushMode.ALL);
        } else if (this.flushStrategy == FlushStrategy.ALL_INVALID_IDLE_CONNECTIONS) {
            this.cm.getPool().flush(FlushMode.INVALID);
        } else if (this.flushStrategy == FlushStrategy.ALL_IDLE_CONNECTIONS) {
            this.cm.getPool().flush(FlushMode.IDLE);
        } else if (this.flushStrategy == FlushStrategy.ALL_GRACEFULLY) {
            this.cm.getPool().flush(FlushMode.GRACEFULLY);
        } else if (this.flushStrategy == FlushStrategy.ALL_CONNECTIONS) {
            this.cm.getPool().flush(FlushMode.ALL);
        }
    }

    public void localTransactionStarted(ConnectionEvent event) {
    }

    public void localTransactionCommitted(ConnectionEvent event) {
    }

    public void localTransactionRolledback(ConnectionEvent event) {
    }

    @Override
    public ManagedConnection getManagedConnection() {
        return this.mc;
    }

    @Override
    public ManagedConnectionPool getManagedConnectionPool() {
        return this.mcp;
    }

    @Override
    public Object getConnection() throws ResourceException {
        Object result = this.mc.getConnection(this.credential.getSubject(), this.credential.getConnectionRequestInfo());
        this.addConnection(result);
        return result;
    }

    @Override
    public Set<Object> getConnections() {
        return this.connectionHandles;
    }

    @Override
    public boolean addConnection(Object c) {
        if (Tracer.isEnabled()) {
            Tracer.getConnection(this.cm.getPool().getConfiguration().getId(), this.mcp, this, c);
        }
        if (this.connectionTraces != null) {
            this.connectionTraces.put(c, new Exception());
        }
        return this.connectionHandles.add(c);
    }

    @Override
    public boolean removeConnection(Object c) {
        if (Tracer.isEnabled()) {
            Tracer.returnConnection(this.cm.getPool().getConfiguration().getId(), this.mcp, this, c);
        }
        if (this.connectionTraces != null) {
            this.connectionTraces.remove(c);
        }
        return this.connectionHandles.remove(c);
    }

    @Override
    public void clearConnections() {
        if (Tracer.isEnabled()) {
            for (Object c : this.connectionHandles) {
                Tracer.returnConnection(this.cm.getPool().getConfiguration().getId(), this.mcp, this, c);
            }
        }
        if (this.connectionTraces != null) {
            this.connectionTraces.clear();
        }
        this.connectionHandles.clear();
    }

    @Override
    public long getValidated() {
        return this.validated;
    }

    @Override
    public void validated() {
        this.validated = System.currentTimeMillis();
    }

    @Override
    public long getFromPool() {
        return this.fromPool;
    }

    @Override
    public void fromPool() {
        this.fromPool = System.currentTimeMillis();
    }

    @Override
    public long getToPool() {
        return this.toPool;
    }

    @Override
    public void toPool() throws ResourceException {
        this.toPool = System.currentTimeMillis();
    }

    @Override
    public void handleCreated(Object h) {
        this.addConnection(h);
    }

    @Override
    public void handleClosed(Object h) {
        this.removeConnection(h);
    }

    void haltCatchFire() {
    }

    public int compareTo(Object o) {
        return 0;
    }
}

