/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.connectionmanager.listener;

import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.ironjacamar.common.api.metadata.common.FlushStrategy;
import org.ironjacamar.core.CoreLogger;
import org.ironjacamar.core.connectionmanager.ConnectionManager;
import org.ironjacamar.core.connectionmanager.Credential;
import org.ironjacamar.core.connectionmanager.TransactionalConnectionManager;
import org.ironjacamar.core.connectionmanager.listener.AbstractConnectionListener;
import org.ironjacamar.core.connectionmanager.listener.TransactionSynchronization;
import org.ironjacamar.core.connectionmanager.pool.ManagedConnectionPool;
import org.ironjacamar.core.spi.transaction.ConnectableResource;
import org.ironjacamar.core.spi.transaction.TransactionIntegration;
import org.ironjacamar.core.spi.transaction.TxUtils;
import org.ironjacamar.core.spi.transaction.local.LocalXAResource;
import org.ironjacamar.core.tracer.Tracer;
import org.jboss.logging.Logger;

public abstract class AbstractTransactionalConnectionListener
extends AbstractConnectionListener {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)AbstractTransactionalConnectionListener.class.getName());
    protected TransactionSynchronization transactionSynchronization = null;
    protected boolean enlisted = false;
    protected XAResource xaResource;
    protected int xaResourceTimeout;
    protected boolean localTransaction;

    public AbstractTransactionalConnectionListener(ConnectionManager cm, ManagedConnection mc, Credential credential, XAResource xaResource, int xaResourceTimeout, ManagedConnectionPool mcp, FlushStrategy flushStrategy) {
        super(cm, mc, credential, mcp, flushStrategy);
        this.xaResource = xaResource;
        this.xaResourceTimeout = xaResourceTimeout;
        this.localTransaction = false;
        if (xaResource instanceof LocalXAResource) {
            ((LocalXAResource)xaResource).setConnectionManager(cm);
            ((LocalXAResource)xaResource).setConnectionListener(this);
        }
        if (xaResource instanceof ConnectableResource) {
            ((ConnectableResource)((Object)xaResource)).setConnectableResourceListener(this);
        }
        this.resetXAResourceTimeout();
    }

    @Override
    public boolean isEnlisted() {
        return this.enlisted;
    }

    @Override
    public void enlist() throws ResourceException {
        if (this.isEnlisted() || this.getState() == 3 || this.getState() == 4) {
            return;
        }
        log.tracef("Enlisting: %s", this);
        try {
            TransactionalConnectionManager txCM = (TransactionalConnectionManager)this.cm;
            Transaction tx = txCM.getTransactionIntegration().getTransactionManager().getTransaction();
            this.transactionSynchronization = this.createTransactionSynchronization();
            this.transactionSynchronization.init(tx);
            this.transactionSynchronization.enlist();
            txCM.getTransactionIntegration().getTransactionSynchronizationRegistry().registerInterposedSynchronization((Synchronization)this.transactionSynchronization);
            this.enlisted = true;
            log.tracef("Enlisted: %s", this);
        }
        catch (ResourceException re) {
            throw re;
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    @Override
    public void delist() throws ResourceException {
        log.tracef("Delisting: %s", this);
        try {
            TransactionalConnectionManager txCM = (TransactionalConnectionManager)this.cm;
            TransactionManager tm = txCM.getTransactionIntegration().getTransactionManager();
            int status = tm.getStatus();
            if (status != 6 && this.enlisted) {
                Transaction tx = tm.getTransaction();
                boolean delistResult = tx.delistResource(this.xaResource, 0x4000000);
                if (Tracer.isEnabled()) {
                    Tracer.delistConnectionListener(this.cm.getPool().getConfiguration().getId(), this.getManagedConnectionPool(), this, tx.toString(), true, false, false);
                }
                if (delistResult) {
                    log.tracef("delist-success: %s", this);
                } else {
                    log.debugf("delist-success failed: %s", this);
                }
            }
            this.localTransaction = false;
            if (this.transactionSynchronization != null) {
                this.transactionSynchronization.cancel();
                this.transactionSynchronization = null;
            }
            this.enlisted = false;
            log.tracef("Delisted: %s", this);
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    @Override
    public void localTransactionStarted(ConnectionEvent ce) {
        this.localTransaction = true;
    }

    @Override
    public void localTransactionCommitted(ConnectionEvent ce) {
        this.localTransaction = false;
    }

    @Override
    public void localTransactionRolledback(ConnectionEvent ce) {
        this.localTransaction = false;
    }

    @Override
    public void toPool() throws ResourceException {
        if (this.localTransaction) {
            LocalTransaction localTransaction = null;
            ManagedConnection mc = this.getManagedConnection();
            try {
                localTransaction = mc.getLocalTransaction();
            }
            catch (Throwable t) {
                throw new ResourceException(t);
            }
            if (localTransaction == null) {
                throw new ResourceException();
            }
            localTransaction.rollback();
        }
        this.resetXAResourceTimeout();
        super.toPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void haltCatchFire() {
        if (this.isEnlisted()) {
            if (this.transactionSynchronization != null) {
                this.transactionSynchronization.cancel();
            }
            String txId = "";
            TransactionalConnectionManager txCM = (TransactionalConnectionManager)this.cm;
            TransactionIntegration ti = txCM.getTransactionIntegration();
            if (ti != null) {
                Transaction tx = null;
                try {
                    tx = ti.getTransactionManager().getTransaction();
                    if (Tracer.isEnabled() && tx != null) {
                        txId = tx.toString();
                    }
                    if (TxUtils.isUncommitted(tx)) {
                        log.tracef("connectionErrorOccurred: delistResource(%s, TMFAIL)", this.xaResource);
                        boolean failResult = tx.delistResource(this.xaResource, 0x20000000);
                        if (failResult) {
                            log.tracef("connectionErrorOccurred: delist-fail: %s", this);
                        } else {
                            log.debugf("connectionErrorOccurred: delist-fail failed: %s", this);
                        }
                    }
                }
                catch (Exception e) {
                    log.debugf(e, "connectionErrorOccurred: Exception during delistResource=%s", e.getMessage());
                }
                finally {
                    if (TxUtils.isUncommitted(tx)) {
                        try {
                            tx.setRollbackOnly();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            if (Tracer.isEnabled()) {
                Tracer.delistConnectionListener(this.cm.getPool().getConfiguration().getId(), this.getManagedConnectionPool(), this, txId, false, true, false);
            }
        }
        this.enlisted = false;
        this.transactionSynchronization = null;
    }

    private void resetXAResourceTimeout() {
        if (!(this.xaResource instanceof LocalXAResource) && this.xaResourceTimeout > 0) {
            try {
                this.xaResource.setTransactionTimeout(this.xaResourceTimeout);
            }
            catch (XAException e) {
                log.debugf(e, "Exception during resetXAResourceTimeout for %s", this);
            }
        }
    }

    protected TransactionSynchronization createTransactionSynchronization() {
        return new TransactionSynchronizationImpl();
    }

    class TransactionSynchronizationImpl
    implements TransactionSynchronization {
        private Transaction transaction;
        private boolean cancel;

        @Override
        public void init(Transaction tx) {
            this.transaction = tx;
            this.cancel = false;
        }

        @Override
        public void enlist() throws ResourceException {
            ResourceException enlistError;
            block8: {
                enlistError = null;
                try {
                    if (!this.transaction.enlistResource(AbstractTransactionalConnectionListener.this.xaResource)) {
                        if (Tracer.isEnabled()) {
                            Tracer.enlistConnectionListener(AbstractTransactionalConnectionListener.this.cm.getPool().getConfiguration().getId(), AbstractTransactionalConnectionListener.this.getManagedConnectionPool(), AbstractTransactionalConnectionListener.this, this.transaction.toString(), false, false);
                        }
                        enlistError = new ResourceException("Failed to enlist");
                    } else if (Tracer.isEnabled()) {
                        Tracer.enlistConnectionListener(AbstractTransactionalConnectionListener.this.cm.getPool().getConfiguration().getId(), AbstractTransactionalConnectionListener.this.getManagedConnectionPool(), AbstractTransactionalConnectionListener.this, this.transaction.toString(), true, false);
                    }
                }
                catch (Exception e) {
                    enlistError = new ResourceException((Throwable)e);
                    if (!Tracer.isEnabled()) break block8;
                    Tracer.enlistConnectionListener(AbstractTransactionalConnectionListener.this.cm.getPool().getConfiguration().getId(), AbstractTransactionalConnectionListener.this.getManagedConnectionPool(), AbstractTransactionalConnectionListener.this, this.transaction.toString(), false, false);
                }
            }
            if (enlistError != null) {
                if (Tracer.isEnabled()) {
                    Tracer.exception(AbstractTransactionalConnectionListener.this.cm.getPool().getConfiguration().getId(), AbstractTransactionalConnectionListener.this.getManagedConnectionPool(), AbstractTransactionalConnectionListener.this, enlistError);
                }
                AbstractTransactionalConnectionListener.this.transactionSynchronization = null;
                AbstractTransactionalConnectionListener.this.enlisted = false;
                throw enlistError;
            }
        }

        @Override
        public void cancel() {
            this.cancel = true;
        }

        public void beforeCompletion() {
            block9: {
                if (!this.cancel) {
                    log.tracef("beforeCompletion: %s", AbstractTransactionalConnectionListener.this);
                    try {
                        if (TxUtils.isUncommitted(this.transaction)) {
                            if (TxUtils.isActive(this.transaction)) {
                                log.tracef("delistResource(%s, TMSUCCESS)", AbstractTransactionalConnectionListener.this.xaResource);
                                this.transaction.delistResource(AbstractTransactionalConnectionListener.this.xaResource, 0x4000000);
                                if (Tracer.isEnabled()) {
                                    Tracer.delistConnectionListener(AbstractTransactionalConnectionListener.this.cm.getPool().getConfiguration().getId(), AbstractTransactionalConnectionListener.this.getManagedConnectionPool(), AbstractTransactionalConnectionListener.this, this.transaction.toString(), true, false, false);
                                }
                            } else {
                                log.tracef("delistResource(%s, TMFAIL)", AbstractTransactionalConnectionListener.this.xaResource);
                                this.transaction.delistResource(AbstractTransactionalConnectionListener.this.xaResource, 0x20000000);
                                if (Tracer.isEnabled()) {
                                    Tracer.delistConnectionListener(AbstractTransactionalConnectionListener.this.cm.getPool().getConfiguration().getId(), AbstractTransactionalConnectionListener.this.getManagedConnectionPool(), AbstractTransactionalConnectionListener.this, this.transaction.toString(), false, false, false);
                                }
                            }
                            break block9;
                        }
                        log.tracef("Non-uncommitted transaction for %s (%s)", AbstractTransactionalConnectionListener.this, this.transaction != null ? TxUtils.getStatusAsString(this.transaction.getStatus()) : "None");
                    }
                    catch (Exception e) {
                        log.beforeCompletionErrorOccured(AbstractTransactionalConnectionListener.this, e);
                    }
                } else {
                    log.tracef("Unenlisted resource: %s", AbstractTransactionalConnectionListener.this);
                }
            }
        }

        public void afterCompletion(int status) {
            if (!this.cancel) {
                log.tracef("afterCompletion(%s): %s", status, AbstractTransactionalConnectionListener.this);
                AbstractTransactionalConnectionListener.this.transactionSynchronization = null;
                AbstractTransactionalConnectionListener.this.enlisted = false;
                if (AbstractTransactionalConnectionListener.this.connectionHandles.isEmpty()) {
                    if (Tracer.isEnabled() && status == 4) {
                        Tracer.delistConnectionListener(AbstractTransactionalConnectionListener.this.cm.getPool().getConfiguration().getId(), AbstractTransactionalConnectionListener.this.getManagedConnectionPool(), AbstractTransactionalConnectionListener.this, "", true, true, false);
                    }
                    AbstractTransactionalConnectionListener.this.cm.returnConnectionListener(AbstractTransactionalConnectionListener.this, false);
                } else if (AbstractTransactionalConnectionListener.this.cm.getConnectionManagerConfiguration().isTracking() == null || AbstractTransactionalConnectionListener.this.cm.getConnectionManagerConfiguration().isTracking().booleanValue()) {
                    log.activeHandles(AbstractTransactionalConnectionListener.this.cm.getPool().getConfiguration().getId(), AbstractTransactionalConnectionListener.this.connectionHandles.size());
                    if (AbstractTransactionalConnectionListener.this.connectionTraces != null) {
                        for (Map.Entry entry : AbstractTransactionalConnectionListener.this.connectionTraces.entrySet()) {
                            log.activeHandle(entry.getKey(), (Exception)entry.getValue());
                        }
                        log.txConnectionListenerBoundary(new Exception());
                    }
                    if (Tracer.isEnabled()) {
                        for (Object c : AbstractTransactionalConnectionListener.this.connectionHandles) {
                            Tracer.clearConnection(AbstractTransactionalConnectionListener.this.cm.getPool().getConfiguration().getId(), AbstractTransactionalConnectionListener.this.getManagedConnectionPool(), AbstractTransactionalConnectionListener.this, c);
                        }
                    }
                    AbstractTransactionalConnectionListener.this.cm.returnConnectionListener(AbstractTransactionalConnectionListener.this, true);
                } else {
                    log.tracef(new Exception("Connection across boundary"), "ConnectionListener=%s", AbstractTransactionalConnectionListener.this);
                }
            }
        }
    }
}

