/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.connectionmanager.listener.stable;

import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.ironjacamar.common.api.metadata.common.FlushStrategy;
import org.ironjacamar.core.CoreBundle;
import org.ironjacamar.core.connectionmanager.ConnectionManager;
import org.ironjacamar.core.connectionmanager.Credential;
import org.ironjacamar.core.connectionmanager.listener.TransactionSynchronization;
import org.ironjacamar.core.connectionmanager.pool.ManagedConnectionPool;
import org.ironjacamar.core.connectionmanager.pool.stable.StablePool;
import org.ironjacamar.core.spi.transaction.TxUtils;
import org.jboss.logging.Messages;

public abstract class AbstractTransactionalConnectionListener
extends org.ironjacamar.core.connectionmanager.listener.AbstractTransactionalConnectionListener {
    CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);

    public AbstractTransactionalConnectionListener(ConnectionManager cm, ManagedConnection mc, Credential credential, XAResource xaResource, int xaResourceTimeout, ManagedConnectionPool mcp, FlushStrategy flushStrategy) {
        super(cm, mc, credential, xaResource, xaResourceTimeout, mcp, flushStrategy);
    }

    @Override
    public synchronized void enlist() throws ResourceException {
        if (this.isEnlisted()) {
            try {
                StablePool sp = (StablePool)this.cm.getPool();
                Object tx = sp.verifyConnectionListener(this);
                if (tx != null) {
                    throw new ResourceException(tx.toString());
                }
            }
            finally {
                this.setState(3);
            }
        }
        super.enlist();
    }

    @Override
    public synchronized void delist() throws ResourceException {
        if (!this.isEnlisted()) {
            this.setState(3);
        }
        super.delist();
    }

    @Override
    protected TransactionSynchronization createTransactionSynchronization() {
        return new TransactionSynchronizationImpl();
    }

    class TransactionSynchronizationImpl
    implements TransactionSynchronization {
        private Transaction transaction;
        private boolean cancel;
        private Throwable throwable;

        @Override
        public void init(Transaction tx) {
            this.transaction = tx;
            this.cancel = false;
            this.throwable = new Throwable(AbstractTransactionalConnectionListener.this.bundle.unableToEnlist());
        }

        @Override
        public void enlist() throws ResourceException {
            ResourceException enlistError = null;
            try {
                if (!this.transaction.enlistResource(AbstractTransactionalConnectionListener.this.xaResource)) {
                    enlistError = new ResourceException(AbstractTransactionalConnectionListener.this.bundle.failedToEnlist(), this.throwable);
                }
            }
            catch (Exception e) {
                enlistError = new ResourceException((Throwable)e);
                enlistError.initCause(this.throwable);
            }
            if (enlistError != null) {
                AbstractTransactionalConnectionListener.this.transactionSynchronization = null;
                AbstractTransactionalConnectionListener.this.enlisted = false;
                throw enlistError;
            }
        }

        @Override
        public void cancel() {
            this.cancel = true;
        }

        public void beforeCompletion() {
            if (!this.cancel) {
                try {
                    if (TxUtils.isUncommitted(this.transaction)) {
                        if (TxUtils.isActive(this.transaction)) {
                            this.transaction.delistResource(AbstractTransactionalConnectionListener.this.xaResource, 0x4000000);
                        } else {
                            this.transaction.delistResource(AbstractTransactionalConnectionListener.this.xaResource, 0x20000000);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void afterCompletion(int status) {
            if (!this.cancel) {
                AbstractTransactionalConnectionListener.this.transactionSynchronization = null;
                AbstractTransactionalConnectionListener.this.enlisted = false;
                if (AbstractTransactionalConnectionListener.this.connectionHandles.isEmpty()) {
                    AbstractTransactionalConnectionListener.this.cm.returnConnectionListener(AbstractTransactionalConnectionListener.this, false);
                }
            }
        }
    }
}

