/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.connectionmanager.pool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.ironjacamar.core.connectionmanager.listener.ConnectionListener;
import org.ironjacamar.core.connectionmanager.pool.Janitor;
import org.ironjacamar.core.connectionmanager.pool.Pool;
import org.ironjacamar.core.connectionmanager.pool.SecurityActions;
import org.jboss.logging.Logger;

public abstract class AbstractJanitor
implements Janitor {
    private static Logger log = Logger.getLogger(AbstractJanitor.class);
    private static String newLine = SecurityActions.getSystemProperty("line.separator");
    private Pool pool = null;
    private Map<ConnectionListener, Exception> listeners = new HashMap<ConnectionListener, Exception>();

    @Override
    public synchronized String[] dumpQueuedThreads() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.pool != null && this.pool.getPermits().hasQueuedThreads()) {
            ArrayList<Thread> queuedThreads = new ArrayList<Thread>(this.pool.getPermits().getQueuedThreads());
            for (Thread t : queuedThreads) {
                result.add(this.dumpQueuedThread(t));
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public synchronized Map<String, String> getConnectionListeners() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Map.Entry<ConnectionListener, Exception> entry : this.listeners.entrySet()) {
            String id = Integer.toHexString(System.identityHashCode(entry.getKey()));
            StringBuilder sb = new StringBuilder();
            for (StackTraceElement ste : entry.getValue().getStackTrace()) {
                sb = sb.append(ste.getClassName());
                sb = sb.append(":");
                sb = sb.append(ste.getMethodName());
                sb = sb.append(":");
                sb = sb.append(ste.getLineNumber());
                sb = sb.append(newLine);
            }
            result.put(id, sb.toString());
        }
        return result;
    }

    @Override
    public synchronized boolean killConnectionListener(String id) {
        ConnectionListener cl = null;
        Iterator<ConnectionListener> it = this.listeners.keySet().iterator();
        while (cl == null && it.hasNext()) {
            ConnectionListener l = it.next();
            if (!Integer.toHexString(System.identityHashCode(l)).equals(id)) continue;
            cl = l;
        }
        if (cl != null) {
            try {
                this.pool.returnConnectionListener(cl, true);
            }
            catch (Exception e) {
                log.tracef((Throwable)e, "killConnectionListener(%s)", (Object)id);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConnectionListener(ConnectionListener cl) {
        Map<ConnectionListener, Exception> map = this.listeners;
        synchronized (map) {
            this.listeners.put(cl, new Exception());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterConnectionListener(ConnectionListener cl) {
        Map<ConnectionListener, Exception> map = this.listeners;
        synchronized (map) {
            this.listeners.remove(cl);
        }
    }

    @Override
    public void setPool(Pool pool) {
        this.pool = pool;
    }

    private String dumpQueuedThread(Thread t) {
        StringBuilder sb = new StringBuilder();
        sb = sb.append("Queued thread: ");
        sb = sb.append(t.getName());
        sb = sb.append(newLine);
        StackTraceElement[] stes = SecurityActions.getStackTrace(t);
        if (stes != null) {
            for (StackTraceElement ste : stes) {
                sb = sb.append("  ");
                sb = sb.append(ste.getClassName());
                sb = sb.append(":");
                sb = sb.append(ste.getMethodName());
                sb = sb.append(":");
                sb = sb.append(ste.getLineNumber());
                sb = sb.append(newLine);
            }
        }
        return sb.toString();
    }
}

